/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether;

import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import java.io.IOException;
import java.util.List;
import net.creeperhost.minetogether.Keybindings;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.chat.FriendChatNotifier;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.chat.gui.ChatScreenInjection;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.connect.MineTogetherConnect;
import net.creeperhost.minetogether.lib.web.ApiClientResponse;
import net.creeperhost.minetogether.orderform.OrderForm;
import net.creeperhost.minetogether.serverlist.MineTogetherServerList;
import net.creeperhost.minetogether.serverlist.data.Server;
import net.creeperhost.minetogether.serverlist.web.GetServerRequest;
import net.creeperhost.minetogether.session.MineTogetherSession;
import net.creeperhost.minetogether.util.MTSessionProvider;
import net.creeperhost.polylib.client.modulargui.ModularGuiInjector;
import net.creeperhost.polylib.client.screen.ButtonHelper;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MineTogetherClient {
    private static final Logger LOGGER = LogManager.getLogger();
    private static ModularGuiInjector<ChatScreen> chatScreenInjection = new ModularGuiInjector(e -> e instanceof ChatScreen, e -> new ChatScreenInjection());
    private static boolean first = true;

    public static void init() {
        LOGGER.info("Initializing MineTogetherClient!");
        MineTogetherSession.getDefault().setProvider(new MTSessionProvider());
        MineTogetherSession.getDefault().onTokenRefreshed(token -> MineTogether.AUTH.setHeader("Authorization", "Bearer " + token));
        MineTogetherSession.getDefault().getTokenAsync();
        MineTogetherChat.init();
        MineTogetherServerList.init();
        OrderForm.init();
        MineTogetherConnect.init();
        FriendChatNotifier.init();
        Keybindings.init();
        ClientGuiEvent.INIT_POST.register(MineTogetherClient::onScreenOpen);
    }

    private static void onScreenOpen(Screen screen, ScreenAccess screenAccess) {
        if (screen instanceof TitleScreen && first) {
            Server server;
            first = false;
            String serverProp = System.getProperty("mt.server");
            if (serverProp == null) {
                return;
            }
            try {
                ApiClientResponse<GetServerRequest.Response> resp = MineTogether.API.execute(new GetServerRequest(serverProp));
                if (resp.apiResponse().getStatus().equals("error")) {
                    LOGGER.error("Failed to load server with id: {}. Message: {}", (Object)serverProp, (Object)resp.apiResponse().getMessageOrNull());
                    return;
                }
                server = resp.apiResponse().server;
                if (server == null) {
                    LOGGER.error("Returned empty server?");
                    return;
                }
            }
            catch (IOException ex) {
                LOGGER.error("Failed to query server.", (Throwable)ex);
                return;
            }
            ServerData serverData = new ServerData(server.ip, String.valueOf(server.port), false);
            ConnectScreen.m_169267_((Screen)new JoinMultiplayerScreen(screen), (Minecraft)Minecraft.m_91087_(), (ServerAddress)ServerAddress.m_171864_((String)serverData.f_105363_), (ServerData)serverData);
        } else if (screen instanceof PauseScreen) {
            List children = screen.m_6702_();
            List renderables = screenAccess.getRenderables();
            List narratables = screenAccess.getNarratables();
            Button bugs = ButtonHelper.findButton((String)"menu.reportBugs", (Screen)screen);
            if (bugs != null && Config.instance().issueTrackerUrl != null) {
                Button ourBugsButton = new Button(bugs.f_93620_, bugs.f_93621_, bugs.m_5711_(), bugs.m_93694_(), (Component)Component.m_237115_((String)"menu.reportBugs"), button -> {
                    String s = Config.instance().issueTrackerUrl;
                    Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(p_213069_2_ -> {
                        if (p_213069_2_) {
                            Util.m_137581_().m_137646_(s);
                        }
                        Minecraft.m_91087_().m_91152_(screen);
                    }, s, true));
                });
                children.set(children.indexOf(bugs), ourBugsButton);
                renderables.set(renderables.indexOf(bugs), ourBugsButton);
                narratables.set(narratables.indexOf(bugs), ourBugsButton);
                bugs = ourBugsButton;
            }
        }
    }
}

