/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.source.ISpecialSourceProvider;
import com.hollingsworth.arsnouveau.api.source.SourceManager;
import com.hollingsworth.arsnouveau.api.source.SourceProvider;
import com.hollingsworth.arsnouveau.common.block.tile.SourceJarTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class SourceUtil {
    public static List<ISpecialSourceProvider> canGiveSource(BlockPos pos, Level world, int range) {
        ArrayList<ISpecialSourceProvider> posList = new ArrayList<ISpecialSourceProvider>();
        BlockPos.m_121985_((BlockPos)pos, (int)range, (int)range, (int)range).forEach(b -> {
            SourceJarTile jar;
            BlockEntity patt1075$temp;
            if (world.m_46749_(b) && (patt1075$temp = world.m_7702_(b)) instanceof SourceJarTile && (jar = (SourceJarTile)patt1075$temp).canAcceptSource()) {
                posList.add(new SourceProvider(jar, b.m_7949_()));
            }
        });
        List<ISpecialSourceProvider> provider = SourceManager.INSTANCE.canGiveSourceNearby(pos, world, range);
        for (ISpecialSourceProvider p : provider) {
            posList.add(new SourceProvider(p));
        }
        return posList;
    }

    public static List<ISpecialSourceProvider> canTakeSource(BlockPos pos, Level world, int range) {
        ArrayList<ISpecialSourceProvider> posList = new ArrayList<ISpecialSourceProvider>();
        BlockPos.m_121985_((BlockPos)pos, (int)range, (int)range, (int)range).forEach(b -> {
            SourceJarTile jar;
            BlockEntity patt1782$temp;
            if (world.m_46749_(b) && (patt1782$temp = world.m_7702_(b)) instanceof SourceJarTile && (jar = (SourceJarTile)patt1782$temp).getSource() > 0) {
                posList.add(new SourceProvider(jar, b.m_7949_()));
            }
        });
        List<ISpecialSourceProvider> provider = SourceManager.INSTANCE.canTakeSourceNearby(pos, world, range);
        for (ISpecialSourceProvider p : provider) {
            posList.add(new SourceProvider(p));
        }
        return posList;
    }

    @Nullable
    public static ISpecialSourceProvider takeSource(BlockPos pos, Level level, int range, int source) {
        List<ISpecialSourceProvider> providers = SourceUtil.canTakeSource(pos, level, range);
        for (ISpecialSourceProvider provider : providers) {
            if (provider.getSource().getSource() < source) continue;
            provider.getSource().removeSource(source);
            return provider;
        }
        return null;
    }

    @Nullable
    public static ISpecialSourceProvider takeSourceWithParticles(BlockPos pos, Level level, int range, int source) {
        ISpecialSourceProvider result = SourceUtil.takeSource(pos, level, range, source);
        if (result != null) {
            EntityFollowProjectile aoeProjectile = new EntityFollowProjectile(level, result.getCurrentPos(), pos);
            level.m_7967_((Entity)aoeProjectile);
        }
        return result;
    }

    public static boolean hasSourceNearby(BlockPos pos, Level world, int range, int source) {
        Optional loc = BlockPos.m_121930_((BlockPos)pos, (int)range, (int)range, b -> {
            SourceJarTile jar;
            BlockEntity patt3459$temp = world.m_7702_(b);
            return patt3459$temp instanceof SourceJarTile && (jar = (SourceJarTile)patt3459$temp).getSource() >= source;
        });
        if (loc.isPresent()) {
            return true;
        }
        return SourceManager.INSTANCE.hasSourceNearby(pos, world, range, source) != null;
    }

    @Nullable
    @Deprecated(forRemoval=true)
    public static BlockPos takeSourceNearby(BlockPos pos, Level world, int range, int mana) {
        Optional loc = BlockPos.m_121930_((BlockPos)pos, (int)range, (int)range, b -> world.m_7702_(b) instanceof SourceJarTile && ((SourceJarTile)world.m_7702_(b)).getSource() >= mana);
        if (loc.isEmpty()) {
            return null;
        }
        BlockEntity blockEntity = world.m_7702_((BlockPos)loc.get());
        if (blockEntity instanceof SourceJarTile) {
            SourceJarTile tile = (SourceJarTile)blockEntity;
            tile.removeSource(mana);
        }
        return (BlockPos)loc.get();
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static BlockPos takeSourceNearbyWithParticles(BlockPos pos, Level world, int range, int mana) {
        BlockPos result = SourceUtil.takeSourceNearby(pos, world, range, mana);
        if (result != null) {
            EntityFollowProjectile aoeProjectile = new EntityFollowProjectile(world, result, pos);
            world.m_7967_((Entity)aoeProjectile);
        }
        return result;
    }

    @Nullable
    @Deprecated(forRemoval=true)
    public static BlockPos canGiveSourceClosest(BlockPos pos, Level world, int range) {
        Optional loc = BlockPos.m_121930_((BlockPos)pos, (int)range, (int)range, b -> {
            SourceJarTile jar;
            BlockEntity patt5189$temp = world.m_7702_(b);
            return patt5189$temp instanceof SourceJarTile && (jar = (SourceJarTile)patt5189$temp).canAcceptSource();
        });
        return loc.orElse(null);
    }

    @Deprecated(forRemoval=true)
    public static List<BlockPos> canGiveSourceAny(BlockPos pos, Level world, int range) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        BlockPos.m_121985_((BlockPos)pos, (int)range, (int)range, (int)range).forEach(b -> {
            SourceJarTile jar;
            BlockEntity patt5621$temp = world.m_7702_(b);
            if (patt5621$temp instanceof SourceJarTile && (jar = (SourceJarTile)patt5621$temp).canAcceptSource()) {
                posList.add(b.m_7949_());
            }
        });
        return posList;
    }

    @Deprecated(forRemoval=true)
    public static List<BlockPos> canTakeSourceAny(BlockPos pos, Level world, int range) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        BlockPos.m_121985_((BlockPos)pos, (int)range, (int)range, (int)range).forEach(b -> {
            SourceJarTile jar;
            BlockEntity patt6101$temp = world.m_7702_(b);
            if (patt6101$temp instanceof SourceJarTile && (jar = (SourceJarTile)patt6101$temp).getSource() > 0) {
                posList.add(b.m_7949_());
            }
        });
        return posList;
    }
}

