/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common.gui;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlockEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SBPPacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SyncClientInfoMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public abstract class BackpackContext {
    public abstract Optional<IStorageWrapper> getParentBackpackWrapper(Player var1);

    public abstract boolean shouldLockBackpackSlot(Player var1);

    public abstract IBackpackWrapper getBackpackWrapper(Player var1);

    public abstract int getBackpackSlotIndex();

    public abstract BackpackContext getSubBackpackContext(int var1);

    public abstract BackpackContext getParentBackpackContext();

    public abstract ContextType getType();

    public void toBuffer(FriendlyByteBuf packetBuffer) {
        this.getType().toBuffer(packetBuffer);
        this.addToBuffer(packetBuffer);
    }

    public abstract void addToBuffer(FriendlyByteBuf var1);

    public abstract boolean canInteractWith(Player var1);

    public BlockPos getBackpackPosition(Player playerEntity) {
        return playerEntity.m_20183_();
    }

    public Component getDisplayName(Player player) {
        return this.getBackpackWrapper(player).getBackpack().m_41786_();
    }

    public abstract void onUpgradeChanged(Player var1);

    public static BackpackContext fromBuffer(FriendlyByteBuf buffer, Level level) {
        ContextType type = ContextType.fromBuffer(buffer);
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ContextType.BLOCK_BACKPACK -> Block.fromBuffer(buffer);
            case ContextType.BLOCK_SUB_BACKPACK -> BlockSubBackpack.fromBuffer(buffer);
            case ContextType.ITEM_SUB_BACKPACK -> ItemSubBackpack.fromBuffer(buffer);
            case ContextType.ITEM_BACKPACK -> Item.fromBuffer(buffer);
            case ContextType.ANOTHER_PLAYER_BACKPACK -> AnotherPlayer.fromBuffer(buffer, level);
            case ContextType.ANOTHER_PLAYER_SUB_BACKPACK -> AnotherPlayerSubBackpack.fromBuffer(buffer, level);
        };
    }

    public boolean wasOpenFromInventory() {
        return false;
    }

    public static enum ContextType {
        BLOCK_BACKPACK(0),
        BLOCK_SUB_BACKPACK(1),
        ITEM_BACKPACK(2),
        ITEM_SUB_BACKPACK(3),
        ANOTHER_PLAYER_BACKPACK(4),
        ANOTHER_PLAYER_SUB_BACKPACK(5);

        private final int id;
        private static final Map<Integer, ContextType> ID_CONTEXTS;

        private ContextType(int id) {
            this.id = id;
        }

        public void toBuffer(FriendlyByteBuf buffer) {
            buffer.writeShort(this.id);
        }

        public static ContextType fromBuffer(FriendlyByteBuf buffer) {
            return ID_CONTEXTS.getOrDefault(buffer.readShort(), ITEM_BACKPACK);
        }

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (ContextType value : ContextType.values()) {
                builder.put((Object)value.id, (Object)value);
            }
            ID_CONTEXTS = builder.build();
        }
    }

    public static class Block
    extends BackpackContext {
        protected final BlockPos pos;

        public Block(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public BlockPos getBackpackPosition(Player playerEntity) {
            return this.pos;
        }

        @Override
        public void onUpgradeChanged(Player player) {
            if (!player.f_19853_.f_46443_) {
                WorldHelper.getBlockEntity((BlockGetter)player.f_19853_, (BlockPos)this.pos, BackpackBlockEntity.class).ifPresent(BackpackBlockEntity::refreshRenderState);
            }
        }

        @Override
        public Optional<IStorageWrapper> getParentBackpackWrapper(Player player) {
            return Optional.empty();
        }

        @Override
        public boolean shouldLockBackpackSlot(Player player) {
            return false;
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(Player player) {
            return WorldHelper.getBlockEntity((BlockGetter)player.f_19853_, (BlockPos)this.pos, BackpackBlockEntity.class).map(BackpackBlockEntity::getBackpackWrapper).orElse(IBackpackWrapper.Noop.INSTANCE);
        }

        @Override
        public int getBackpackSlotIndex() {
            return -1;
        }

        @Override
        public BackpackContext getSubBackpackContext(int subBackpackSlotIndex) {
            return new BlockSubBackpack(this.pos, subBackpackSlotIndex);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return this;
        }

        public static BackpackContext fromBuffer(FriendlyByteBuf packetBuffer) {
            return new Block(BlockPos.m_122022_((long)packetBuffer.readLong()));
        }

        @Override
        public void addToBuffer(FriendlyByteBuf packetBuffer) {
            packetBuffer.writeLong(this.pos.m_121878_());
        }

        @Override
        public boolean canInteractWith(Player player) {
            return player.f_19853_.m_7702_(this.pos) instanceof BackpackBlockEntity && player.m_20275_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5) <= 64.0;
        }

        @Override
        public ContextType getType() {
            return ContextType.BLOCK_BACKPACK;
        }
    }

    public static class BlockSubBackpack
    extends Block {
        private final int subBackpackSlotIndex;
        @Nullable
        private IStorageWrapper parentWrapper;

        public BlockSubBackpack(BlockPos pos, int subBackpackSlotIndex) {
            super(pos);
            this.subBackpackSlotIndex = subBackpackSlotIndex;
        }

        @Override
        public Optional<IStorageWrapper> getParentBackpackWrapper(Player player) {
            if (this.parentWrapper == null) {
                this.parentWrapper = super.getBackpackWrapper(player);
            }
            return Optional.of(this.parentWrapper);
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(Player player) {
            return this.getParentBackpackWrapper(player).map(parent -> (IBackpackWrapper)parent.getInventoryHandler().getStackInSlot(this.subBackpackSlotIndex).getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).orElse((Object)IBackpackWrapper.Noop.INSTANCE)).orElse(IBackpackWrapper.Noop.INSTANCE);
        }

        public static BackpackContext fromBuffer(FriendlyByteBuf packetBuffer) {
            return new BlockSubBackpack(BlockPos.m_122022_((long)packetBuffer.readLong()), packetBuffer.readInt());
        }

        @Override
        public void addToBuffer(FriendlyByteBuf packetBuffer) {
            super.addToBuffer(packetBuffer);
            packetBuffer.writeInt(this.subBackpackSlotIndex);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return new Block(this.pos);
        }

        @Override
        public ContextType getType() {
            return ContextType.BLOCK_SUB_BACKPACK;
        }

        @Override
        public Component getDisplayName(Player player) {
            return Component.m_237113_((String)("... > " + super.getDisplayName(player).getString()));
        }

        @Override
        public void onUpgradeChanged(Player player) {
        }
    }

    public static class ItemSubBackpack
    extends Item {
        private final int subBackpackSlotIndex;
        @Nullable
        private IStorageWrapper parentWrapper;

        public ItemSubBackpack(String handlerName, String identifier, int backpackSlotIndex, boolean parentOpenFromInventory, int subBackpackSlotIndex) {
            super(handlerName, identifier, backpackSlotIndex, parentOpenFromInventory);
            this.subBackpackSlotIndex = subBackpackSlotIndex;
        }

        @Override
        public Optional<IStorageWrapper> getParentBackpackWrapper(Player player) {
            if (this.parentWrapper == null) {
                this.parentWrapper = super.getBackpackWrapper(player);
            }
            return Optional.of(this.parentWrapper);
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(Player player) {
            return this.getParentBackpackWrapper(player).map(parent -> (IBackpackWrapper)parent.getInventoryHandler().getStackInSlot(this.subBackpackSlotIndex).getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).orElse((Object)IBackpackWrapper.Noop.INSTANCE)).orElse(IBackpackWrapper.Noop.INSTANCE);
        }

        public static BackpackContext fromBuffer(FriendlyByteBuf packetBuffer) {
            return new ItemSubBackpack(packetBuffer.m_130277_(), packetBuffer.m_130277_(), packetBuffer.readInt(), packetBuffer.readBoolean(), packetBuffer.readInt());
        }

        @Override
        public void addToBuffer(FriendlyByteBuf packetBuffer) {
            super.addToBuffer(packetBuffer);
            packetBuffer.writeInt(this.subBackpackSlotIndex);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return new Item(this.handlerName, this.identifier, this.backpackSlotIndex, super.wasOpenFromInventory());
        }

        @Override
        public ContextType getType() {
            return ContextType.ITEM_SUB_BACKPACK;
        }

        @Override
        public Component getDisplayName(Player player) {
            return Component.m_237113_((String)("... > " + super.getDisplayName(player).getString()));
        }

        @Override
        public void onUpgradeChanged(Player player) {
        }
    }

    public static class Item
    extends BackpackContext {
        protected final String handlerName;
        protected String identifier;
        protected final int backpackSlotIndex;
        private final boolean openFromInventory;

        public Item(String handlerName, int backpackSlotIndex) {
            this(handlerName, "", backpackSlotIndex);
        }

        public Item(String handlerName, String identifier, int backpackSlotIndex) {
            this(handlerName, identifier, backpackSlotIndex, false);
        }

        public Item(String handlerName, String identifier, int backpackSlotIndex, boolean openFromInventory) {
            this.handlerName = handlerName;
            this.identifier = identifier;
            this.backpackSlotIndex = backpackSlotIndex;
            this.openFromInventory = openFromInventory;
        }

        @Override
        public boolean wasOpenFromInventory() {
            return this.openFromInventory;
        }

        @Override
        public Optional<IStorageWrapper> getParentBackpackWrapper(Player player) {
            return Optional.empty();
        }

        @Override
        public boolean shouldLockBackpackSlot(Player player) {
            return PlayerInventoryProvider.get().getPlayerInventoryHandler(this.handlerName).map(PlayerInventoryHandler::isVisibleInGui).orElse(false);
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(Player player) {
            Optional<PlayerInventoryHandler> inventoryHandler = PlayerInventoryProvider.get().getPlayerInventoryHandler(this.handlerName);
            if (inventoryHandler.isEmpty()) {
                SophisticatedBackpacks.LOGGER.error("Error getting backpack wrapper - Unable to find inventory handler for \"{}\"", (Object)this.handlerName);
                return IBackpackWrapper.Noop.INSTANCE;
            }
            LazyOptional backpackWrapper = inventoryHandler.get().getStackInSlot(player, this.identifier, this.backpackSlotIndex).getCapability(CapabilityBackpackWrapper.getCapabilityInstance());
            if (!backpackWrapper.isPresent()) {
                SophisticatedBackpacks.LOGGER.error("Error getting backpack wrapper - Unable to find backpack at slot index {} in \"{}\" inventory handler", (Object)this.backpackSlotIndex, (Object)this.handlerName);
                return IBackpackWrapper.Noop.INSTANCE;
            }
            return (IBackpackWrapper)backpackWrapper.orElse((Object)IBackpackWrapper.Noop.INSTANCE);
        }

        @Override
        public void onUpgradeChanged(Player player) {
            if (!player.f_19853_.f_46443_ && this.handlerName.equals("main")) {
                IBackpackWrapper backpackWrapper = this.getBackpackWrapper(player);
                SBPPacketHandler.INSTANCE.sendToClient((ServerPlayer)player, new SyncClientInfoMessage(this.backpackSlotIndex, backpackWrapper.getRenderInfo().getNbt(), backpackWrapper.getColumnsTaken()));
            }
        }

        @Override
        public int getBackpackSlotIndex() {
            return this.backpackSlotIndex;
        }

        @Override
        public BackpackContext getSubBackpackContext(int subBackpackSlotIndex) {
            return new ItemSubBackpack(this.handlerName, this.identifier, this.backpackSlotIndex, this.openFromInventory, subBackpackSlotIndex);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return this;
        }

        @Override
        public ContextType getType() {
            return ContextType.ITEM_BACKPACK;
        }

        public static BackpackContext fromBuffer(FriendlyByteBuf packetBuffer) {
            return new Item(packetBuffer.m_130277_(), packetBuffer.m_130277_(), packetBuffer.readInt(), packetBuffer.readBoolean());
        }

        @Override
        public void addToBuffer(FriendlyByteBuf packetBuffer) {
            packetBuffer.m_130070_(this.handlerName);
            packetBuffer.m_130070_(this.identifier);
            packetBuffer.writeInt(this.backpackSlotIndex);
            packetBuffer.writeBoolean(this.openFromInventory);
        }

        @Override
        public boolean canInteractWith(Player player) {
            return true;
        }
    }

    public static class AnotherPlayer
    extends Item {
        protected final Player otherPlayer;

        public AnotherPlayer(String handlerName, String identifier, int backpackSlotIndex, Player otherPlayer) {
            super(handlerName, identifier, backpackSlotIndex);
            this.otherPlayer = otherPlayer;
        }

        @Override
        public boolean shouldLockBackpackSlot(Player player) {
            return false;
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(Player player) {
            return super.getBackpackWrapper(this.otherPlayer);
        }

        @Override
        public BackpackContext getSubBackpackContext(int subBackpackSlotIndex) {
            return new AnotherPlayerSubBackpack(this.otherPlayer, this.handlerName, this.identifier, this.backpackSlotIndex, subBackpackSlotIndex);
        }

        @Override
        public void addToBuffer(FriendlyByteBuf packetBuffer) {
            packetBuffer.writeInt(this.otherPlayer.m_19879_());
            packetBuffer.m_130070_(this.handlerName);
            packetBuffer.m_130070_(this.identifier);
            packetBuffer.writeInt(this.backpackSlotIndex);
        }

        @Override
        public boolean canInteractWith(Player player) {
            return player.m_20270_((Entity)this.otherPlayer) < 8.0f;
        }

        @Override
        public ContextType getType() {
            return ContextType.ANOTHER_PLAYER_BACKPACK;
        }

        @Override
        public Component getDisplayName(Player player) {
            return super.getDisplayName(this.otherPlayer);
        }

        public static BackpackContext fromBuffer(FriendlyByteBuf packetBuffer, Level level) {
            int playerId = packetBuffer.readInt();
            Player otherPlayer = (Player)level.m_6815_(playerId);
            return new AnotherPlayer(packetBuffer.m_130277_(), packetBuffer.m_130277_(), packetBuffer.readInt(), Objects.requireNonNull(otherPlayer));
        }
    }

    public static class AnotherPlayerSubBackpack
    extends AnotherPlayer {
        private final int subBackpackSlotIndex;
        @Nullable
        private IStorageWrapper parentWrapper;

        public AnotherPlayerSubBackpack(Player otherPlayer, String handlerName, String identifier, int backpackSlotIndex, int subBackpackSlotIndex) {
            super(handlerName, identifier, backpackSlotIndex, otherPlayer);
            this.subBackpackSlotIndex = subBackpackSlotIndex;
        }

        @Override
        public Optional<IStorageWrapper> getParentBackpackWrapper(Player player) {
            if (this.parentWrapper == null) {
                this.parentWrapper = super.getBackpackWrapper(player);
            }
            return Optional.of(this.parentWrapper);
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(Player player) {
            return this.getParentBackpackWrapper(this.otherPlayer).map(parent -> (IBackpackWrapper)parent.getInventoryHandler().getStackInSlot(this.subBackpackSlotIndex).getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).orElse((Object)IBackpackWrapper.Noop.INSTANCE)).orElse(IBackpackWrapper.Noop.INSTANCE);
        }

        @Override
        public void addToBuffer(FriendlyByteBuf packetBuffer) {
            super.addToBuffer(packetBuffer);
            packetBuffer.writeInt(this.subBackpackSlotIndex);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return new AnotherPlayer(this.handlerName, this.identifier, this.backpackSlotIndex, this.otherPlayer);
        }

        @Override
        public ContextType getType() {
            return ContextType.ANOTHER_PLAYER_SUB_BACKPACK;
        }

        @Override
        public Component getDisplayName(Player player) {
            return Component.m_237113_((String)("... > " + super.getDisplayName(player).getString()));
        }

        public static BackpackContext fromBuffer(FriendlyByteBuf packetBuffer, Level level) {
            int playerId = packetBuffer.readInt();
            Player otherPlayer = (Player)level.m_6815_(playerId);
            return new AnotherPlayerSubBackpack(Objects.requireNonNull(otherPlayer), packetBuffer.m_130277_(), packetBuffer.m_130277_(), packetBuffer.readInt(), packetBuffer.readInt());
        }

        @Override
        public void onUpgradeChanged(Player player) {
        }
    }
}

