/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.rainshield.client;

import com.mrbysco.rainshield.RainShield;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class RainShieldConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        RainShield.LOGGER.debug("Loaded Rain Shield's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        RainShield.LOGGER.warn("Rain Shield's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue rainShieldDistance;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.rainShieldDistance = builder.comment("Defines the range in which the Rain Shield stops rendering rain [default: 80]").defineInRange("rainShieldDistance", 80, 1, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

