/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.tileentity;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mod.pianomanu.blockcarpentry.block.FrameBlock;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.util.BCNBTUtils;
import mod.pianomanu.blockcarpentry.util.ExceptionHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.extensions.IForgeBlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface IFrameTile
extends IForgeBlockEntity {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final List<TagPacket<?>> TAG_PACKETS = IFrameTile.initTagPackets();

    private static List<TagPacket<?>> initTagPackets() {
        ArrayList packets = new ArrayList();
        packets.add(new TagPacket<BlockState>("mimic", BlockState.class, Blocks.f_50016_.m_49966_()));
        packets.add(new TagPacket<Integer>("texture", Integer.class, 0));
        packets.add(new TagPacket<Integer>("design", Integer.class, 0));
        packets.add(new TagPacket<Integer>("designTexture", Integer.class, 0));
        packets.add(new TagPacket<Integer>("glassColor", Integer.class, 0));
        packets.add(new TagPacket<Integer>("overlay", Integer.class, 0));
        packets.add(new TagPacket<Integer>("pillowColor", Integer.class, 0));
        packets.add(new TagPacket<Integer>("blanketColor", Integer.class, 0));
        packets.add(new TagPacket<Integer>("rotation", Integer.class, 0));
        packets.add(new TagPacket<Boolean>("keepUV", Boolean.class, true));
        packets.add(new TagPacket<Boolean>("faceRemainRectangle", Boolean.class, true));
        packets.add(new TagPacket<Float>("friction", Float.class, Float.valueOf(((FrameBlock)Registration.FRAMEBLOCK.get()).m_49958_())));
        packets.add(new TagPacket<Float>("explosionResistance", Float.class, Float.valueOf(((FrameBlock)Registration.FRAMEBLOCK.get()).m_7325_())));
        packets.add(new TagPacket<Boolean>("canSustainPlant", Boolean.class, false));
        packets.add(new TagPacket<Integer>("enchantPowerBonus", Integer.class, 0));
        packets.add(new TagPacket<DyeColor>("color", DyeColor.class, DyeColor.BLACK));
        packets.add(new TagPacket<Boolean>("hasGlowingText", Boolean.class, false));
        packets.add(new TagPacket<Vec3>("NWU", Vec3.class, Vec3.f_82478_));
        packets.add(new TagPacket<Vec3>("NEU", Vec3.class, Vec3.f_82478_));
        packets.add(new TagPacket<Vec3>("NWD", Vec3.class, Vec3.f_82478_));
        packets.add(new TagPacket<Vec3>("NED", Vec3.class, Vec3.f_82478_));
        packets.add(new TagPacket<Vec3>("SWU", Vec3.class, Vec3.f_82478_));
        packets.add(new TagPacket<Vec3>("SEU", Vec3.class, Vec3.f_82478_));
        packets.add(new TagPacket<Vec3>("SWD", Vec3.class, Vec3.f_82478_));
        packets.add(new TagPacket<Vec3>("SED", Vec3.class, Vec3.f_82478_));
        packets.add(new TagPacket("directions", List.class, new ArrayList()));
        packets.add(new TagPacket<List<Integer>>("rotations", List.class, Arrays.asList(0, 0, 0, 0, 0, 0)));
        return packets;
    }

    private static <V> V readDataType(CompoundTag tag, String tagElement, Class<V> classType, V defaultValue) {
        try {
            if (classType == BlockState.class) {
                return (V)NbtUtils.m_129241_((CompoundTag)tag.m_128469_(tagElement));
            }
            if (classType == Integer.class) {
                if (IFrameTile.readInteger(tag) != 0) {
                    return (V)IFrameTile.readInteger(tag);
                }
                return (V)Integer.valueOf(tag.m_128451_(tagElement));
            }
            if (classType == Float.class) {
                return (V)Float.valueOf(tag.m_128457_(tagElement));
            }
            if (classType == Boolean.class) {
                return (V)Boolean.valueOf(tag.m_128471_(tagElement));
            }
            if (classType == DyeColor.class) {
                return (V)DyeColor.valueOf((String)tag.m_128461_(tagElement).toUpperCase());
            }
            if (classType == Vec3.class) {
                return (V)BCNBTUtils.readVec(tag.m_128461_(tagElement));
            }
            if (Objects.equals(tagElement, "directions")) {
                return (V)BCNBTUtils.readDirectionList(tag.m_128465_(tagElement));
            }
            if (Objects.equals(tagElement, "rotations")) {
                return (V)BCNBTUtils.readRotationsList(tag.m_128465_(tagElement));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
        }
        return defaultValue;
    }

    private static Integer readInteger(CompoundTag tag) {
        if (!tag.m_128425_("number", 8)) {
            return 0;
        }
        try {
            return Integer.parseInt(tag.m_128461_("number"));
        }
        catch (NumberFormatException e) {
            LOGGER.error("Not a valid Number Format: " + tag.m_128461_("number"));
            return 0;
        }
    }

    public BlockState getMimic();

    public void setMimic(BlockState var1);

    public Integer getTexture();

    public void setTexture(Integer var1);

    public Integer getDesign();

    public void setDesign(Integer var1);

    public Integer getDesignTexture();

    public void setDesignTexture(Integer var1);

    public Integer getGlassColor();

    public void setGlassColor(Integer var1);

    public Integer getRotation();

    public void setRotation(Integer var1);

    public Integer getOverlay();

    public void setOverlay(Integer var1);

    public Float getFriction();

    public void setFriction(Float var1);

    public Float getExplosionResistance();

    public void setExplosionResistance(Float var1);

    public Boolean getCanSustainPlant();

    public void setCanSustainPlant(Boolean var1);

    public Integer getEnchantPowerBonus();

    public void setEnchantPowerBonus(Integer var1);

    public Boolean getCanEntityDestroy();

    public void setCanEntityDestroy(Boolean var1);

    default public <V> V read(CompoundTag tag, String tagElement, Class<V> classType, V defaultValue) {
        if (!tag.m_128441_(tagElement)) {
            return defaultValue;
        }
        try {
            return IFrameTile.readDataType(tag, tagElement, classType, defaultValue);
        }
        catch (Exception e) {
            LOGGER.error("Not a valid " + tagElement + " Format: " + tag.m_128461_(tagElement));
            return defaultValue;
        }
    }

    default public <V> V read(CompoundTag tag, TagPacket<V> tagPacket) {
        return this.read(tag, tagPacket.TAG_ELEMENT, tagPacket.CLASS_TYPE, tagPacket.DEFAULT);
    }

    default public <V> void write(CompoundTag tag, String tagElement, V newElement) {
        if (newElement != null) {
            if (newElement.getClass() == Integer.class) {
                tag.m_128405_(tagElement, ((Integer)newElement).intValue());
            } else if (newElement.getClass() == Float.class) {
                tag.m_128350_(tagElement, ((Float)newElement).floatValue());
            } else if (newElement.getClass() == Boolean.class) {
                tag.m_128379_(tagElement, ((Boolean)newElement).booleanValue());
            } else if (newElement.getClass() == BlockState.class) {
                tag.m_128365_(tagElement, (Tag)NbtUtils.m_129202_((BlockState)((BlockState)newElement)));
            } else if (newElement.getClass() == DyeColor.class) {
                tag.m_128359_(tagElement, ((DyeColor)newElement).m_41065_());
            } else if (newElement.getClass() == Vec3.class) {
                tag.m_128359_(tagElement, ((Vec3)newElement).toString());
            } else if (Objects.equals(tagElement, "directions")) {
                BCNBTUtils.writeDirectionList(tag, (List)newElement);
            } else if (Objects.equals(tagElement, "rotations")) {
                BCNBTUtils.writeRotationsList(tag, (List)newElement);
            }
        }
    }

    default public <V> void onDataPacket(ClientboundBlockEntityDataPacket pkt, Class<?> cls, Level level, BlockPos pos, BlockState state) {
        CompoundTag tag = pkt.m_131708_();
        try {
            for (TagPacket<?> tagPacket : TAG_PACKETS) {
                List fs = Arrays.stream(cls.getFields()).filter(f -> !Modifier.isStatic(f.getModifiers()) && Modifier.isPublic(f.getModifiers()) && !Modifier.isFinal(f.getModifiers())).collect(Collectors.toList());
                for (Field f2 : fs) {
                    if (!f2.getName().equals(tagPacket.TAG_ELEMENT)) continue;
                    try {
                        Object oldValue = f2.get(this);
                        Object newValue = this.update(tag, tagPacket.TAG_ELEMENT, oldValue, tagPacket.CLASS_TYPE, tagPacket.DEFAULT, level, pos, state);
                        f2.set(this, newValue);
                    }
                    catch (IllegalAccessException e) {
                        ExceptionHandler.handleException(e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Critical BlockState found: " + state.toString());
            IFrameTile.handleException(e, tag, "getUpdateTag");
        }
    }

    private <V> V update(CompoundTag tag, String tagElement, V oldValue, Class<V> classType, V defaultValue, Level level, BlockPos pos, BlockState state) {
        if (tag.m_128441_(tagElement)) {
            V newValue = this.read(tag, tagElement, classType, defaultValue);
            if (!Objects.equals(oldValue, newValue)) {
                this.requestModelDataUpdate();
                level.m_7260_(pos, state, state, 3);
            }
            return newValue;
        }
        return null;
    }

    default public CompoundTag getUpdateTag(CompoundTag tag, Class<?> cls) {
        try {
            for (TagPacket<?> tagPacket : TAG_PACKETS) {
                List fs = Arrays.stream(cls.getFields()).filter(f -> !Modifier.isStatic(f.getModifiers()) && Modifier.isPublic(f.getModifiers()) && !Modifier.isFinal(f.getModifiers())).collect(Collectors.toList());
                for (Field f2 : fs) {
                    if (!f2.getName().equals(tagPacket.TAG_ELEMENT)) continue;
                    try {
                        this.write(tag, tagPacket.TAG_ELEMENT, f2.get(this));
                    }
                    catch (IllegalAccessException e) {
                        ExceptionHandler.handleException(e);
                    }
                }
            }
        }
        catch (Exception e) {
            IFrameTile.handleException(e, tag, "getUpdateTag");
        }
        return tag;
    }

    default public void load(CompoundTag tag, Class<?> cls) {
        try {
            for (TagPacket<?> tagPacket : TAG_PACKETS) {
                List fs = Arrays.stream(cls.getFields()).filter(f -> !Modifier.isStatic(f.getModifiers()) && Modifier.isPublic(f.getModifiers()) && !Modifier.isFinal(f.getModifiers())).collect(Collectors.toList());
                for (Field f2 : fs) {
                    if (!f2.getName().equals(tagPacket.TAG_ELEMENT)) continue;
                    try {
                        f2.set(this, this.read(tag, tagPacket));
                    }
                    catch (IllegalAccessException e) {
                        ExceptionHandler.handleException(e);
                    }
                }
            }
        }
        catch (Exception e) {
            IFrameTile.handleException(e, tag, "load");
        }
    }

    default public void saveAdditional(CompoundTag tag, Class<?> cls) {
        try {
            for (TagPacket<?> tagPacket : TAG_PACKETS) {
                List fs = Arrays.stream(cls.getFields()).filter(f -> !Modifier.isStatic(f.getModifiers()) && Modifier.isPublic(f.getModifiers()) && !Modifier.isFinal(f.getModifiers())).collect(Collectors.toList());
                for (Field f2 : fs) {
                    if (!f2.getName().equals(tagPacket.TAG_ELEMENT)) continue;
                    try {
                        this.write(tag, tagPacket.TAG_ELEMENT, f2.get(this));
                    }
                    catch (IllegalAccessException e) {
                        ExceptionHandler.handleException(e);
                    }
                }
            }
        }
        catch (Exception e) {
            IFrameTile.handleException(e, tag, "saveAdditional");
        }
    }

    default public void clear() {
        this.setMimic(null);
    }

    private static void handleException(Exception e, CompoundTag tag, String phase) {
        LOGGER.error("An exception occurred with CompoundTag " + tag.toString() + " during the " + phase + " phase!");
        ExceptionHandler.handleException(e);
    }

    public static class TagPacket<V> {
        public final String TAG_ELEMENT;
        public final Class<V> CLASS_TYPE;
        public final V DEFAULT;

        public TagPacket(String tagElement, Class<V> classType, V defaultValue) {
            this.TAG_ELEMENT = tagElement;
            this.CLASS_TYPE = classType;
            this.DEFAULT = defaultValue;
        }
    }
}

