/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.program.IInputResourceTracker;
import ca.teamdman.sfm.common.program.IOutputResourceTracker;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.ResourceLimit;
import ca.teamdman.sfml.ast.ToStringPretty;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResourceLimits
implements ASTNode,
ToStringPretty {
    private final List<ResourceLimit> resourceLimitList;
    private final ResourceIdSet exclusions;
    private @NotNull ResourceType<?, ?, ?> @Nullable [] referencedResourceTypes = null;

    public ResourceLimits(List<ResourceLimit> resourceLimitList, ResourceIdSet exclusions) {
        this.resourceLimitList = resourceLimitList;
        this.exclusions = exclusions;
    }

    public List<IInputResourceTracker> createInputTrackers() {
        ObjectArrayList rtn = new ObjectArrayList(this.resourceLimitList.size());
        for (ResourceLimit rl : this.resourceLimitList) {
            rtn.add(rl.createInputTracker(this.exclusions));
        }
        return rtn;
    }

    public List<IOutputResourceTracker> createOutputTrackers() {
        ObjectArrayList rtn = new ObjectArrayList(this.resourceLimitList.size());
        for (ResourceLimit rl : this.resourceLimitList) {
            rtn.add(rl.createOutputTracker(this.exclusions));
        }
        return rtn;
    }

    public ResourceLimits withDefaultLimit(Limit limit) {
        ObjectArrayList defaulted = new ObjectArrayList(this.resourceLimitList.size());
        for (ResourceLimit rl : this.resourceLimitList) {
            defaulted.add(rl.withDefaultLimit(limit));
        }
        return new ResourceLimits((List<ResourceLimit>)defaulted, this.exclusions);
    }

    public ResourceLimits withExclusions(ResourceIdSet exclusions) {
        return new ResourceLimits(this.resourceLimitList, exclusions);
    }

    public ResourceType<?, ?, ?>[] getReferencedResourceTypes() {
        if (this.referencedResourceTypes == null) {
            LinkedHashSet found = new LinkedHashSet(SFMResourceTypes.getResourceTypeCount());
            for (ResourceLimit resourceLimit : this.resourceLimitList) {
                found.addAll(Arrays.asList(resourceLimit.resourceIds().getReferencedResourceTypes()));
                this.referencedResourceTypes = found.toArray(new ResourceType[0]);
            }
        }
        return this.referencedResourceTypes;
    }

    public String toString() {
        Object rtn = this.resourceLimitList.stream().map(ResourceLimit::toString).collect(Collectors.joining(",\n"));
        if (!this.exclusions.isEmpty()) {
            rtn = (String)rtn + "\nEXCEPT\n" + this.exclusions.stream().map(ResourceIdentifier::toString).collect(Collectors.joining(",\n"));
        }
        return rtn;
    }

    public String toStringCondensed(Limit defaults) {
        Object rtn = this.resourceLimitList.stream().map(rl -> rl.toStringCondensed(defaults)).map(x -> this.resourceLimitList.size() == 1 ? x : x + ",").collect(Collectors.joining("\n"));
        if (!this.exclusions.isEmpty()) {
            rtn = (String)rtn + "\nEXCEPT\n" + this.exclusions.stream().map(ResourceIdentifier::toStringCondensed).collect(Collectors.joining(",\n"));
        }
        return rtn;
    }

    public List<ResourceLimit> resourceLimitList() {
        return this.resourceLimitList;
    }

    public ResourceIdSet exclusions() {
        return this.exclusions;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ResourceLimits that = (ResourceLimits)obj;
        return Objects.equals(this.resourceLimitList, that.resourceLimitList) && Objects.equals(this.exclusions, that.exclusions);
    }

    public int hashCode() {
        return Objects.hash(this.resourceLimitList, this.exclusions);
    }
}

