/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program.linting;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.compat.SFMMekanismCompat;
import ca.teamdman.sfm.common.compat.SFMModCompat;
import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.program.linting.GatherWarningsProgramBehaviour;
import ca.teamdman.sfm.common.registry.SFMCapabilityProviderMappers;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.DirectionQualifier;
import ca.teamdman.sfml.ast.IOStatement;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.OutputStatement;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.ResourceQuantity;
import ca.teamdman.sfml.ast.RoundRobin;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mekanism.api.RelativeSide;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgramLinter {
    public static ArrayList<TranslatableContents> gatherWarnings(Program program, LabelPositionHolder labelPositionHolder, @Nullable ManagerBlockEntity manager) {
        int after;
        ArrayList<TranslatableContents> warnings = new ArrayList<TranslatableContents>();
        Level level = manager != null ? manager.m_58904_() : null;
        int before = warnings.size();
        ProgramLinter.addWarningsForLabelsInProgramButNotInHolder(program, labelPositionHolder, warnings);
        ProgramLinter.addWarningsForLabelsInHolderButNotInProgram(program, labelPositionHolder, warnings);
        if (level != null) {
            ProgramLinter.addWarningsForLabelsUsedInWorldButNotConnectedByCables(manager, labelPositionHolder, warnings, level);
        }
        if (before != (after = warnings.size())) {
            warnings.add(LocalizationKeys.PROGRAM_REMINDER_PUSH_LABELS.get());
        }
        ProgramLinter.addWarningsForUsingIOWithoutCorrespondingOppositeIO(program, labelPositionHolder, warnings);
        ProgramLinter.addWarningsForResourcesReferencedButNotFoundInRegistry(program, warnings);
        program.getDescendantStatements().filter(IOStatement.class::isInstance).map(IOStatement.class::cast).forEach(statement -> {
            ProgramLinter.addWarningsForSmellyRoundRobinUsage(warnings, statement);
            ProgramLinter.addWarningsForUsingEachWithoutAPattern(warnings, statement);
            if (level != null) {
                ProgramLinter.addWarningsForSmellyMekanismAccess(statement, labelPositionHolder, statement, level, warnings);
            }
        });
        return warnings;
    }

    public static void fixWarnings(ManagerBlockEntity manager, ItemStack disk, Program program) {
        ProgramLinter.fixWarningsByRemovingBadLabelsFromDisk(manager, disk, program);
        LabelPositionHolder labelPositionHolder = LabelPositionHolder.from(disk);
        Level level = manager.m_58904_();
        if (level != null) {
            program.getDescendantStatements().filter(IOStatement.class::isInstance).map(IOStatement.class::cast).forEach(statement -> ProgramLinter.fixWarningsByModifyingMekanismAccess(statement, labelPositionHolder, level));
        }
        manager.rebuildProgramAndUpdateDisk();
    }

    private static void fixWarningsByRemovingBadLabelsFromDisk(ManagerBlockEntity manager, ItemStack disk, Program program) {
        LabelPositionHolder labels = LabelPositionHolder.from(disk);
        labels.removeIf(label -> !program.referencedLabels().contains(label));
        CableNetworkManager.getOrRegisterNetworkFromManagerPosition(manager).ifPresent(network -> labels.removeIf((label, pos) -> !network.isAdjacentToCable((BlockPos)pos)));
        Level level = manager.m_58904_();
        assert (level != null);
        labels.removeIf((label, pos) -> SFMCapabilityProviderMappers.discoverCapabilityProvider(level, pos) == null);
        labels.save(disk);
        DiskItem.setWarnings(disk, ProgramLinter.gatherWarnings(program, labels, manager));
    }

    private static void fixWarningsByModifyingMekanismAccess(IOStatement statement, LabelPositionHolder labelPositionHolder, Level level) {
        DataType fixed;
        Predicate<DataType> dataTypePredicate;
        if (!SFMModCompat.isMekanismLoaded()) {
            return;
        }
        DirectionQualifier directions = statement.labelAccess().directions();
        Stream<Pair> mekanismBlocks = statement.labelAccess().getLabelledPositions(labelPositionHolder).stream().filter(pair -> level.m_46749_((BlockPos)pair.getSecond())).filter(pair -> SFMModCompat.isMekanismBlock(level, (BlockPos)pair.getSecond()));
        EnumSet<TransmissionType> referencedTransmissionTypes = SFMMekanismCompat.getReferencedTransmissionTypes(statement);
        if (statement instanceof InputStatement) {
            dataTypePredicate = DataType::canOutput;
            fixed = DataType.OUTPUT;
        } else if (statement instanceof OutputStatement) {
            dataTypePredicate = dataType -> dataType == DataType.INPUT || dataType == DataType.INPUT_OUTPUT || dataType == DataType.INPUT_1 || dataType == DataType.INPUT_2;
            fixed = DataType.INPUT;
        } else {
            throw new IllegalStateException("Unexpected value: " + statement);
        }
        mekanismBlocks.forEach(pair -> {
            BlockPos blockPos = (BlockPos)pair.getSecond();
            BlockEntity patt7097$temp = level.m_7702_(blockPos);
            if (patt7097$temp instanceof ISideConfiguration) {
                ISideConfiguration mekBlockEntity = (ISideConfiguration)patt7097$temp;
                TileComponentConfig mekBlockEntityConfig = mekBlockEntity.getConfig();
                for (TransmissionType transmissionType : referencedTransmissionTypes) {
                    Direction statementSide;
                    boolean anySuccess = false;
                    ConfigInfo transmissionConfig = mekBlockEntityConfig.getConfig(transmissionType);
                    if (transmissionConfig == null) continue;
                    Set activeSides = transmissionConfig.getSides(dataTypePredicate);
                    for (Direction direction : directions) {
                        if (!activeSides.contains(direction)) continue;
                        anySuccess = true;
                        break;
                    }
                    if (anySuccess || (statementSide = directions.iterator().next()) == null) continue;
                    RelativeSide relativeSide = RelativeSide.fromDirections((Direction)mekBlockEntity.getDirection(), (Direction)statementSide);
                    transmissionConfig.setDataType(fixed, new RelativeSide[]{relativeSide});
                    mekBlockEntityConfig.sideChanged(transmissionType, relativeSide);
                }
            }
        });
    }

    private static void addWarningsForSmellyMekanismAccess(IOStatement ioStatement, LabelPositionHolder labelPositionHolder, IOStatement statement, Level level, ArrayList<TranslatableContents> warnings) {
        if (!SFMModCompat.isMekanismLoaded()) {
            return;
        }
        DirectionQualifier directions = statement.labelAccess().directions();
        Stream<Pair> mekanismBlocks = statement.labelAccess().getLabelledPositions(labelPositionHolder).stream().filter(pair -> level.m_46749_((BlockPos)pair.getSecond())).filter(pair -> SFMModCompat.isMekanismBlock(level, (BlockPos)pair.getSecond()));
        if (directions.equals(DirectionQualifier.NULL_DIRECTION)) {
            mekanismBlocks.forEach(pair -> warnings.add(LocalizationKeys.PROGRAM_WARNING_MEKANISM_USED_WITHOUT_DIRECTION.get(pair.getFirst(), statement.toStringPretty())));
        } else {
            Predicate<DataType> dataTypePredicate;
            EnumSet<TransmissionType> referencedTransmissionTypes = SFMMekanismCompat.getReferencedTransmissionTypes(statement);
            if (ioStatement instanceof InputStatement) {
                dataTypePredicate = DataType::canOutput;
            } else if (ioStatement instanceof OutputStatement) {
                dataTypePredicate = dataType -> dataType == DataType.INPUT || dataType == DataType.INPUT_OUTPUT || dataType == DataType.INPUT_1 || dataType == DataType.INPUT_2;
            } else {
                throw new IllegalStateException("Unexpected value: " + ioStatement);
            }
            mekanismBlocks.forEach(pair -> {
                BlockPos blockPos = (BlockPos)pair.getSecond();
                BlockEntity patt11195$temp = level.m_7702_(blockPos);
                if (patt11195$temp instanceof ISideConfiguration) {
                    ISideConfiguration mekBlockEntity = (ISideConfiguration)patt11195$temp;
                    TileComponentConfig config = mekBlockEntity.getConfig();
                    for (TransmissionType transmissionType : referencedTransmissionTypes) {
                        boolean anySuccess = false;
                        ConfigInfo transmissionConfig = config.getConfig(transmissionType);
                        if (transmissionConfig != null) {
                            Set activeSides = transmissionConfig.getSides(dataTypePredicate);
                            for (Direction direction : directions) {
                                if (!activeSides.contains(direction)) continue;
                                anySuccess = true;
                                break;
                            }
                        }
                        if (anySuccess) continue;
                        warnings.add(LocalizationKeys.PROGRAM_WARNING_MEKANISM_BAD_SIDE_CONFIG.get(blockPos, pair.getFirst(), statement.toStringPretty()));
                    }
                }
            });
        }
    }

    private static void addWarningsForUsingIOWithoutCorrespondingOppositeIO(Program program, LabelPositionHolder labelPositionHolder, ArrayList<TranslatableContents> warnings) {
        program.tick(ProgramContext.createSimulationContext(program, labelPositionHolder, 0, new GatherWarningsProgramBehaviour(warnings::addAll)));
    }

    private static void addWarningsForUsingEachWithoutAPattern(ArrayList<TranslatableContents> warnings, IOStatement statement) {
        boolean smells = statement.resourceLimits().resourceLimitList().stream().anyMatch(rl -> rl.limit().quantity().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.EXPAND && !rl.resourceIds().couldMatchMoreThanOne());
        if (smells) {
            warnings.add(LocalizationKeys.PROGRAM_WARNING_RESOURCE_EACH_WITHOUT_PATTERN.get(statement.toStringPretty()));
        }
    }

    private static void addWarningsForSmellyRoundRobinUsage(ArrayList<TranslatableContents> warnings, IOStatement statement) {
        RoundRobin roundRobin = statement.labelAccess().roundRobin();
        if (roundRobin.getBehaviour() == RoundRobin.Behaviour.BY_BLOCK && statement.each()) {
            warnings.add(LocalizationKeys.PROGRAM_WARNING_ROUND_ROBIN_SMELLY_EACH.get(statement.toStringPretty()));
        } else if (roundRobin.getBehaviour() == RoundRobin.Behaviour.BY_LABEL && statement.labelAccess().labels().size() == 1) {
            warnings.add(LocalizationKeys.PROGRAM_WARNING_ROUND_ROBIN_SMELLY_COUNT.get(statement.toStringPretty()));
        }
    }

    private static void addWarningsForResourcesReferencedButNotFoundInRegistry(Program program, ArrayList<TranslatableContents> warnings) {
        for (ResourceIdentifier<?, ?, ?> resource : program.referencedResources()) {
            Optional<ResourceLocation> loc = resource.getLocation();
            if (loc.isEmpty()) continue;
            ResourceType<?, ?, ?> type = resource.getResourceType();
            if (type == null) {
                SFM.LOGGER.error("Resource type not found for resource: {}, should have been validated at program compile", resource);
                continue;
            }
            if (type.registryKeyExists(loc.get())) continue;
            warnings.add(LocalizationKeys.PROGRAM_WARNING_UNKNOWN_RESOURCE_ID.get(resource));
        }
    }

    private static void addWarningsForLabelsUsedInWorldButNotConnectedByCables(@NotNull ManagerBlockEntity manager, LabelPositionHolder labels, ArrayList<TranslatableContents> warnings, Level level) {
        CableNetworkManager.getOrRegisterNetworkFromManagerPosition(manager).ifPresent(network -> labels.forEach((label, pos) -> {
            boolean viable;
            boolean adjacent = network.isAdjacentToCable((BlockPos)pos);
            if (!adjacent) {
                warnings.add(LocalizationKeys.PROGRAM_WARNING_DISCONNECTED_LABEL.get(label, String.format("[%d,%d,%d]", pos.m_123341_(), pos.m_123342_(), pos.m_123343_())));
            }
            boolean bl = viable = SFMCapabilityProviderMappers.discoverCapabilityProvider(level, pos) != null;
            if (!viable && adjacent) {
                warnings.add(LocalizationKeys.PROGRAM_WARNING_CONNECTED_BUT_NOT_VIABLE_LABEL.get(label, String.format("[%d,%d,%d]", pos.m_123341_(), pos.m_123342_(), pos.m_123343_())));
            }
        }));
    }

    private static void addWarningsForLabelsInHolderButNotInProgram(Program program, LabelPositionHolder labels, ArrayList<TranslatableContents> warnings) {
        labels.labels().keySet().stream().filter(x -> !program.referencedLabels().contains(x)).forEach(label -> warnings.add(LocalizationKeys.PROGRAM_WARNING_UNDEFINED_LABEL.get(label)));
    }

    private static void addWarningsForLabelsInProgramButNotInHolder(Program program, LabelPositionHolder labels, ArrayList<TranslatableContents> warnings) {
        for (String label : program.referencedLabels()) {
            boolean isUsed = !labels.getPositions(label).isEmpty();
            if (isUsed) continue;
            warnings.add(LocalizationKeys.PROGRAM_WARNING_UNUSED_LABEL.get(label));
        }
    }
}

