/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.item.LabelGunItem;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.SFMPacket;
import ca.teamdman.sfm.common.net.SFMPacketDaddy;
import ca.teamdman.sfm.common.net.SFMPacketHandlingContext;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.util.SFMDirections;
import ca.teamdman.sfm.common.util.SFMStreamUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public record ServerboundLabelGunUsePacket(InteractionHand hand, BlockPos pos, boolean isCtrlKeyDown, boolean isPickBlockModifierKeyDown, boolean isShiftKeyDown) implements SFMPacket
{

    public static class Daddy
    implements SFMPacketDaddy<ServerboundLabelGunUsePacket> {
        @Override
        public SFMPacketDaddy.PacketDirection getPacketDirection() {
            return SFMPacketDaddy.PacketDirection.SERVERBOUND;
        }

        @Override
        public void encode(ServerboundLabelGunUsePacket msg, FriendlyByteBuf buf) {
            buf.m_130068_((Enum)msg.hand);
            buf.m_130064_(msg.pos);
            buf.writeBoolean(msg.isCtrlKeyDown);
            buf.writeBoolean(msg.isPickBlockModifierKeyDown);
            buf.writeBoolean(msg.isShiftKeyDown);
        }

        @Override
        public ServerboundLabelGunUsePacket decode(FriendlyByteBuf buf) {
            return new ServerboundLabelGunUsePacket((InteractionHand)buf.m_130066_(InteractionHand.class), buf.m_130135_(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
        }

        @Override
        public void handle(ServerboundLabelGunUsePacket msg, SFMPacketHandlingContext context) {
            ServerPlayer sender = context.sender();
            if (sender == null) {
                return;
            }
            ItemStack stack = sender.m_21120_(msg.hand);
            ServerLevel level = sender.m_9236_();
            if (!(stack.m_41720_() instanceof LabelGunItem)) {
                return;
            }
            LabelPositionHolder gunLabels = LabelPositionHolder.from(stack).toOwned();
            BlockPos pos = msg.pos;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ManagerBlockEntity) {
                ManagerBlockEntity manager = (ManagerBlockEntity)blockEntity;
                ItemStack disk = manager.getDisk();
                if (disk != null) {
                    if (msg.isShiftKeyDown) {
                        LabelPositionHolder newLabels = LabelPositionHolder.from(disk).toOwned();
                        manager.getReferencedLabels().forEach(newLabels::addReferencedLabel);
                        newLabels.save(stack);
                        sender.m_213846_((Component)LocalizationKeys.LABEL_GUN_CHAT_PULLED.getComponent());
                    } else {
                        gunLabels.save(disk);
                        manager.rebuildProgramAndUpdateDisk();
                        manager.m_6596_();
                        sender.m_213846_((Component)LocalizationKeys.LABEL_GUN_CHAT_PUSHED.getComponent());
                    }
                }
                return;
            }
            String activeLabel = LabelGunItem.getActiveLabel(stack);
            if (msg.isShiftKeyDown) {
                gunLabels.removeAll(pos);
            } else if (!activeLabel.isEmpty()) {
                if (msg.isCtrlKeyDown) {
                    Set cablePositions = CableNetworkManager.getNetworksForLevel((Level)level).flatMap(CableNetwork::getCablePositions).collect(Collectors.toSet());
                    Block targetBlock = level.m_8055_(pos).m_60734_();
                    Predicate<BlockPos> isAdjacentToCable = p -> Arrays.stream(SFMDirections.DIRECTIONS).anyMatch(d -> cablePositions.contains(p.m_121955_(d.m_122436_())));
                    List<BlockPos> positions = SFMStreamUtils.getRecursiveStream((current, nextQueue, results) -> {
                        results.accept(current);
                        SFMStreamUtils.get3DNeighboursIncludingKittyCorner(current).filter(p -> level.m_8055_(p).m_60734_() == targetBlock).filter(isAdjacentToCable).forEach(nextQueue);
                    }, pos).toList();
                    HashSet<BlockPos> existing = new HashSet<BlockPos>(gunLabels.getPositions(activeLabel));
                    boolean anyMissing = positions.stream().anyMatch(p -> !existing.contains(p));
                    if (anyMissing) {
                        gunLabels.addAll(activeLabel, positions);
                    } else {
                        positions.forEach(p -> gunLabels.remove(activeLabel, (BlockPos)p));
                    }
                } else if (msg.isPickBlockModifierKeyDown) {
                    ArrayList<String> labels = new ArrayList<String>(gunLabels.getLabels(pos));
                    labels.sort(Comparator.naturalOrder());
                    if (labels.isEmpty()) {
                        return;
                    }
                    int index = (labels.indexOf(activeLabel) + 1) % labels.size();
                    String nextLabel = labels.get(index);
                    LabelGunItem.setActiveLabel(stack, nextLabel);
                } else {
                    gunLabels.toggle(activeLabel, pos);
                }
            }
            gunLabels.save(stack);
        }

        @Override
        public Class<ServerboundLabelGunUsePacket> getPacketClass() {
            return ServerboundLabelGunUsePacket.class;
        }
    }
}

