/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.facade.FacadePlanner;
import ca.teamdman.sfm.common.facade.FacadeSpreadLogic;
import ca.teamdman.sfm.common.facade.IFacadePlan;
import ca.teamdman.sfm.common.net.SFMPacket;
import ca.teamdman.sfm.common.net.SFMPacketDaddy;
import ca.teamdman.sfm.common.net.SFMPacketHandlingContext;
import ca.teamdman.sfm.common.util.SFMPlayerUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public record ServerboundFacadePacket(BlockHitResult hitResult, FacadeSpreadLogic spreadLogic, ItemStack paintStack, InteractionHand paintHand) implements SFMPacket
{
    public static void handle(ServerboundFacadePacket msg, Player sender) {
        Level level = SFMPlayerUtils.getLevel(sender);
        IFacadePlan facadePlan = FacadePlanner.getFacadePlan(sender, level, msg);
        if (facadePlan == null) {
            return;
        }
        facadePlan.apply(level);
    }

    public static class Daddy
    implements SFMPacketDaddy<ServerboundFacadePacket> {
        @Override
        public SFMPacketDaddy.PacketDirection getPacketDirection() {
            return SFMPacketDaddy.PacketDirection.SERVERBOUND;
        }

        @Override
        public void encode(ServerboundFacadePacket msg, FriendlyByteBuf buf) {
            buf.m_130062_(msg.hitResult);
            buf.m_130068_((Enum)msg.spreadLogic);
            buf.m_130055_(msg.paintStack);
            buf.m_130068_((Enum)msg.paintHand);
        }

        @Override
        public ServerboundFacadePacket decode(FriendlyByteBuf buf) {
            return new ServerboundFacadePacket(buf.m_130283_(), (FacadeSpreadLogic)buf.m_130066_(FacadeSpreadLogic.class), buf.m_130267_(), (InteractionHand)buf.m_130066_(InteractionHand.class));
        }

        @Override
        public void handle(ServerboundFacadePacket msg, SFMPacketHandlingContext context) {
            ServerPlayer sender = context.sender();
            if (sender == null) {
                return;
            }
            ServerboundFacadePacket.handle(msg, (Player)sender);
        }

        @Override
        public Class<ServerboundFacadePacket> getPacketClass() {
            return ServerboundFacadePacket.class;
        }
    }
}

