/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.net.ClientboundInputInspectionResultsPacket;
import ca.teamdman.sfm.common.net.ClientboundOutputInspectionResultsPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.util.Stored;
import ca.teamdman.sfml.ast.Program;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class SFMPacketHandlingContext {
    private final NetworkEvent.Context inner;

    public SFMPacketHandlingContext(Supplier<NetworkEvent.Context> inner) {
        this.inner = inner.get();
    }

    @Nullable
    public ServerPlayer sender() {
        return this.inner.getSender();
    }

    public void finish() {
        this.inner.setPacketHandled(true);
    }

    public void enqueueAndFinish(Runnable runnable) {
        this.inner.enqueueWork(runnable);
        this.finish();
    }

    public <MENU extends AbstractContainerMenu, BE extends BlockEntity> void handleServerboundContainerPacket(Class<MENU> menuClass, Class<BE> blockEntityClass, @Stored BlockPos pos, int containerId, BiConsumer<MENU, BE> callback) {
        SFMPacketHandlingContext.handleServerboundContainerPacket(this, menuClass, blockEntityClass, pos, containerId, callback);
    }

    public static <MENU extends AbstractContainerMenu, BE extends BlockEntity> void handleServerboundContainerPacket(SFMPacketHandlingContext ctx, Class<MENU> menuClass, Class<BE> blockEntityClass, @Stored BlockPos pos, int containerId, BiConsumer<MENU, BE> callback) {
        ServerPlayer sender = ctx.sender();
        if (sender == null) {
            SFM.LOGGER.warn("Invalid packet received: no sender");
            return;
        }
        if (sender.m_5833_()) {
            SFM.LOGGER.warn("Invalid packet received from {}: sender is spectator", (Object)sender.m_7755_().getString());
            return;
        }
        AbstractContainerMenu menu = sender.f_36096_;
        if (!menuClass.isInstance(menu)) {
            SFM.LOGGER.warn("Invalid packet received from {}: menu is not instance of expected class", (Object)sender.m_7755_().getString());
            return;
        }
        if (menu.f_38840_ != containerId) {
            SFM.LOGGER.warn("Invalid packet received from {}: containerId does not match", (Object)sender.m_7755_().getString());
            return;
        }
        ServerLevel level = sender.m_9236_();
        if (level == null) {
            SFM.LOGGER.warn("Invalid packet received from {}: level is null", (Object)sender.m_7755_().getString());
            return;
        }
        if (!level.m_46749_(pos)) {
            SFM.LOGGER.warn("Invalid packet received from {}: block entity is not loaded", (Object)sender.m_7755_().getString());
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!blockEntityClass.isInstance(blockEntity)) {
            SFM.LOGGER.warn("Invalid packet received from {}: block entity is not instance of expected class", (Object)sender.m_7755_().getString());
            return;
        }
        callback.accept(menu, blockEntity);
    }

    public void compileAndThen(String programString, ProgramConsumer callback) {
        ManagerBlockEntity mbe;
        BlockEntity blockEntity;
        ServerPlayer player = this.sender();
        if (player == null) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof ManagerContainerMenu) {
            ManagerContainerMenu mcm = (ManagerContainerMenu)abstractContainerMenu;
            blockEntity = player.m_9236_().m_7702_(mcm.MANAGER_POSITION);
            if (!(blockEntity instanceof ManagerBlockEntity)) {
                return;
            }
        } else {
            SFMPackets.sendToPlayer(() -> player, (Object)new ClientboundInputInspectionResultsPacket("This inspection is only available when editing inside a manager."));
            return;
        }
        ManagerBlockEntity manager = mbe = (ManagerBlockEntity)blockEntity;
        Program.compile(programString, successProgram -> callback.accept((Program)successProgram, player, manager), failure -> SFMPackets.sendToPlayer(() -> player, (Object)new ClientboundOutputInspectionResultsPacket("failed to compile program")));
    }

    @FunctionalInterface
    public static interface ProgramConsumer {
        public void accept(Program var1, ServerPlayer var2, ManagerBlockEntity var3);
    }
}

