/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.net.SFMPacket;
import ca.teamdman.sfm.common.net.SFMPacketHandlingContext;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public interface SFMPacketDaddy<T extends SFMPacket> {
    public PacketDirection getPacketDirection();

    public Class<T> getPacketClass();

    public void encode(T var1, FriendlyByteBuf var2);

    public T decode(FriendlyByteBuf var1);

    public void handle(T var1, SFMPacketHandlingContext var2);

    default public void handleOuter(T msg, Supplier<NetworkEvent.Context> contextSupplier) {
        SFMPacketHandlingContext context = new SFMPacketHandlingContext(contextSupplier);
        context.enqueueAndFinish(() -> {
            try {
                this.handle(msg, context);
            }
            catch (Throwable t) {
                SFM.LOGGER.warn("Encountered exception while handling packet", t);
                throw t;
            }
        });
    }

    public static String truncate(String input, int maxLength) {
        if (input.length() > maxLength) {
            SFM.LOGGER.warn("input too big, truncation has occurred! (len={}, max={}, over={})", (Object)input.length(), (Object)maxLength, (Object)(maxLength - input.length()));
            String truncationWarning = "\n...truncated";
            return input.substring(0, maxLength - truncationWarning.length()) + truncationWarning;
        }
        return input;
    }

    public static enum PacketDirection {
        SERVERBOUND,
        CLIENTBOUND;

    }
}

