/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.compat;

import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.linting.IProgramLinter;
import ca.teamdman.sfm.common.program.linting.MekanismSideConfigProgramLinter;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.GasResourceType;
import ca.teamdman.sfm.common.resourcetype.InfuseResourceType;
import ca.teamdman.sfm.common.resourcetype.MekanismEnergyResourceType;
import ca.teamdman.sfm.common.resourcetype.PigmentResourceType;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.resourcetype.SlurryResourceType;
import ca.teamdman.sfml.ast.DirectionQualifier;
import ca.teamdman.sfml.ast.IOStatement;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mekanism.api.RelativeSide;
import mekanism.api.math.FloatingLong;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public class SFMMekanismCompat {
    @Nullable
    public static ResourceType<?, ?, ?> getResourceType(TransmissionType trans) {
        return switch (trans) {
            case TransmissionType.ITEM -> (ResourceType)SFMResourceTypes.ITEM.get();
            case TransmissionType.FLUID -> (ResourceType)SFMResourceTypes.FLUID.get();
            case TransmissionType.GAS -> (ResourceType)SFMResourceTypes.DEFERRED_TYPES.get().getValue(new ResourceLocation("sfm", "gas"));
            case TransmissionType.INFUSION -> (ResourceType)SFMResourceTypes.DEFERRED_TYPES.get().getValue(new ResourceLocation("sfm", "infusion"));
            case TransmissionType.PIGMENT -> (ResourceType)SFMResourceTypes.DEFERRED_TYPES.get().getValue(new ResourceLocation("sfm", "pigment"));
            case TransmissionType.SLURRY -> (ResourceType)SFMResourceTypes.DEFERRED_TYPES.get().getValue(new ResourceLocation("sfm", "slurry"));
            default -> null;
        };
    }

    public static EnumSet<TransmissionType> getReferencedTransmissionTypes(IOStatement statement) {
        EnumSet<TransmissionType> transmissionTypes = EnumSet.noneOf(TransmissionType.class);
        Set referencedResourceTypes = statement.getReferencedIOResourceIds().map(ResourceIdentifier::getResourceType).collect(Collectors.toSet());
        for (TransmissionType transmissionType : TransmissionType.values()) {
            if (!referencedResourceTypes.contains(SFMMekanismCompat.getResourceType(transmissionType))) continue;
            transmissionTypes.add(transmissionType);
        }
        return transmissionTypes;
    }

    public static FloatingLong createForgeEnergy(long amount) {
        return UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertInPlaceFrom(FloatingLong.create((long)amount));
    }

    public static String gatherInspectionResults(BlockEntity blockEntity) {
        if (!(blockEntity instanceof ISideConfiguration)) {
            return "";
        }
        ISideConfiguration sideConfiguration = (ISideConfiguration)blockEntity;
        StringBuilder sb = new StringBuilder();
        sb.append("-- Mekanism stuff\n");
        TileComponentConfig config = sideConfiguration.getConfig();
        for (TransmissionType type : TransmissionType.values()) {
            Optional maybeResourceTypeKe;
            ResourceType<?, ?, ?> resourceType = SFMMekanismCompat.getResourceType(type);
            if (resourceType == null || (maybeResourceTypeKe = SFMResourceTypes.DEFERRED_TYPES.get().getResourceKey(resourceType)).isEmpty()) continue;
            ResourceKey resourceTypeKey = (ResourceKey)maybeResourceTypeKe.get();
            ConfigInfo info = config.getConfig(type);
            if (info == null) continue;
            Set outputSides = info.getSides(DataType::canOutput);
            if (!outputSides.isEmpty()) {
                sb.append("-- ").append(LocalizationKeys.CONTAINER_INSPECTOR_MEKANISM_MACHINE_OUTPUTS.getStub()).append("\n");
                sb.append("INPUT ").append(resourceTypeKey.m_135782_()).append(":: FROM target ");
                sb.append(outputSides.stream().map(DirectionQualifier::directionToString).collect(Collectors.joining(", ")));
                sb.append(" SIDE\n");
            }
            HashSet<Direction> inputSides = new HashSet<Direction>();
            for (RelativeSide side : RelativeSide.values()) {
                DataType dataType = info.getDataType(side);
                if (dataType != DataType.INPUT && dataType != DataType.INPUT_1 && dataType != DataType.INPUT_2 && dataType != DataType.INPUT_OUTPUT) continue;
                inputSides.add(side.getDirection(sideConfiguration.getDirection()));
            }
            if (inputSides.isEmpty()) continue;
            sb.append("-- ").append(LocalizationKeys.CONTAINER_INSPECTOR_MEKANISM_MACHINE_INPUTS.getStub()).append("\n");
            sb.append("OUTPUT ").append(resourceTypeKey.m_135782_()).append(":: TO target ");
            sb.append(inputSides.stream().map(DirectionQualifier::directionToString).collect(Collectors.joining(", ")));
            sb.append(" SIDE\n");
        }
        return sb.toString();
    }

    public static void registerResourceTypes(DeferredRegister<ResourceType<?, ?, ?>> types) {
        types.register("gas", GasResourceType::new);
        types.register("infusion", InfuseResourceType::new);
        types.register("pigment", PigmentResourceType::new);
        types.register("slurry", SlurryResourceType::new);
        types.register("mekanism_energy", MekanismEnergyResourceType::new);
    }

    public static void registerProgramLinters(DeferredRegister<IProgramLinter> types) {
        types.register("mekanism", MekanismSideConfigProgramLinter::new);
    }

    public static void configureExclusiveIO(ISideConfiguration mekanismBlockEntity, TransmissionType transmissionType, RelativeSide relativeSide, DataType dataType) {
        TileComponentConfig config = mekanismBlockEntity.getConfig();
        for (TransmissionType value : TransmissionType.values()) {
            ConfigInfo info = config.getConfig(value);
            if (info == null) continue;
            for (RelativeSide side : RelativeSide.values()) {
                info.setDataType(value == transmissionType && side == relativeSide ? dataType : DataType.NONE, new RelativeSide[]{side});
            }
            config.sideChanged(value, relativeSide);
        }
    }
}

