/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.screen;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.ProgramSyntaxHighlightingHelper;
import ca.teamdman.sfm.client.ProgramTokenContextActions;
import ca.teamdman.sfm.client.gui.ButtonBuilder;
import ca.teamdman.sfm.client.gui.EditorUtils;
import ca.teamdman.sfm.client.gui.screen.SFMScreenUtils;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Matrix4f;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class ProgramEditScreen
extends Screen {
    protected final String INITIAL_CONTENT;
    protected final Consumer<String> SAVE_CALLBACK;
    protected MyMultiLineEditBox textarea;
    protected String lastProgram = "";
    protected List<MutableComponent> lastProgramWithSyntaxHighlighting = Collections.emptyList();

    public ProgramEditScreen(String initialContent, Consumer<String> saveCallback) {
        super((Component)LocalizationKeys.PROGRAM_EDIT_SCREEN_TITLE.getComponent());
        this.INITIAL_CONTENT = initialContent;
        this.SAVE_CALLBACK = saveCallback;
    }

    public static MutableComponent substring(MutableComponent component, int start, int end) {
        MutableComponent rtn = Component.m_237119_();
        AtomicInteger seen = new AtomicInteger(0);
        component.m_7451_((style, content) -> {
            int contentEnd;
            int contentStart = Math.max(start - seen.get(), 0);
            if (contentStart < (contentEnd = Math.min(end - seen.get(), content.length()))) {
                rtn.m_7220_((Component)Component.m_237113_((String)content.substring(contentStart, contentEnd)).m_130948_(style));
            }
            seen.addAndGet(content.length());
            return Optional.empty();
        }, Style.f_131099_);
        return rtn;
    }

    public void scrollToTop() {
        this.textarea.scrollToTop();
    }

    public boolean m_7043_() {
        return false;
    }

    public void saveAndClose() {
        this.SAVE_CALLBACK.accept(this.textarea.m_239249_());
        assert (this.f_96541_ != null);
        this.f_96541_.popGuiLayer();
    }

    public void closeWithoutSaving() {
        assert (this.f_96541_ != null);
        this.f_96541_.popGuiLayer();
    }

    public void m_7379_() {
        if (!this.INITIAL_CONTENT.equals(this.textarea.m_239249_())) {
            assert (this.f_96541_ != null);
            ConfirmScreen exitWithoutSavingConfirmScreen = this.getExitWithoutSavingConfirmScreen();
            this.f_96541_.pushGuiLayer((Screen)exitWithoutSavingConfirmScreen);
            exitWithoutSavingConfirmScreen.m_95663_(20);
        } else {
            super.m_7379_();
        }
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 341 || pKeyCode == 345) {
            this.textarea.rebuild(Screen.m_96637_());
            return true;
        }
        return false;
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        if (Screen.m_96637_() && pCodePoint == ' ') {
            return true;
        }
        return super.m_5534_(pCodePoint, pModifiers);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if ((pKeyCode == 257 || pKeyCode == 335) && Screen.m_96638_()) {
            this.saveAndClose();
            return true;
        }
        if (pKeyCode == 258) {
            String content = this.textarea.m_239249_();
            int cursor = this.textarea.getCursorPosition();
            int selectionCursor = this.textarea.getSelectionCursorPosition();
            double scrollAmount = this.textarea.getScrollAmount();
            EditorUtils.ManipulationResult result = Screen.m_96638_() ? EditorUtils.deindent(content, cursor, selectionCursor) : EditorUtils.indent(content, cursor, selectionCursor);
            this.textarea.m_240159_(result.content());
            this.textarea.setCursorPosition(result.cursorPosition());
            this.textarea.setSelectionCursorPosition(result.selectionCursorPosition());
            this.textarea.m_240206_(scrollAmount);
            return true;
        }
        if (pKeyCode == 341 || pKeyCode == 345) {
            this.textarea.rebuild(Screen.m_96637_());
            return true;
        }
        if (pKeyCode == 47 && Screen.m_96637_()) {
            String content = this.textarea.m_239249_();
            int cursor = this.textarea.getCursorPosition();
            int selectionCursor = this.textarea.getSelectionCursorPosition();
            EditorUtils.ManipulationResult result = EditorUtils.toggleComments(content, cursor, selectionCursor);
            this.textarea.m_240159_(result.content());
            this.textarea.setCursorPosition(result.cursorPosition());
            this.textarea.setSelectionCursorPosition(result.selectionCursorPosition());
            return true;
        }
        if (pKeyCode == 32 && Screen.m_96637_()) {
            ProgramTokenContextActions.getContextAction(this.textarea.m_239249_(), this.textarea.getCursorPosition()).ifPresent(Runnable::run);
            this.textarea.rebuild(false);
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_6574_(Minecraft mc, int x, int y) {
        String prev = this.textarea.m_239249_();
        this.m_6575_(mc, x, y);
        super.m_6574_(mc, x, y);
        this.textarea.m_240159_(prev);
    }

    public void m_6305_(PoseStack poseStack, int mx, int my, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mx, my, partialTicks);
    }

    private static boolean shouldShowLineNumbers() {
        return (Boolean)SFMConfig.getOrDefault(SFMConfig.CLIENT.showLineNumbers);
    }

    protected void m_7856_() {
        super.m_7856_();
        assert (this.f_96541_ != null);
        SFMScreenUtils.enableKeyRepeating();
        this.textarea = (MyMultiLineEditBox)this.m_142416_((GuiEventListener)new MyMultiLineEditBox());
        this.textarea.m_240159_(this.INITIAL_CONTENT);
        this.m_94718_((GuiEventListener)this.textarea);
        this.m_142416_((GuiEventListener)new ButtonBuilder().setPosition(this.f_96543_ / 2 - 200, this.f_96544_ / 2 - 100 + 195).setSize(16, 20).setText((Component)Component.m_237113_((String)"#")).setOnPress(button -> this.onToggleLineNumbersButtonClicked()).setTooltip((Screen)this, this.f_96547_, LocalizationKeys.PROGRAM_EDIT_SCREEN_TOGGLE_LINE_NUMBERS_BUTTON_TOOLTIP).build());
        this.m_142416_((GuiEventListener)new ButtonBuilder().setPosition(this.f_96543_ / 2 - 2 - 150, this.f_96544_ / 2 - 100 + 195).setSize(200, 20).setText(CommonComponents.f_130655_).setOnPress(button -> this.saveAndClose()).setTooltip((Screen)this, this.f_96547_, LocalizationKeys.PROGRAM_EDIT_SCREEN_DONE_BUTTON_TOOLTIP).build());
        this.m_142416_((GuiEventListener)new ButtonBuilder().setPosition(this.f_96543_ / 2 - 2 + 100, this.f_96544_ / 2 - 100 + 195).setSize(100, 20).setText(CommonComponents.f_130656_).setOnPress(button -> this.m_7379_()).build());
    }

    private void onToggleLineNumbersButtonClicked() {
        SFMConfig.CLIENT.showLineNumbers.set((Object)(!ProgramEditScreen.shouldShowLineNumbers() ? 1 : 0));
    }

    @NotNull
    protected ConfirmScreen getSaveConfirmScreen(Runnable onConfirm) {
        return new ConfirmScreen(doSave -> {
            assert (this.f_96541_ != null);
            this.f_96541_.popGuiLayer();
            if (doSave) {
                onConfirm.run();
            }
        }, (Component)LocalizationKeys.SAVE_CHANGES_CONFIRM_SCREEN_TITLE.getComponent(), (Component)LocalizationKeys.SAVE_CHANGES_CONFIRM_SCREEN_MESSAGE.getComponent(), (Component)LocalizationKeys.SAVE_CHANGES_CONFIRM_SCREEN_YES_BUTTON.getComponent(), (Component)LocalizationKeys.SAVE_CHANGES_CONFIRM_SCREEN_NO_BUTTON.getComponent());
    }

    @NotNull
    protected ConfirmScreen getExitWithoutSavingConfirmScreen() {
        return new ConfirmScreen(doSave -> {
            assert (this.f_96541_ != null);
            this.f_96541_.popGuiLayer();
            if (doSave) {
                this.closeWithoutSaving();
            }
        }, (Component)LocalizationKeys.EXIT_WITHOUT_SAVING_CONFIRM_SCREEN_TITLE.getComponent(), (Component)LocalizationKeys.EXIT_WITHOUT_SAVING_CONFIRM_SCREEN_MESSAGE.getComponent(), (Component)LocalizationKeys.EXIT_WITHOUT_SAVING_CONFIRM_SCREEN_YES_BUTTON.getComponent(), (Component)LocalizationKeys.EXIT_WITHOUT_SAVING_CONFIRM_SCREEN_NO_BUTTON.getComponent());
    }

    protected class MyMultiLineEditBox
    extends MultiLineEditBox {
        public MyMultiLineEditBox() {
            super(ProgramEditScreen.this.f_96547_, ProgramEditScreen.this.f_96543_ / 2 - 200, ProgramEditScreen.this.f_96544_ / 2 - 110, 400, 200, (Component)Component.m_237113_((String)""), (Component)Component.m_237113_((String)""));
        }

        public void scrollToTop() {
            this.m_240206_(0.0);
        }

        public int getCursorPosition() {
            return this.f_238540_.f_238566_;
        }

        public void setCursorPosition(int cursor) {
            this.f_238540_.f_238566_ = cursor;
        }

        public int getLineNumberWidth() {
            if (ProgramEditScreen.shouldShowLineNumbers()) {
                return this.f_238790_.m_92895_("000");
            }
            return 0;
        }

        @MCVersionDependentBehaviour
        public boolean m_6375_(double mx, double my, int button) {
            try {
                if (mx >= (double)(this.f_93620_ + 1) && mx <= (double)(this.f_93620_ + this.f_93618_ - 1)) {
                    mx -= (double)this.getLineNumberWidth();
                }
                return super.m_6375_(mx, my, button);
            }
            catch (Exception e) {
                SFM.LOGGER.error("Error in ProgramEditScreen.MyMultiLineEditBox.mouseClicked", (Throwable)e);
                return false;
            }
        }

        public int m_239019_() {
            Objects.requireNonNull(this.f_238790_);
            return 9 * (ProgramEditScreen.this.lastProgramWithSyntaxHighlighting.size() + 2);
        }

        public boolean m_7979_(double mx, double my, int button, double dx, double dy) {
            int thisX = SFMScreenUtils.getX((AbstractWidget)this);
            if (mx >= (double)(thisX + 1) && mx <= (double)(thisX + this.f_93618_ - 1)) {
                mx -= (double)this.getLineNumberWidth();
            }
            return super.m_7979_(mx, my, button, dx, dy);
        }

        public int getSelectionCursorPosition() {
            return this.f_238540_.f_238550_;
        }

        public void setSelectionCursorPosition(int cursor) {
            this.f_238540_.f_238550_ = cursor;
        }

        public double getScrollAmount() {
            return this.m_239030_();
        }

        public void m_240206_(double d) {
            super.m_240206_(d);
        }

        private void rebuild(boolean showContextActionHints) {
            ProgramEditScreen.this.lastProgram = this.f_238540_.m_239618_();
            ProgramEditScreen.this.lastProgramWithSyntaxHighlighting = ProgramSyntaxHighlightingHelper.withSyntaxHighlighting(ProgramEditScreen.this.lastProgram, showContextActionHints);
        }

        protected void m_239000_(PoseStack poseStack, int mx, int my, float partialTicks) {
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            if (!ProgramEditScreen.this.lastProgram.equals(this.f_238540_.m_239618_())) {
                this.rebuild(Screen.m_96637_());
            }
            List<MutableComponent> lines = ProgramEditScreen.this.lastProgramWithSyntaxHighlighting;
            boolean isCursorVisible = this.m_93696_() && this.f_238824_ / 6 % 2 == 0;
            boolean isCursorAtEndOfLine = false;
            int cursorIndex = this.f_238540_.m_239456_();
            int lineX = SFMScreenUtils.getX((AbstractWidget)this) + this.m_239244_() + this.getLineNumberWidth();
            int lineY = SFMScreenUtils.getY((AbstractWidget)this) + this.m_239244_();
            int charCount = 0;
            int cursorX = 0;
            int cursorY = 0;
            MultilineTextField.StringView selectedRange = this.f_238540_.m_239982_();
            int selectionStart = selectedRange.f_238590_();
            int selectionEnd = selectedRange.f_238654_();
            for (int line = 0; line < lines.size(); ++line) {
                MutableComponent componentColoured = lines.get(line);
                int lineLength = componentColoured.getString().length();
                Objects.requireNonNull(this.f_238790_);
                int lineHeight = 9;
                boolean cursorOnThisLine = isCursorVisible && cursorIndex >= charCount && cursorIndex <= charCount + lineLength;
                MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                if (ProgramEditScreen.shouldShowLineNumbers()) {
                    String lineNumber = String.valueOf(line + 1);
                    SFMScreenUtils.drawInBatch(lineNumber, this.f_238790_, (float)(lineX - 2 - this.f_238790_.m_92895_(lineNumber)), (float)lineY, true, matrix4f, (MultiBufferSource)buffer, false);
                }
                if (cursorOnThisLine) {
                    isCursorAtEndOfLine = cursorIndex == charCount + lineLength;
                    cursorY = lineY;
                    cursorX = SFMScreenUtils.drawInBatch((Component)ProgramEditScreen.substring(componentColoured, 0, cursorIndex - charCount), this.f_238790_, (float)lineX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer) - 1;
                    SFMScreenUtils.drawInBatch((Component)ProgramEditScreen.substring(componentColoured, cursorIndex - charCount, lineLength), this.f_238790_, (float)cursorX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                } else {
                    SFMScreenUtils.drawInBatch((Component)componentColoured, this.f_238790_, (float)lineX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                }
                buffer.m_109911_();
                if (selectionStart <= charCount + lineLength && selectionEnd > charCount) {
                    int lineSelectionStart = Math.max(selectionStart - charCount, 0);
                    int lineSelectionEnd = Math.min(selectionEnd - charCount, lineLength);
                    int highlightStartX = this.f_238790_.m_92852_((FormattedText)ProgramEditScreen.substring(componentColoured, 0, lineSelectionStart));
                    int highlightEndX = this.f_238790_.m_92852_((FormattedText)ProgramEditScreen.substring(componentColoured, 0, lineSelectionEnd));
                    this.m_239486_(poseStack, lineX + highlightStartX, lineY, lineX + highlightEndX, lineY + lineHeight);
                }
                lineY += lineHeight;
                charCount += lineLength + 1;
            }
            if (isCursorAtEndOfLine) {
                this.f_238790_.m_92750_(poseStack, "_", (float)cursorX, (float)cursorY, -1);
            } else {
                GuiComponent.m_93172_((PoseStack)poseStack, (int)cursorX, (int)(cursorY - 1), (int)(cursorX + 1), (int)(cursorY + 1 + 9), (int)-1);
            }
        }
    }
}

