/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui;

import ca.teamdman.sfm.client.gui.ExtendedButtonWithTooltip;
import ca.teamdman.sfm.common.localization.LocalizationEntry;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.Nullable;

public class ButtonBuilder {
    @Nullable
    private Component text = null;
    private int x = 0;
    private int y = 0;
    private int width = 150;
    private int height = 20;
    @Nullable
    private Button.OnPress onPress = null;
    @MCVersionDependentBehaviour
    @Nullable
    private Button.OnTooltip tooltip = null;

    public ButtonBuilder setText(LocalizationEntry text) {
        return this.setText((Component)text.getComponent());
    }

    public ButtonBuilder setText(Component text) {
        this.text = text;
        return this;
    }

    public ButtonBuilder setSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public ButtonBuilder setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public ButtonBuilder setOnPress(Button.OnPress onPress) {
        this.onPress = onPress;
        return this;
    }

    public ButtonBuilder setTooltip(Screen screen, Font font, LocalizationEntry tooltip) {
        return this.setTooltip(screen, font, (Component)tooltip.getComponent());
    }

    @MCVersionDependentBehaviour
    public ButtonBuilder setTooltip(Screen screen, Font font, Component tooltip) {
        this.tooltip = (btn, pose, mx, my) -> screen.m_96617_(pose, font.m_92923_((FormattedText)tooltip, Math.max(screen.f_96543_ / 2 - 43, 170)), mx, my);
        return this;
    }

    public Button build() {
        if (this.text == null) {
            throw new IllegalArgumentException("Text must be set");
        }
        if (this.onPress == null) {
            throw new IllegalArgumentException("OnPress must be set");
        }
        if (this.tooltip != null) {
            return new ExtendedButtonWithTooltip(this.x, this.y, this.width, this.height, this.text, this.onPress, this.tooltip);
        }
        return new ExtendedButton(this.x, this.y, this.width, this.height, this.text, this.onPress);
    }
}

