/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.gui.screen.ExampleEditScreen;
import ca.teamdman.sfm.client.gui.screen.ExamplesScreen;
import ca.teamdman.sfm.client.gui.screen.LabelGunScreen;
import ca.teamdman.sfm.client.gui.screen.LogsScreen;
import ca.teamdman.sfm.client.gui.screen.ProgramEditScreen;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundManagerLogDesireUpdatePacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import java.io.BufferedReader;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class ClientScreenHelpers {
    public static void setOrPushScreen(Screen screen) {
        if (Minecraft.m_91087_().f_91080_ == null) {
            Minecraft.m_91087_().m_91152_(screen);
        } else {
            Minecraft.m_91087_().pushGuiLayer(screen);
        }
    }

    public static void popScreen() {
        Minecraft.m_91087_().popGuiLayer();
    }

    public static void showLabelGunScreen(ItemStack stack, InteractionHand hand) {
        ClientScreenHelpers.setOrPushScreen(new LabelGunScreen(stack, hand));
    }

    public static void showProgramEditScreen(String initialContent, Consumer<String> saveCallback) {
        ProgramEditScreen screen = new ProgramEditScreen(initialContent, saveCallback);
        ClientScreenHelpers.setOrPushScreen(screen);
        screen.scrollToTop();
    }

    public static void showProgramEditScreen(String initialContent) {
        ClientScreenHelpers.showProgramEditScreen(initialContent, x -> {});
    }

    public static void showExampleListScreen(String program, Consumer<String> saveCallback) {
        ClientScreenHelpers.setOrPushScreen(new ExamplesScreen((chosenTemplate, templates) -> ClientScreenHelpers.showExampleEditScreen(program, chosenTemplate, templates, saveCallback)));
    }

    public static void showExampleEditScreen(String program, String chosenTemplate, Map<String, String> templates, Consumer<String> saveCallback) {
        ExampleEditScreen screen = new ExampleEditScreen(program, chosenTemplate, templates, saveCallback);
        ClientScreenHelpers.setOrPushScreen(screen);
        screen.scrollToTop();
    }

    public static void showLogsScreen(ManagerContainerMenu menu) {
        LogsScreen screen = new LogsScreen(menu);
        ClientScreenHelpers.setOrPushScreen(screen);
        screen.scrollToBottom();
        SFMPackets.sendToServer(new ServerboundManagerLogDesireUpdatePacket(menu.f_38840_, menu.MANAGER_POSITION, true));
    }

    public static void showItemInspectorScreen(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            String content = tag.toString();
            Minecraft minecraft = Minecraft.m_91087_();
            minecraft.f_91068_.m_90911_(content);
            SFM.LOGGER.info("Copied {} characters to clipboard", (Object)content.length());
            assert (minecraft.f_91074_ != null);
            minecraft.f_91074_.m_213846_((Component)LocalizationKeys.ITEM_INSPECTOR_COPIED_TO_CLIPBOARD.getComponent(Component.m_237113_((String)String.valueOf(content.length())).m_130940_(ChatFormatting.AQUA)));
        }
    }

    public static void showChangelog() {
        String changelog = null;
        ResourceManager irm = Minecraft.m_91087_().m_91098_();
        Map found = irm.m_214159_("template_programs", path -> path.m_135815_().endsWith(".sfml") || path.m_135815_().endsWith(".sfm"));
        for (Map.Entry entry : found.entrySet()) {
            if (!((ResourceLocation)entry.getKey()).m_135815_().equals("template_programs/changelog.sfml")) continue;
            try (BufferedReader reader = ((Resource)entry.getValue()).m_215508_();){
                changelog = reader.lines().collect(Collectors.joining("\n"));
                break;
            }
            catch (Exception e) {
                SFM.LOGGER.error("Failed to read changelog", (Throwable)e);
            }
        }
        if (changelog == null) {
            SFM.LOGGER.error("Failed to find changelog");
            return;
        }
        ExampleEditScreen screen = new ExampleEditScreen(changelog, changelog, Map.of("changelog.sfml", changelog), $ -> {});
        ClientScreenHelpers.setOrPushScreen(screen);
        screen.scrollToTop();
    }
}

