/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsba.tools.recipies;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.ftb.ftbsba.tools.recipies.FusingMachineRecipeSerializer;
import dev.ftb.ftbsba.tools.recipies.SuperCoolerRecipe;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.Nullable;

public class SuperCoolerRecipeSerializer
implements RecipeSerializer<SuperCoolerRecipe> {
    public SuperCoolerRecipe fromJson(ResourceLocation arg, JsonObject jsonObject) {
        SuperCoolerRecipe recipe = new SuperCoolerRecipe(arg, jsonObject.has("group") ? jsonObject.get("group").getAsString() : "");
        JsonArray ingredients = jsonObject.get("ingredients").getAsJsonArray();
        for (JsonElement e : ingredients) {
            recipe.ingredients.add(Ingredient.m_43917_((JsonElement)e));
        }
        recipe.energyComponent = SuperCoolerRecipe.EnergyComponent.fromJson(jsonObject.get("energy"));
        recipe.result = ShapedRecipe.m_151274_((JsonObject)jsonObject.get("result").getAsJsonObject());
        recipe.fluidIngredient = FusingMachineRecipeSerializer.FluidStackSerializer.deserialize((JsonElement)jsonObject.get("fluid").getAsJsonObject());
        return recipe;
    }

    @Nullable
    public SuperCoolerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buf) {
        String groups = buf.m_130277_();
        SuperCoolerRecipe recipe = new SuperCoolerRecipe(recipeId, groups);
        List ingredients = buf.m_236845_(Ingredient::m_43940_);
        SuperCoolerRecipe.EnergyComponent energyComponent = SuperCoolerRecipe.EnergyComponent.fromNetwork(buf);
        recipe.ingredients.addAll(ingredients);
        recipe.energyComponent = energyComponent;
        recipe.result = buf.m_130267_();
        recipe.fluidIngredient = buf.readFluidStack();
        return recipe;
    }

    public void toNetwork(FriendlyByteBuf buf, SuperCoolerRecipe recipe) {
        buf.m_130070_(recipe.group);
        buf.m_236828_(recipe.ingredients, (buf1, ingredient) -> ingredient.m_43923_(buf1));
        recipe.energyComponent.toNetwork(buf);
        buf.m_130055_(recipe.result);
        buf.writeFluidStack(recipe.fluidIngredient);
    }
}

