/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsba.tools.content.core;

import dev.ftb.ftbsba.tools.content.core.AbstractMachineMenu;
import dev.ftb.ftbsba.tools.net.FluidTankSync;
import dev.ftb.ftbsba.tools.net.NetworkHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.network.PacketDistributor;

public class EmittingFluidTank
extends FluidTank {
    private final Consumer<EmittingFluidTank> onChange;
    private boolean syncAllObservers;
    private final Set<ServerPlayer> toSync = Collections.newSetFromMap(new WeakHashMap());

    public EmittingFluidTank(int capacity, Consumer<EmittingFluidTank> onChange) {
        super(capacity);
        this.onChange = onChange;
    }

    public EmittingFluidTank(int capacity, Predicate<FluidStack> validator, Consumer<EmittingFluidTank> onChange) {
        super(capacity, validator);
        this.onChange = onChange;
    }

    protected void onContentsChanged() {
        super.onContentsChanged();
        this.onChange.accept(this);
        this.needSync(new ServerPlayer[0]);
    }

    public void needSync(ServerPlayer ... players) {
        if (players.length == 0) {
            this.syncAllObservers = true;
        } else {
            this.toSync.addAll(Arrays.asList(players));
        }
    }

    public void sync(BlockEntity blockEntity) {
        FluidTankSync fluidTankSync = new FluidTankSync(blockEntity.m_58899_(), this.fluid);
        if (this.syncAllObservers) {
            blockEntity.m_58904_().m_7654_().m_6846_().m_11314_().stream().filter(p -> {
                AbstractMachineMenu prov;
                AbstractContainerMenu patt1747$temp = p.f_36096_;
                return patt1747$temp instanceof AbstractMachineMenu && (prov = (AbstractMachineMenu)patt1747$temp).getBlockEntity() == blockEntity;
            }).forEach(p -> NetworkHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> p), (Object)fluidTankSync));
        } else {
            this.toSync.forEach(p -> NetworkHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> p), (Object)fluidTankSync));
        }
        this.syncAllObservers = false;
        this.toSync.clear();
    }
}

