/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsba.tools.content.core;

import dev.ftb.ftbsba.tools.content.core.AbstractMachineBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractMachineMenu<T extends AbstractMachineBlockEntity>
extends AbstractContainerMenu {
    public final T blockEntity;
    private int playerSlotsStart;
    protected ContainerData containerData;

    public AbstractMachineMenu(MenuType type, int windowId, Inventory invPlayer, FriendlyByteBuf extraData) {
        this(type, windowId, invPlayer, AbstractMachineMenu.getTilePos(extraData));
    }

    public AbstractMachineMenu(MenuType type, int windowId, Inventory invPlayer) {
        this(type, windowId, invPlayer, (BlockPos)null);
    }

    public AbstractMachineMenu(MenuType type, int windowId, Inventory invPlayer, BlockPos blockPos) {
        super(type, windowId);
        if (blockPos != null) {
            BlockEntity te0 = invPlayer.f_35978_.f_19853_.m_7702_(blockPos);
            if (te0 instanceof AbstractMachineBlockEntity) {
                this.blockEntity = (AbstractMachineBlockEntity)te0;
                this.containerData = ((AbstractMachineBlockEntity)this.blockEntity).getContainerData();
            } else {
                this.blockEntity = null;
            }
        } else {
            this.blockEntity = null;
        }
    }

    public static BlockPos getTilePos(FriendlyByteBuf buf) {
        return buf.m_130135_();
    }

    public void m_38946_() {
        super.m_38946_();
        if (this.blockEntity != null) {
            ((AbstractMachineBlockEntity)this.blockEntity).syncFluidTank();
        }
    }

    protected void addPlayerSlots(Inventory inventoryPlayer, int yOffset) {
        this.addPlayerSlots(inventoryPlayer, 8, yOffset);
    }

    protected void addPlayerSlots(Inventory inventoryPlayer, int xOffset, int yOffset) {
        this.playerSlotsStart = this.f_38839_.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)inventoryPlayer, col + row * 9 + 9, xOffset + col * 18, yOffset + row * 18));
            }
        }
        for (int hotbarIdx = 0; hotbarIdx < 9; ++hotbarIdx) {
            this.m_38897_(new Slot((Container)inventoryPlayer, hotbarIdx, xOffset + hotbarIdx * 18, yOffset + 58));
        }
    }

    @Nonnull
    public ItemStack m_7648_(Player player, int slot) {
        Slot srcSlot = (Slot)this.f_38839_.get(slot);
        if (srcSlot == null || !srcSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack srcStack = srcSlot.m_7993_().m_41777_();
        ItemStack copyOfSrcStack = srcStack.m_41777_();
        if (slot < this.playerSlotsStart ? !this.moveItemStackToHotbarOrInventory(srcStack, this.playerSlotsStart) : !this.m_38903_(srcStack, 0, this.playerSlotsStart, false)) {
            return ItemStack.f_41583_;
        }
        srcSlot.m_5852_(srcStack);
        srcSlot.m_40234_(srcStack, copyOfSrcStack);
        srcSlot.m_142406_(player, srcStack);
        return copyOfSrcStack;
    }

    boolean moveItemStackToHotbarOrInventory(ItemStack stack, int startIndex) {
        return this.m_38903_(stack, startIndex + 27, startIndex + 36, false) || this.m_38903_(stack, startIndex, startIndex + 27, false);
    }

    public boolean m_6875_(Player player) {
        if (this.blockEntity == null) {
            return false;
        }
        Vec3 position = player.m_20182_();
        return this.blockEntity.m_58899_().m_123333_(new Vec3i(position.f_82479_, position.f_82480_, position.f_82481_)) <= 8;
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

