/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsba.tools;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.ftb.ftbsba.tools.ToolsRegistry;
import dev.ftb.ftbsba.tools.ToolsTags;
import dev.ftb.ftbsba.tools.content.core.AbstractMachineBlock;
import dev.ftb.ftbsba.tools.loot.CrookModifier;
import dev.ftb.ftbsba.tools.loot.HammerModifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="ftbsba", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ToolsData {
    public static final String MODID = "ftbsba";

    @SubscribeEvent
    public static void dataGenEvent(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeClient()) {
            SMBlockModels blockModels = new SMBlockModels(gen, MODID, event.getExistingFileHelper());
            gen.m_236039_(true, (DataProvider)blockModels);
            gen.m_236039_(true, (DataProvider)new SMLang(gen, MODID, "en_us"));
            gen.m_236039_(true, (DataProvider)new SMItemModels(gen, MODID, event.getExistingFileHelper()));
            gen.m_236039_(true, (DataProvider)new SMBlockStateModels(gen, MODID, event.getExistingFileHelper(), blockModels));
        }
        if (event.includeServer()) {
            SMBlockTags blockTags = new SMBlockTags(gen, event.getExistingFileHelper());
            gen.m_236039_(true, (DataProvider)blockTags);
            gen.m_236039_(true, (DataProvider)new SMItemTags(gen, blockTags, event.getExistingFileHelper()));
            gen.m_236039_(true, (DataProvider)new SMRecipes(gen));
            gen.m_236039_(true, (DataProvider)new SMLootTableProvider(gen));
            gen.m_236039_(true, (DataProvider)new SMLootModifiers(gen));
        }
    }

    private static class SMBlockModels
    extends BlockModelProvider {
        public SMBlockModels(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
            super(generator, modid, existingFileHelper);
        }

        protected void registerModels() {
        }
    }

    private static class SMLang
    extends LanguageProvider {
        public SMLang(DataGenerator gen, String modid, String locale) {
            super(gen, modid, locale);
        }

        protected void addTranslations() {
            this.add("itemGroup.ftbsba", "FTB SkyBlock Addons");
            this.addItem((Supplier)ToolsRegistry.STONE_HAMMER, "Stone Hammer");
            this.addItem((Supplier)ToolsRegistry.IRON_HAMMER, "Iron Hammer");
            this.addItem((Supplier)ToolsRegistry.GOLD_HAMMER, "Gold Hammer");
            this.addItem((Supplier)ToolsRegistry.DIAMOND_HAMMER, "Diamond Hammer");
            this.addItem((Supplier)ToolsRegistry.NETHERITE_HAMMER, "Netherite Hammer");
            this.addItem((Supplier)ToolsRegistry.CROOK, "Stone Crook");
            this.addItem((Supplier)ToolsRegistry.STONE_ROD, "Stone Rod");
            this.addBlock((Supplier)ToolsRegistry.IRON_AUTO_HAMMER, "Iron Auto-hammer");
            this.addBlock((Supplier)ToolsRegistry.GOLD_AUTO_HAMMER, "Gold Auto-hammer");
            this.addBlock((Supplier)ToolsRegistry.DIAMOND_AUTO_HAMMER, "Diamond Auto-hammer");
            this.addBlock((Supplier)ToolsRegistry.NETHERITE_AUTO_HAMMER, "Netherite Auto-hammer");
            this.addBlock((Supplier)ToolsRegistry.FUSING_MACHINE, "SlowMelter 9000");
            this.addBlock((Supplier)ToolsRegistry.SUPER_COOLER, "\"Super\" Cooler");
            this.add("screens.ftbsba.select_start_group", "Select a group");
            this.add("screens.ftbsba.select_start", "Select a start");
            this.add("screens.ftbsba.selected_start", "Selected start");
            this.add("screens.ftbsba.by", "By: %s");
            this.add("screens.ftbsba.back", "Back");
            this.add("screens.ftbsba.create", "Create");
            this.add("screens.ftbsba.select", "Select");
            this.add("screens.ftbsba.close", "Close");
            this.add("ftbsba.tooltip.fireplow", "Hold right click whilst looking at Stone to create lava");
            this.add("ftbsba.tooltip.hammers", "Crushes materials down to their core components");
            this.add("ftbsba.tooltip.auto-hammers", "Automatically crushes materials down using the hammer based on the tier of hammer");
            this.add("ftbsba.tooltip.energy", "Energy: %s FE");
            this.add("ftbsba.tooltip.fluid", "Fluid: %smB %s");
            this.add("ftbsba.tooltip.slowmelter", "This is what happens when 'The Boss' decides to get involved at the last minute.");
            this.add("ftbsba.tooltip.fusing_machine", "Used to fuse items together to produce new results");
            this.add("ftbsba.tooltip.super_cooler", "Used to \"super\"-cool items to produce new results");
            this.add("ftbsba.jade.waiting", "Waiting for input: %s ticks");
            this.add("ftbsba.jade.processing", "Processing: %s/%s");
            this.add("ftbsba.jade.input", "Input");
            this.add("ftbsba.jade.buffer", "Buffer");
            this.add("config.jade.plugin_ftbsba.blocks", "FTB Skyblock Addons Blocks");
            this.add("container.ftbsba.super_cooler", "\"Super\" Cooler");
            this.add("container.ftbsba.fusing_machine", "SlowMelter 9000");
            this.add("ftbsba.jei.recipe.fusing", "SlowMelter 9000");
            this.add("ftbsba.jei.recipe.super_cooler", "\"Super\" Cooling");
            this.add("ftbsba.jei.recipe.hammer", "Hammering");
            this.add("ftbsba.jei.recipe.crook", "Crooks");
        }
    }

    private static class SMItemModels
    extends ItemModelProvider {
        public SMItemModels(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
            super(generator, modid, existingFileHelper);
        }

        protected void registerModels() {
            this.registerBlockModel(ToolsRegistry.IRON_AUTO_HAMMER);
            this.registerBlockModel(ToolsRegistry.GOLD_AUTO_HAMMER);
            this.registerBlockModel(ToolsRegistry.DIAMOND_AUTO_HAMMER);
            this.registerBlockModel(ToolsRegistry.NETHERITE_AUTO_HAMMER);
            this.simpleItem(ToolsRegistry.STONE_HAMMER);
            this.simpleItem(ToolsRegistry.IRON_HAMMER);
            this.simpleItem(ToolsRegistry.GOLD_HAMMER);
            this.simpleItem(ToolsRegistry.DIAMOND_HAMMER);
            this.simpleItem(ToolsRegistry.NETHERITE_HAMMER);
            this.simpleItem(ToolsRegistry.CROOK);
            this.simpleItem(ToolsRegistry.STONE_ROD);
        }

        private void simpleItem(RegistryObject<Item> item) {
            String path = item.getId().m_135815_();
            this.singleTexture(path, this.mcLoc("item/handheld"), "layer0", this.modLoc("item/" + path));
        }

        private void registerBlockModel(RegistryObject<Block> block) {
            String path = block.getId().m_135815_();
            ((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + path)));
        }
    }

    private static class SMBlockStateModels
    extends BlockStateProvider {
        private static final List<DirRotation> HORIZONTALS = (List)Util.m_137469_(new ArrayList(), l -> {
            l.add(new DirRotation(Direction.NORTH, 0));
            l.add(new DirRotation(Direction.EAST, 90));
            l.add(new DirRotation(Direction.SOUTH, 180));
            l.add(new DirRotation(Direction.WEST, 270));
        });
        private final SMBlockModels blockModels;

        public SMBlockStateModels(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper, SMBlockModels bm) {
            super(generator, modid, existingFileHelper);
            this.blockModels = bm;
        }

        public BlockModelProvider models() {
            return this.blockModels;
        }

        protected void registerStatesAndModels() {
            for (RegistryObject<Block> block : List.of(ToolsRegistry.IRON_AUTO_HAMMER, ToolsRegistry.GOLD_AUTO_HAMMER, ToolsRegistry.DIAMOND_AUTO_HAMMER, ToolsRegistry.NETHERITE_AUTO_HAMMER)) {
                MultiPartBlockStateBuilder b = this.getMultipartBuilder((Block)block.get());
                String path = block.getId().m_135815_();
                for (DirRotation d : HORIZONTALS) {
                    ((MultiPartBlockStateBuilder.PartBuilder)b.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + path))).rotationY(d.rotation).addModel()).condition((Property)AbstractMachineBlock.ACTIVE, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61374_, (Comparable[])new Direction[]{d.direction});
                    ((MultiPartBlockStateBuilder.PartBuilder)b.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + path + "_active"))).rotationY(d.rotation).addModel()).condition((Property)AbstractMachineBlock.ACTIVE, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.f_61374_, (Comparable[])new Direction[]{d.direction});
                }
            }
            for (RegistryObject<Block> block : List.of(ToolsRegistry.FUSING_MACHINE, ToolsRegistry.SUPER_COOLER)) {
                ModelFile model = this.machineModel(block, false);
                ModelFile activeModel = this.machineModel(block, true);
                VariantBlockStateBuilder.PartialBlockstate builder = this.getVariantBuilder((Block)block.get()).partialState();
                for (DirRotation d : HORIZONTALS) {
                    builder.with((Property)BlockStateProperties.f_61374_, (Comparable)d.direction).with((Property)AbstractMachineBlock.ACTIVE, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel(model, 0, d.rotation, false)});
                    builder.with((Property)BlockStateProperties.f_61374_, (Comparable)d.direction).with((Property)AbstractMachineBlock.ACTIVE, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel(activeModel, 0, d.rotation, false)});
                }
                this.simpleBlockItem((Block)block.get(), model);
            }
        }

        private ModelFile machineModel(RegistryObject<Block> block, boolean active) {
            String name = block.getId().m_135815_();
            String suffix = active ? "_active" : "";
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + suffix, "block/orientable")).texture("top", this.modLoc("block/" + name + "_top" + suffix))).texture("side", this.modLoc("block/generic_machine_side"))).texture("front", this.modLoc("block/" + name + "_front" + suffix));
        }
    }

    private static class SMBlockTags
    extends BlockTagsProvider {
        public SMBlockTags(DataGenerator generatorIn, ExistingFileHelper helper) {
            super(generatorIn, ToolsData.MODID, helper);
        }

        protected void m_6577_() {
            Object[] blocks = (Block[])Set.of((Block)ToolsRegistry.IRON_AUTO_HAMMER.get(), (Block)ToolsRegistry.GOLD_AUTO_HAMMER.get(), (Block)ToolsRegistry.DIAMOND_AUTO_HAMMER.get(), (Block)ToolsRegistry.NETHERITE_AUTO_HAMMER.get()).toArray(Block[]::new);
            this.m_206424_(Tags.Blocks.NEEDS_WOOD_TOOL).m_126584_(blocks);
            this.m_206424_(ToolsTags.Blocks.AUTO_HAMMERS).m_126584_(blocks);
        }
    }

    private static class SMItemTags
    extends ItemTagsProvider {
        public SMItemTags(DataGenerator dataGenerator, BlockTagsProvider blockTagProvider, ExistingFileHelper helper) {
            super(dataGenerator, blockTagProvider, ToolsData.MODID, helper);
        }

        protected void m_6577_() {
            this.m_206424_(ToolsTags.Items.HAMMERS).m_126584_((Object[])new Item[]{(Item)ToolsRegistry.STONE_HAMMER.get(), (Item)ToolsRegistry.IRON_HAMMER.get(), (Item)ToolsRegistry.GOLD_HAMMER.get(), (Item)ToolsRegistry.DIAMOND_HAMMER.get(), (Item)ToolsRegistry.NETHERITE_HAMMER.get()});
            this.m_206424_(ToolsTags.Items.CROOKS).m_126582_((Object)((Item)ToolsRegistry.CROOK.get()));
        }
    }

    private static class SMRecipes
    extends RecipeProvider {
        public SMRecipes(DataGenerator generatorIn) {
            super(generatorIn);
        }

        protected void m_176531_(Consumer<FinishedRecipe> consumer) {
            this.hammer((ItemLike)ToolsRegistry.STONE_HAMMER.get(), (ItemLike)Items.f_42594_, consumer);
            this.hammer((ItemLike)ToolsRegistry.IRON_HAMMER.get(), (ItemLike)Items.f_42416_, consumer);
            this.hammer((ItemLike)ToolsRegistry.GOLD_HAMMER.get(), (ItemLike)Items.f_42417_, consumer);
            this.hammer((ItemLike)ToolsRegistry.DIAMOND_HAMMER.get(), (ItemLike)Items.f_42415_, consumer);
            this.hammer((ItemLike)ToolsRegistry.NETHERITE_HAMMER.get(), (ItemLike)Items.f_42418_, consumer);
            ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ToolsRegistry.STONE_ROD.get()), (int)2).m_126132_("has_item", (CriterionTriggerInstance)SMRecipes.m_125977_((ItemLike)Items.f_42594_)).m_126130_("S").m_126130_("S").m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42594_).m_176498_(consumer);
            ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ToolsRegistry.CROOK.get()), (int)1).m_126132_("has_item", (CriterionTriggerInstance)SMRecipes.m_125977_((ItemLike)((ItemLike)ToolsRegistry.STONE_ROD.get()))).m_126130_("RR ").m_126130_(" R ").m_126130_(" R ").m_126127_(Character.valueOf('R'), (ItemLike)ToolsRegistry.STONE_ROD.get()).m_176498_(consumer);
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ToolsRegistry.IRON_AUTO_HAMMER.get())).m_126132_("has_item", (CriterionTriggerInstance)SMRecipes.m_125977_((ItemLike)((ItemLike)ToolsRegistry.IRON_HAMMER.get()))).m_126130_("IGI").m_126130_("XHX").m_126130_("RGR").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('X'), Tags.Items.GLASS).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).m_126127_(Character.valueOf('H'), (ItemLike)ToolsRegistry.IRON_HAMMER.get()).m_176498_(consumer);
            this.autoHammer((ItemLike)ToolsRegistry.GOLD_AUTO_HAMMER.get(), (Item)ToolsRegistry.IRON_AUTO_HAMMER_BLOCK_ITEM.get(), (Item)ToolsRegistry.GOLD_HAMMER.get(), consumer);
            this.autoHammer((ItemLike)ToolsRegistry.DIAMOND_AUTO_HAMMER.get(), (Item)ToolsRegistry.GOLD_AUTO_HAMMER_BLOCK_ITEM.get(), (Item)ToolsRegistry.DIAMOND_HAMMER.get(), consumer);
            this.autoHammer((ItemLike)ToolsRegistry.NETHERITE_AUTO_HAMMER.get(), (Item)ToolsRegistry.DIAMOND_AUTO_HAMMER_BLOCK_ITEM.get(), (Item)ToolsRegistry.NETHERITE_HAMMER.get(), consumer);
        }

        private void autoHammer(ItemLike output, Item center, Item top, Consumer<FinishedRecipe> consumer) {
            ShapedRecipeBuilder.m_126116_((ItemLike)output).m_126132_("has_item", (CriterionTriggerInstance)SMRecipes.m_125977_((ItemLike)center)).m_126130_("ITI").m_126130_("XCX").m_126130_("RGR").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('X'), Tags.Items.GLASS).m_126127_(Character.valueOf('T'), (ItemLike)top).m_126127_(Character.valueOf('C'), (ItemLike)center).m_176498_(consumer);
        }

        private void hammer(ItemLike output, TagKey<Item> head, Consumer<FinishedRecipe> consumer) {
            ShapedRecipeBuilder.m_126116_((ItemLike)output).m_126132_("has_item", (CriterionTriggerInstance)SMRecipes.m_206406_(head)).m_126130_("hrh").m_126130_(" r ").m_126130_(" r ").m_206416_(Character.valueOf('h'), head).m_126127_(Character.valueOf('r'), (ItemLike)ToolsRegistry.STONE_ROD.get()).m_176498_(consumer);
        }

        private void hammer(ItemLike output, ItemLike head, Consumer<FinishedRecipe> consumer) {
            ShapedRecipeBuilder.m_126116_((ItemLike)output).m_126132_("has_item", (CriterionTriggerInstance)SMRecipes.m_125977_((ItemLike)head)).m_126130_("hrh").m_126130_(" r ").m_126130_(" r ").m_126127_(Character.valueOf('h'), head).m_126127_(Character.valueOf('r'), (ItemLike)ToolsRegistry.STONE_ROD.get()).m_176498_(consumer);
        }
    }

    private static class SMLootTableProvider
    extends LootTableProvider {
        public SMLootTableProvider(DataGenerator dataGeneratorIn) {
            super(dataGeneratorIn);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return Lists.newArrayList((Object[])new Pair[]{Pair.of(SMBlockLootProvider::new, (Object)LootContextParamSets.f_81421_)});
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext tracker) {
            map.forEach((k, v) -> LootTables.m_79202_((ValidationContext)tracker, (ResourceLocation)k, (LootTable)v));
        }
    }

    private static class SMLootModifiers
    extends GlobalLootModifierProvider {
        public SMLootModifiers(DataGenerator gen) {
            super(gen, ToolsData.MODID);
        }

        protected void start() {
            this.add("crook_loot_modifier", (IGlobalLootModifier)new CrookModifier(new LootItemCondition[]{MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(ToolsTags.Items.CROOKS)).m_6409_()}));
            this.add("hammer_loot_modifier", (IGlobalLootModifier)new HammerModifier(new LootItemCondition[]{MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(ToolsTags.Items.HAMMERS)).m_6409_()}));
        }
    }

    public static class SMBlockLootProvider
    extends BlockLoot {
        Set<Block> blocks = new HashSet<Block>();

        protected void addTables() {
            this.m_124288_((Block)ToolsRegistry.IRON_AUTO_HAMMER.get());
            this.m_124288_((Block)ToolsRegistry.GOLD_AUTO_HAMMER.get());
            this.m_124288_((Block)ToolsRegistry.DIAMOND_AUTO_HAMMER.get());
            this.m_124288_((Block)ToolsRegistry.NETHERITE_AUTO_HAMMER.get());
            this.preserveContents((Block)ToolsRegistry.FUSING_MACHINE.get(), (BlockEntityType)ToolsRegistry.FUSING_MACHINE_BLOCK_ENTITY.get());
            this.preserveContents((Block)ToolsRegistry.SUPER_COOLER.get(), (BlockEntityType)ToolsRegistry.SUPER_COOLER_BLOCK_ENTITY.get());
        }

        private void preserveContents(Block block, BlockEntityType<?> blockEntity) {
            LootPool.Builder builder = LootPool.m_79043_().m_79080_(ExplosionCondition.m_81661_()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("energy", "BlockEntityTag.energy", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("fluid", "BlockEntityTag.fluid", CopyNbtFunction.MergeStrategy.REPLACE)));
            this.m_124165_(block, LootTable.m_79147_().m_79161_(builder));
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.blocks;
        }

        protected void m_124165_(Block blockIn, LootTable.Builder table) {
            this.blocks.add(blockIn);
            super.m_124165_(blockIn, table);
        }
    }

    private record DirRotation(Direction direction, int rotation) {
    }
}

