/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.client.overlay;

import ad_astra_giselle_addon.common.content.oxygen.OxygenStorageUtils;
import ad_astra_giselle_addon.common.registry.AddonEnchantments;
import ad_astra_giselle_addon.common.registry.AddonItems;
import ad_astra_giselle_addon.common.util.TranslationUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import earth.terrarium.ad_astra.client.screen.GuiUtil;
import earth.terrarium.ad_astra.client.screen.PlayerOverlayScreen;
import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class OxygenCanOverlay {
    public static final ResourceLocation OXYGEN_TANK_EMPTY_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/overlay/oxygen_tank_empty.png");
    public static final ResourceLocation OXYGEN_TANK_FULL_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/overlay/oxygen_tank_full.png");
    public static final String OXYGENCAN_DESCRIPTION_ID = Util.m_137492_((String)"item", (ResourceLocation)AddonItems.OXYGEN_CAN.getId());

    public static void renderHud(PoseStack poseStack, float partialTick) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player.m_5833_() || minecraft.f_91066_.f_92063_) {
            return;
        }
        if (PlayerOverlayScreen.shouldRenderOxygen) {
            OxygenStorageUtils.getExtractableStoredRatio((LivingEntity)player).ifPresent(ratio -> {
                Font font = minecraft.f_91062_;
                MutableComponent component = Component.m_237115_((String)OXYGENCAN_DESCRIPTION_ID).m_130946_(": ").m_7220_(TranslationUtils.formatPercent(ratio)).m_130938_(s -> s.m_178520_(Mth.m_14169_((float)((float)(ratio / 3.0)), (float)1.0f, (float)1.0f)));
                int textureWidth = 62;
                int textureHeight = 52;
                int width = font.m_92852_((FormattedText)component);
                float x = (float)(5 + AdAstraConfig.oxygenBarXOffset) + (float)(textureWidth - width) / 2.0f;
                Objects.requireNonNull(font);
                float y = 25 + AdAstraConfig.oxygenBarYOffset + textureHeight + 9 + 3;
                font.m_92763_(poseStack, (Component)component, Math.max(x, 0.0f), y, 0xFFFFFF);
            });
        } else if (EnchantmentHelper.m_44836_((Enchantment)AddonEnchantments.OXYGEN_PROOF.get(), (LivingEntity)player) > 0) {
            OxygenStorageUtils.getExtractableStoredRatio((LivingEntity)player).ifPresent(ratio -> OxygenCanOverlay.renderOxygenCanTank(poseStack, minecraft, ratio));
        }
    }

    public static void renderOxygenCanTank(PoseStack poseStack, Minecraft minecraft, double oxygenRatio) {
        poseStack.m_85836_();
        poseStack.m_85841_(AdAstraConfig.oxygenBarScale, AdAstraConfig.oxygenBarScale, AdAstraConfig.oxygenBarScale);
        Rect2i rect = PlayerOverlayScreen.getOxygenTankUnscaledRect((Minecraft)minecraft);
        GuiUtil.drawVerticalReverse((PoseStack)poseStack, (int)rect.m_110085_(), (int)rect.m_110086_(), (int)rect.m_110090_(), (int)rect.m_110091_(), (ResourceLocation)OXYGEN_TANK_EMPTY_TEXTURE, (double)oxygenRatio);
        GuiUtil.drawVertical((PoseStack)poseStack, (int)rect.m_110085_(), (int)rect.m_110086_(), (int)rect.m_110090_(), (int)rect.m_110091_(), (ResourceLocation)OXYGEN_TANK_FULL_TEXTURE, (double)oxygenRatio);
        MutableComponent text = Component.m_237115_((String)OXYGENCAN_DESCRIPTION_ID).m_130946_(": ").m_7220_(TranslationUtils.formatPercent(oxygenRatio)).m_130938_(s -> s.m_178520_(Mth.m_14169_((float)((float)(oxygenRatio / 3.0)), (float)1.0f, (float)1.0f)));
        int textWidth = minecraft.f_91062_.m_92852_((FormattedText)text);
        minecraft.f_91062_.m_92763_(poseStack, (Component)text, (float)rect.m_110085_() + (float)(rect.m_110090_() - textWidth) / 2.0f, (float)(rect.m_110086_() + rect.m_110091_() + 3), 0xFFFFFF);
        poseStack.m_85849_();
    }
}

