/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.client;

import ad_astra_giselle_addon.client.EnchantedBookTooltipHelper;
import ad_astra_giselle_addon.client.overlay.OxygenCanOverlay;
import ad_astra_giselle_addon.client.renderer.blockentity.WorkingAreaBlockEntityRenderer;
import ad_astra_giselle_addon.client.renderer.vehicle.lander.LanderIconItemRenderer;
import ad_astra_giselle_addon.client.screen.AutomationNasaWorkbenchScreen;
import ad_astra_giselle_addon.client.screen.FuelLoaderScreen;
import ad_astra_giselle_addon.client.screen.GravityNormalizerScreen;
import ad_astra_giselle_addon.client.screen.RocketSensorScreen;
import ad_astra_giselle_addon.client.util.RenderHelper;
import ad_astra_giselle_addon.common.AdAstraGiselleAddon;
import ad_astra_giselle_addon.common.enchantment.EnchantmentHelper2;
import ad_astra_giselle_addon.common.item.IClientExtensionItem;
import ad_astra_giselle_addon.common.registry.AddonBlockEntityTypes;
import ad_astra_giselle_addon.common.registry.AddonItems;
import ad_astra_giselle_addon.common.registry.AddonMenuTypes;
import ad_astra_giselle_addon.common.util.TriConsumer;
import com.teamresourceful.resourcefulconfig.client.ConfigScreen;
import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfig;
import earth.terrarium.ad_astra.client.AdAstraClient;
import earth.terrarium.ad_astra.client.ClientPlatformUtils;
import earth.terrarium.ad_astra.client.renderer.entity.vehicle.lander.LanderModel;
import earth.terrarium.ad_astra.client.renderer.entity.vehicle.lander.LanderRenderer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public class AdAstraGiselleAddonClient {
    private static final Map<IClientExtensionItem, BlockEntityWithoutLevelRenderer> ITEM_RENDERERS = new HashMap<IClientExtensionItem, BlockEntityWithoutLevelRenderer>();

    private AdAstraGiselleAddonClient() {
    }

    @Nullable
    public static ConfigScreen getConfigScreen(@Nullable Screen parent) {
        ResourcefulConfig config = AdAstraGiselleAddon.config();
        return config != null ? new ConfigScreen(parent, null, config) : null;
    }

    public static void initializeClient() {
        AdAstraGiselleAddonClient.registerScreens();
        ITEM_RENDERERS.put(AddonItems.LANDER_ICON.get(), new LanderIconItemRenderer(LanderModel.LAYER_LOCATION, LanderRenderer.TEXTURE));
    }

    public static void registerScreens() {
        ClientPlatformUtils.registerScreen((MenuType)((MenuType)AddonMenuTypes.FUEL_LOADER.get()), FuelLoaderScreen::new);
        ClientPlatformUtils.registerScreen((MenuType)((MenuType)AddonMenuTypes.AUTOMATION_NASA_WORKBENCH.get()), AutomationNasaWorkbenchScreen::new);
        ClientPlatformUtils.registerScreen((MenuType)((MenuType)AddonMenuTypes.GRAVITY_NORMALIZER.get()), GravityNormalizerScreen::new);
        ClientPlatformUtils.registerScreen((MenuType)((MenuType)AddonMenuTypes.ROCKET_SENSOR.get()), RocketSensorScreen::new);
    }

    public static void registerBlockAtlas(Consumer<ResourceLocation> register) {
        register.accept(RenderHelper.TILE_SURFACE);
    }

    public static void registerOverlay(BiConsumer<String, AdAstraClient.RenderHud> register) {
        register.accept("oxygen_can", OxygenCanOverlay::renderHud);
    }

    public static void registerBlockEntityRenderer(BlockEntityRendererRegister register) {
        register.regsiter((BlockEntityType)AddonBlockEntityTypes.FUEL_LOADER.get(), context -> new WorkingAreaBlockEntityRenderer(context));
        register.regsiter((BlockEntityType)AddonBlockEntityTypes.GRAVITY_NORMALIZER.get(), context -> new WorkingAreaBlockEntityRenderer(context));
        register.regsiter((BlockEntityType)AddonBlockEntityTypes.ROCKET_SENSOR.get(), context -> new WorkingAreaBlockEntityRenderer(context));
    }

    public static void registerItemTooltip(Consumer<TriConsumer<ItemStack, TooltipFlag, List<Component>>> register) {
        register.accept(EnchantedBookTooltipHelper::addTooltip);
    }

    public static void registerReloadListeners(BiConsumer<String, PreparableReloadListener> register) {
        register.accept("cleardescriptionscache", (PreparableReloadListener)new ResourceManagerReloadListener(){

            public void m_6213_(ResourceManager pResourceManager) {
                EnchantmentHelper2.clearDescriptionsCache();
            }
        });
        register.accept("itemrenderers", (PreparableReloadListener)new ResourceManagerReloadListener(){

            public void m_6213_(ResourceManager pResourceManager) {
                ITEM_RENDERERS.values().forEach(e -> e.m_6213_(pResourceManager));
            }
        });
    }

    public static BlockEntityWithoutLevelRenderer getItemRenderer(IClientExtensionItem item) {
        return ITEM_RENDERERS.get(item);
    }

    public static Set<Map.Entry<IClientExtensionItem, BlockEntityWithoutLevelRenderer>> getItemRenderers() {
        return ITEM_RENDERERS.entrySet();
    }

    public static interface BlockEntityRendererRegister {
        public <T extends BlockEntity> void regsiter(BlockEntityType<? extends T> var1, BlockEntityRendererProvider<T> var2);
    }
}

