/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.repair;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.renderer.ECRendererHelper;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.renderer.ISpellRenderer;
import sirttas.elementalcraft.spell.repair.RepairSpell;

public class RepairSpellRenderer
implements ISpellRenderer {
    private static final float HAMMER_INTERVAL = 6.5f;

    @Override
    public void render(Spell spell, Entity caster, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (caster instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)caster;
            HitResult ray = EntityHelper.rayTrace(caster);
            HitResult.Type rayType = ray.m_6662_();
            if (rayType == HitResult.Type.BLOCK && ray instanceof BlockHitResult) {
                BlockHitResult blockRay = (BlockHitResult)ray;
                if (spell instanceof RepairSpell) {
                    RepairSpell repairSpell = (RepairSpell)spell;
                    BlockPos anvilPos = blockRay.m_82425_().m_121945_(blockRay.m_82434_());
                    Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
                    Vec3 cameraPos = camera.m_90583_();
                    PoseStack newStack = new PoseStack();
                    BlockState anvilState = RepairSpellRenderer.getAnvilState((Player)player, blockRay);
                    ItemStack itemToRepair = repairSpell.getItemToRepair((Player)player);
                    if (anvilState == null) {
                        return;
                    }
                    newStack.m_85845_(Vector3f.f_122223_.m_122240_(camera.m_90589_()));
                    newStack.m_85845_(Vector3f.f_122225_.m_122240_(camera.m_90590_() + 180.0f));
                    newStack.m_85837_((double)anvilPos.m_123341_() - cameraPos.m_7096_(), (double)anvilPos.m_123342_() - cameraPos.m_7098_(), (double)anvilPos.m_123343_() - cameraPos.m_7094_());
                    ECRendererHelper.renderBatched(anvilState, newStack, buffer, caster.m_9236_(), anvilPos);
                    newStack.m_85837_(0.5, 1.0, 0.5);
                    newStack.m_85845_(((Direction)anvilState.m_61143_((Property)AnvilBlock.f_48764_)).m_122406_());
                    if (itemToRepair.m_150930_((Item)ECItems.STAFF.get())) {
                        newStack.m_85845_(Vector3f.f_122223_.m_122240_(-45.0f));
                        newStack.m_85837_(0.0, -0.3, 0.0);
                        newStack.m_85845_(Vector3f.f_122225_.m_122240_(15.0f));
                    }
                    ECRendererHelper.renderItem(itemToRepair, newStack, buffer, packedLight, OverlayTexture.f_118083_);
                }
            }
        }
    }

    @Override
    public void renderFirstPerson(Spell spell, LocalPlayer player, InteractionHand hand, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        ISpellRenderer.super.renderFirstPerson(spell, player, hand, partialTicks, poseStack, buffer, packedLight);
        float useTicks = 40.0f - ((float)player.m_21212_() - partialTicks + 1.0f) % 40.0f;
        float swing = useTicks < 19.5f ? useTicks % 6.5f / 6.5f : 0.0f;
        Minecraft.m_91087_().f_91063_.f_109055_.m_109371_((AbstractClientPlayer)player, partialTicks, Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()), InteractionHand.MAIN_HAND, swing, new ItemStack((ItemLike)ECItems.REPAIR_HAMMER.get()), 0.0f, poseStack, buffer, packedLight);
    }

    @Nullable
    private static BlockState getAnvilState(Player player, BlockHitResult blockRay) {
        return Blocks.f_50322_.m_5573_(new BlockPlaceContext(player, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Blocks.f_50322_), blockRay));
    }

    @Override
    public boolean hideHand(InteractionHand hand) {
        return true;
    }
}

