/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument.io.sawing;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.block.instrument.io.mill.woodsaw.WaterMillWoodSawBlockEntity;
import sirttas.elementalcraft.recipe.ECRecipeSerializers;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.recipe.RecipeHelper;
import sirttas.elementalcraft.recipe.instrument.io.IIOInstrumentRecipe;

public record SawingRecipe(ResourceLocation id, Ingredient ingredient, ItemStack output, int elementAmount, int luckRation) implements IIOInstrumentRecipe<WaterMillWoodSawBlockEntity>
{
    public static final String NAME = "sawing";

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.ingredient.test(stack) && IIOInstrumentRecipe.super.matches(stack);
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.ingredient});
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.output;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ECRecipeSerializers.SAWING.get();
    }

    @Override
    public int getLuck(WaterMillWoodSawBlockEntity instrument) {
        return Math.round(instrument.getRuneHandler().getBonus(Rune.BonusType.LUCK) * (float)this.luckRation);
    }

    @Override
    public List<ElementType> getValidElementTypes() {
        return List.of(ElementType.WATER);
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ECRecipeTypes.SAWING.get();
    }

    @Override
    public RandomSource getRand(WaterMillWoodSawBlockEntity instrument) {
        return instrument.m_58904_().m_213780_();
    }

    public static class Serializer
    implements RecipeSerializer<SawingRecipe> {
        @Nonnull
        public SawingRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            int elementAmount = GsonHelper.m_13927_((JsonObject)json, (String)"element_amount");
            Ingredient ingredient = RecipeHelper.deserializeIngredient(json, "input");
            ItemStack output = RecipeHelper.readRecipeOutput(json, "output");
            int luckRation = GsonHelper.m_13927_((JsonObject)json, (String)"luck_ratio");
            if (!output.m_41619_()) {
                return new SawingRecipe(recipeId, ingredient, output, elementAmount, luckRation);
            }
            throw new IllegalStateException("Sawing recipe output is empty!");
        }

        public SawingRecipe fromNetwork(@Nonnull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int elementAmount = buffer.readInt();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            int luckRation = buffer.readInt();
            return new SawingRecipe(recipeId, ingredient, output, elementAmount, luckRation);
        }

        public void toNetwork(FriendlyByteBuf buffer, SawingRecipe recipe) {
            buffer.writeInt(recipe.getElementAmount());
            ((Ingredient)recipe.m_7527_().get(0)).m_43923_(buffer);
            buffer.m_130055_(recipe.m_8043_());
            buffer.writeInt(recipe.luckRation());
        }
    }
}

