/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.source.analysis;

import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.block.source.trait.SourceTraits;
import sirttas.elementalcraft.container.menu.AbstractECMenu;
import sirttas.elementalcraft.container.menu.ECMenus;
import sirttas.elementalcraft.item.source.analysis.SourceAnalysisGlassMessage;
import sirttas.elementalcraft.network.message.MessageHelper;

public class SourceAnalysisGlassMenu
extends AbstractECMenu {
    private final Player player;
    private Map<ResourceKey<SourceTrait>, ISourceTraitValue> traits;

    public SourceAnalysisGlassMenu(int id, Inventory inventory) {
        this(id, inventory, SourceTraits.createTraitMap());
    }

    public SourceAnalysisGlassMenu(int id, Inventory inventory, Map<ResourceKey<SourceTrait>, ISourceTraitValue> traits) {
        super(ECMenus.SOURCE_ANALYSIS_GLASS, id);
        this.player = inventory.f_35978_;
        this.traits = traits;
        this.addSlots(inventory);
    }

    private void addSlots(Inventory inventory) {
        this.addPlayerSlots(inventory, 98);
    }

    public Map<ResourceKey<SourceTrait>, ISourceTraitValue> getTraits() {
        return this.traits;
    }

    public void setTraits(Map<ResourceKey<SourceTrait>, ISourceTraitValue> traits) {
        this.traits = traits;
    }

    @Override
    public void onOpen(Player player) {
        this.sendTraits();
    }

    private void sendTraits() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MessageHelper.sendToPlayer(serverPlayer, new SourceAnalysisGlassMessage(this.traits));
        }
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        return ItemStack.f_41583_;
    }
}

