/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.mixin.optimizations.sync_loads;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.structures.BuriedTreasureStructure;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StructureCheck.class})
public class StructureCheckMixin {
    @Shadow
    @Final
    private ChunkGenerator f_197242_;
    @Shadow
    @Final
    private RandomState f_226710_;

    @Redirect(method={"canCreateStructure"}, at=@At(value="INVOKE", target="Ljava/util/Optional;isPresent()Z"))
    private boolean servercore$skipInvalidBiomes(Optional<Structure.GenerationStub> optional, ChunkPos chunkPos, Structure structure) {
        return optional.isPresent() && this.isBiomeValid(structure, optional.get().f_226669_());
    }

    @Inject(method={"checkStart"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/levelgen/structure/StructureCheck;tryLoadFromStorage(Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/world/level/levelgen/structure/Structure;ZJ)Lnet/minecraft/world/level/levelgen/structure/StructureCheckResult;", shift=At.Shift.BEFORE)})
    private void servercore$skipInvalidBiomes(ChunkPos chunkPos, Structure structure, boolean skipKnownStructures, CallbackInfoReturnable<StructureCheckResult> cir) {
        BlockPos pos = this.getRoughStructurePosition(structure, chunkPos);
        if (pos != null && !this.isBiomeValid(structure, pos)) {
            cir.setReturnValue((Object)StructureCheckResult.START_NOT_PRESENT);
        }
    }

    private boolean isBiomeValid(Structure structure, BlockPos pos) {
        return structure.m_226559_().m_203333_(this.f_197242_.m_62218_().m_203407_(pos.m_123341_() >> 2, pos.m_123342_() >> 2, pos.m_123343_() >> 2, this.f_226710_.m_224579_()));
    }

    private BlockPos getRoughStructurePosition(Structure structure, ChunkPos chunkPos) {
        if (structure instanceof BuriedTreasureStructure) {
            return chunkPos.m_151394_(this.f_197242_.m_6337_());
        }
        return null;
    }
}

