/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.dynamic;

import me.wesley1808.servercore.common.config.tables.CommandConfig;
import me.wesley1808.servercore.common.config.tables.DynamicConfig;
import me.wesley1808.servercore.common.dynamic.DynamicSetting;
import me.wesley1808.servercore.common.interfaces.IMinecraftServer;
import me.wesley1808.servercore.common.interfaces.IMobCategory;
import me.wesley1808.servercore.common.services.platform.PlatformHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.MobCategory;

public class DynamicManager {
    private final MinecraftServer server;
    private final boolean isClient;
    private double averageTickTime;
    private int count;

    public DynamicManager(MinecraftServer server) {
        this.server = server;
        this.isClient = server.m_129792_();
        if (DynamicConfig.ENABLED.get().booleanValue()) {
            int maxViewDistance = DynamicConfig.MAX_VIEW_DISTANCE.get();
            int maxSimDistance = DynamicConfig.MAX_SIMULATION_DISTANCE.get();
            if (server.m_6846_().m_11312_() > maxViewDistance) {
                this.modifyViewDistance(maxViewDistance);
            }
            if (server.m_6846_().m_184213_() > maxSimDistance) {
                this.modifySimulationDistance(maxSimDistance);
            }
            DynamicManager.modifyMobcaps(DynamicConfig.MAX_MOBCAP.get());
        }
    }

    public static DynamicManager getInstance(MinecraftServer server) {
        return ((IMinecraftServer)server).getDynamicManager();
    }

    public static String getModifierAsPercentage() {
        return String.format("%.0f%%", DynamicSetting.MOBCAP_MULTIPLIER.get() * 100.0);
    }

    public static String createStatusReport(String title) {
        return title + "\n" + CommandConfig.STATUS_CONTENT.get().replace("${version}", PlatformHelper.getVersion()).replace("${mobcap_percentage}", DynamicManager.getModifierAsPercentage()).replace("${chunk_tick_distance}", String.format("%.0f", DynamicSetting.CHUNK_TICK_DISTANCE.get())).replace("${simulation_distance}", String.format("%.0f", DynamicSetting.SIMULATION_DISTANCE.get())).replace("${view_distance}", String.format("%.0f", DynamicSetting.VIEW_DISTANCE.get()));
    }

    public static void update(MinecraftServer server) {
        if (server.m_129921_() % 20 == 0) {
            DynamicManager manager = DynamicManager.getInstance(server);
            manager.updateValues();
            if (DynamicConfig.ENABLED.get().booleanValue()) {
                manager.runPerformanceChecks();
            }
        }
    }

    private void updateValues() {
        this.averageTickTime = this.calculateAverageTickTime();
        ++this.count;
    }

    protected double calculateAverageTickTime() {
        return this.server.m_129903_();
    }

    private void runPerformanceChecks() {
        boolean increase;
        double targetMspt = DynamicConfig.TARGET_MSPT.get().intValue();
        boolean decrease = this.averageTickTime > targetMspt + 5.0;
        boolean bl = increase = this.averageTickTime < Math.max(targetMspt - 5.0, 2.0);
        if (decrease || increase) {
            DynamicSetting setting;
            DynamicSetting[] dynamicSettingArray = DynamicSetting.values();
            int n = dynamicSettingArray.length;
            for (int i = 0; !(i >= n || (setting = dynamicSettingArray[i]).shouldRun(this.count) && setting.modify(increase, this)); ++i) {
            }
        }
    }

    public void modifyViewDistance(int distance) {
        this.server.m_6846_().m_11217_(distance);
        if (this.isClient) {
            Minecraft.m_91087_().f_91066_.m_231984_().m_231514_((Object)distance);
        }
    }

    public void modifySimulationDistance(int distance) {
        this.server.m_6846_().m_184211_(distance);
        if (this.isClient) {
            Minecraft.m_91087_().f_91066_.m_232001_().m_231514_((Object)distance);
        }
    }

    public static void modifyMobcaps(double modifier) {
        for (MobCategory category : MobCategory.values()) {
            IMobCategory.modifyCapacity(category, modifier);
        }
    }

    public double getAverageTickTime() {
        return this.averageTickTime;
    }
}

