/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.ThrowableCopyEntity;
import vazkii.botania.xplat.BotaniaConfig;

public class FallingStarEntity
extends ThrowableCopyEntity {
    private static final String TAG_HAS_BEEN_IN_AIR = "hasBeenInAir";
    private boolean hasBeenInAir = false;

    public FallingStarEntity(EntityType<FallingStarEntity> type, Level world) {
        super(type, world);
    }

    public FallingStarEntity(LivingEntity e, Level world) {
        super(BotaniaEntities.FALLING_STAR, e, world);
    }

    protected void m_8097_() {
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.hasBeenInAir && !this.m_9236_().f_46443_) {
            BlockState bs = this.m_146900_();
            this.hasBeenInAir = bs.m_60795_() || this.m_20069_() || this.m_20077_();
        }
        float dist = 1.5f;
        SparkleParticleData data = SparkleParticleData.sparkle(2.0f, 1.0f, 0.4f, 1.0f, 6);
        for (int i = 0; i < 10; ++i) {
            float xs = (float)(Math.random() - 0.5) * dist;
            float ys = (float)(Math.random() - 0.5) * dist;
            float zs = (float)(Math.random() - 0.5) * dist;
            this.m_9236_().m_7107_((ParticleOptions)data, this.m_20185_() + (double)xs, this.m_20186_() + (double)ys, this.m_20189_() + (double)zs, 0.0, 0.0, 0.0);
        }
        Entity thrower = this.m_37282_();
        if (!this.m_9236_().f_46443_ && thrower != null) {
            AABB axis = new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19790_, this.f_19791_, this.f_19792_).m_82400_(2.0);
            List entities = this.m_9236_().m_45976_(LivingEntity.class, axis);
            for (LivingEntity living : entities) {
                if (living == thrower || living.f_20916_ != 0) continue;
                this.m_6532_((HitResult)new EntityHitResult((Entity)living));
                return;
            }
        }
        if (this.f_19797_ > 200) {
            this.m_146870_();
        }
    }

    protected void m_5790_(@NotNull EntityHitResult hit) {
        super.m_5790_(hit);
        Entity e = hit.m_82443_();
        if (e instanceof Villager) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            if (e != this.m_37282_() && e.m_6084_()) {
                Entity entity = this.m_37282_();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    e.m_6469_(DamageSource.m_19344_((Player)player), Math.random() < 0.25 ? 10.0f : 5.0f);
                } else {
                    e.m_6469_(DamageSource.f_19318_, Math.random() < 0.25 ? 10.0f : 5.0f);
                }
            }
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult hit) {
        super.m_8060_(hit);
        if (!this.m_9236_().f_46443_) {
            BlockPos bpos = hit.m_82425_();
            BlockState state = this.m_9236_().m_8055_(bpos);
            if (this.hasBeenInAir) {
                if (BotaniaConfig.common().blockBreakParticles() && !state.m_60795_()) {
                    this.m_9236_().m_46796_(2001, bpos, Block.m_49956_((BlockState)state));
                }
                this.m_146870_();
            }
        }
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_(TAG_HAS_BEEN_IN_AIR, this.hasBeenInAir);
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.hasBeenInAir = tag.m_128471_(TAG_HAS_BEEN_IN_AIR);
    }
}

