/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.CosmeticAttachable;
import vazkii.botania.api.item.CosmeticBauble;

public class CosmeticAttachRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<CosmeticAttachRecipe> SERIALIZER = new SimpleRecipeSerializer(CosmeticAttachRecipe::new);

    public CosmeticAttachRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        boolean foundCosmetic = false;
        boolean foundAttachable = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof CosmeticBauble && !foundCosmetic) {
                foundCosmetic = true;
                continue;
            }
            if (foundAttachable) continue;
            Item item = stack.m_41720_();
            if (item instanceof CosmeticAttachable) {
                CosmeticAttachable attachable = (CosmeticAttachable)item;
                if (!(stack.m_41720_() instanceof CosmeticBauble) && attachable.getCosmeticItem(stack).m_41619_()) {
                    foundAttachable = true;
                    continue;
                }
            }
            return false;
        }
        return foundCosmetic && foundAttachable;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv) {
        Item stack;
        ItemStack cosmeticItem = ItemStack.f_41583_;
        ItemStack attachableItem = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof CosmeticBauble && cosmeticItem.m_41619_()) {
                cosmeticItem = stack;
                continue;
            }
            attachableItem = stack;
        }
        stack = attachableItem.m_41720_();
        if (!(stack instanceof CosmeticAttachable)) {
            return ItemStack.f_41583_;
        }
        CosmeticAttachable attachable = (CosmeticAttachable)stack;
        if (!attachable.getCosmeticItem(attachableItem).m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack copy = attachableItem.m_41777_();
        attachable.setCosmeticItem(copy, cosmeticItem);
        return copy;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

