/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.corporea;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.api.corporea.CorporeaRequestor;
import vazkii.botania.api.corporea.CorporeaResult;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.common.BotaniaStats;
import vazkii.botania.common.advancements.CorporeaRequestTrigger;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.corporea.BaseCorporeaBlockEntity;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.network.serverbound.IndexStringRequestPacket;
import vazkii.botania.xplat.ClientXplatAbstractions;
import vazkii.botania.xplat.XplatAbstractions;

public class CorporeaIndexBlockEntity
extends BaseCorporeaBlockEntity
implements CorporeaRequestor {
    public static final double RADIUS = 2.5;
    public static final int MAX_REQUEST = 65536;
    private static final Set<CorporeaIndexBlockEntity> serverIndexes = Collections.newSetFromMap(new WeakHashMap());
    private static final Set<CorporeaIndexBlockEntity> clientIndexes = Collections.newSetFromMap(new WeakHashMap());
    private static final Map<Pattern, IRegexStacker> patterns = new LinkedHashMap<Pattern, IRegexStacker>();
    public int ticksWithCloseby = 0;
    public float closeby = 0.0f;
    public boolean hasCloseby;

    public CorporeaIndexBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.CORPOREA_INDEX, pos, state);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, CorporeaIndexBlockEntity self) {
        double x = (double)worldPosition.m_123341_() + 0.5;
        double y = (double)worldPosition.m_123342_() + 0.5;
        double z = (double)worldPosition.m_123343_() + 0.5;
        List players = level.m_45976_(Player.class, new AABB(x - 2.5, y - 2.5, z - 2.5, x + 2.5, y + 2.5, z + 2.5));
        self.hasCloseby = false;
        if (self.getSpark() != null) {
            for (Player player : players) {
                if (!self.isInRange(player)) continue;
                self.hasCloseby = true;
                break;
            }
        }
        float step = 0.2f;
        if (self.hasCloseby) {
            ++self.ticksWithCloseby;
            if (self.closeby < 1.0f) {
                self.closeby += step;
            }
        } else if (self.closeby > 0.0f) {
            self.closeby -= step;
        }
        if (!self.m_58901_()) {
            CorporeaIndexBlockEntity.addIndex(self);
        }
    }

    public static List<CorporeaIndexBlockEntity> getNearbyValidIndexes(Player player) {
        ArrayList<CorporeaIndexBlockEntity> result = new ArrayList<CorporeaIndexBlockEntity>();
        for (CorporeaIndexBlockEntity index : player.m_9236_().f_46443_ ? clientIndexes : serverIndexes) {
            if (index.getSpark() == null || !index.isInRange(player)) continue;
            result.add(index);
        }
        return result;
    }

    public void m_7651_() {
        super.m_7651_();
        CorporeaIndexBlockEntity.removeIndex(this);
    }

    @Override
    public void doCorporeaRequest(CorporeaRequestMatcher request, int count, CorporeaSpark spark, @Nullable LivingEntity entity) {
        this.doRequest(request, count, spark, entity);
    }

    private CorporeaResult doRequest(CorporeaRequestMatcher matcher, int count, CorporeaSpark spark, @Nullable LivingEntity entity) {
        CorporeaResult result = CorporeaHelper.instance().requestItem(matcher, count, spark, entity, true);
        List<ItemStack> stacks = result.stacks();
        spark.onItemsRequested(stacks);
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) continue;
            ItemEntity item = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.5, (double)this.f_58858_.m_123343_() + 0.5, stack);
            this.f_58857_.m_7967_((Entity)item);
        }
        return result;
    }

    private boolean isInRange(Player player) {
        return player.m_9236_().m_46472_() == this.f_58857_.m_46472_() && (double)MathHelper.pointDistancePlane((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, player.m_20185_(), player.m_20189_()) < 2.5 && Math.abs((double)this.m_58899_().m_123342_() + 0.5 - player.m_20186_()) < 5.0;
    }

    public static void addPattern(String pattern, IRegexStacker stacker) {
        patterns.put(Pattern.compile(pattern), stacker);
    }

    public static int i(Matcher m, int g) {
        try {
            int i = Math.abs(Integer.parseInt(m.group(g)));
            return i;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static void addIndex(CorporeaIndexBlockEntity index) {
        Set<CorporeaIndexBlockEntity> set = index.f_58857_.f_46443_ ? clientIndexes : serverIndexes;
        set.add(index);
    }

    private static void removeIndex(CorporeaIndexBlockEntity index) {
        Set<CorporeaIndexBlockEntity> set = index.f_58857_.f_46443_ ? clientIndexes : serverIndexes;
        set.remove(index);
    }

    public static void clearIndexCache() {
        clientIndexes.clear();
        serverIndexes.clear();
    }

    public void performPlayerRequest(ServerPlayer player, CorporeaRequestMatcher request, int count) {
        if (!XplatAbstractions.INSTANCE.fireCorporeaIndexRequestEvent(player, request, count, this.getSpark())) {
            CorporeaResult res = this.doRequest(request, count, this.getSpark(), (LivingEntity)player);
            player.m_213846_((Component)Component.m_237110_((String)"botaniamisc.requestMsg", (Object[])new Object[]{count, request.getRequestName(), res.matchedCount(), res.extractedCount()}).m_130940_(ChatFormatting.LIGHT_PURPLE));
            player.m_36222_(BotaniaStats.CORPOREA_ITEMS_REQUESTED, res.extractedCount());
            CorporeaRequestTrigger.INSTANCE.trigger(player, player.m_9236_(), this.m_58899_(), res.extractedCount());
        }
    }

    public static void onChatMessage(ServerPlayer player, String message) {
        if (player.m_5833_()) {
            return;
        }
        List<CorporeaIndexBlockEntity> nearbyIndexes = CorporeaIndexBlockEntity.getNearbyValidIndexes((Player)player);
        if (!nearbyIndexes.isEmpty()) {
            String msg = message.toLowerCase(Locale.ROOT).trim();
            for (CorporeaIndexBlockEntity index : nearbyIndexes) {
                ItemStack stack;
                String name = "";
                int count = 0;
                for (Pattern pattern : patterns.keySet()) {
                    Matcher matcher = pattern.matcher(msg);
                    if (!matcher.matches()) continue;
                    IRegexStacker stacker = patterns.get(pattern);
                    count = Math.min(65536, stacker.getCount(matcher));
                    name = stacker.getName(matcher).toLowerCase(Locale.ROOT).trim();
                }
                if (name.equals("this") && !(stack = player.m_21205_()).m_41619_()) {
                    name = stack.m_41786_().getString().toLowerCase(Locale.ROOT).trim();
                }
                index.performPlayerRequest(player, CorporeaHelper.instance().createMatcher(name), count);
            }
        }
    }

    static {
        CorporeaIndexBlockEntity.addPattern("(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 1;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        CorporeaIndexBlockEntity.addPattern("a??n?? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 1;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(\\d+)x?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return CorporeaIndexBlockEntity.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(?:a )?stack(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(\\d+)x?? stacks?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64 * CorporeaIndexBlockEntity.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(?:a )?stack (?:(?:and)|(?:\\+)) (\\d+)(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64 + CorporeaIndexBlockEntity.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(\\d+)x?? stacks? (?:(?:and)|(?:\\+)) (\\d+)x?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64 * CorporeaIndexBlockEntity.i(m, 1) + CorporeaIndexBlockEntity.i(m, 2);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(3);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(?:a )?half (?:of )?(?:a )?stack(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 32;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(?:a )?quarter (?:of )?(?:a )?stack(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 16;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(?:a )?dozen(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 12;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(\\d+)x?? dozens?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 12 * CorporeaIndexBlockEntity.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(?:all|every) (?:(?:of|the) )?(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 65536;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(?:the )?answer to life,? the universe and everything (?:of )?(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 42;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(?:a )?nice (?:of )?(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 69;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(\\d+)x?? nices?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 69 * CorporeaIndexBlockEntity.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(?:count|show|display|tell) (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 0;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
    }

    public static interface IRegexStacker {
        public int getCount(Matcher var1);

        public String getName(Matcher var1);
    }

    public static class ClientHandler {
        public static boolean onChat(Player player, String message) {
            if (!CorporeaIndexBlockEntity.getNearbyValidIndexes(player).isEmpty()) {
                ClientXplatAbstractions.INSTANCE.sendToServer(new IndexStringRequestPacket(message));
                return true;
            }
            return false;
        }
    }
}

