/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli.processor;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import vazkii.botania.api.recipe.ElvenTradeRecipe;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ElvenTradeProcessor
implements IComponentProcessor {
    private List<ElvenTradeRecipe> recipes;
    private int longestIngredientSize;
    private int mostInputs;
    private int mostOutputs;

    public void setup(IVariableProvider variables) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IVariable s : variables.get("recipes").asListOrSingleton()) {
            ElvenTradeRecipe recipe = PatchouliUtils.getRecipe(BotaniaRecipeTypes.ELVEN_TRADE_TYPE, new ResourceLocation(s.asString()));
            if (recipe == null) continue;
            builder.add((Object)recipe);
        }
        this.recipes = builder.build();
        for (ElvenTradeRecipe recipe : this.recipes) {
            NonNullList<Ingredient> inputs = recipe.m_7527_();
            for (Ingredient ingredient : inputs) {
                int length = ingredient.m_43908_().length;
                if (length <= this.longestIngredientSize) continue;
                this.longestIngredientSize = length;
            }
            if (inputs.size() > this.mostInputs) {
                this.mostInputs = inputs.size();
            }
            if (recipe.getOutputs().size() <= this.mostOutputs) continue;
            this.mostOutputs = recipe.getOutputs().size();
        }
    }

    public IVariable process(String key) {
        int index;
        if (this.recipes.isEmpty()) {
            return null;
        }
        if (key.equals("heading")) {
            return IVariable.from((Object)this.recipes.get(0).getOutputs().get(0).m_41786_());
        }
        if (key.startsWith("input")) {
            int index2 = Integer.parseInt(key.substring(5)) - 1;
            if (index2 < this.mostInputs) {
                return this.interweaveIngredients(index2);
            }
            return null;
        }
        if (key.startsWith("output") && (index = Integer.parseInt(key.substring(6)) - 1) < this.mostOutputs) {
            return IVariable.wrapList((Iterable)this.recipes.stream().map(ElvenTradeRecipe::getOutputs).map(l -> index < l.size() ? (ItemStack)l.get(index) : ItemStack.f_41583_).map(IVariable::from).collect(Collectors.toList()));
        }
        return null;
    }

    private IVariable interweaveIngredients(int inputIndex) {
        List<Ingredient> recipes = this.recipes.stream().map(ElvenTradeRecipe::m_7527_).map(ingredients -> {
            if (inputIndex < ingredients.size()) {
                return (Ingredient)ingredients.get(inputIndex);
            }
            return Ingredient.f_43901_;
        }).collect(Collectors.toList());
        return PatchouliUtils.interweaveIngredients(recipes, this.longestIngredientSize);
    }
}

