/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.helper;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalDouble;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.CoreShaders;
import vazkii.botania.client.core.helper.DelegatedVertexConsumer;
import vazkii.botania.client.render.block_entity.PylonBlockEntityRenderer;
import vazkii.botania.common.item.equipment.bauble.FlugelTiaraItem;
import vazkii.botania.mixin.client.ItemRendererAccessor;
import vazkii.botania.mixin.client.RenderTypeAccessor;

public final class RenderHelper
extends RenderType {
    private static final RenderType STAR;
    public static final RenderType RECTANGLE;
    public static final RenderType CIRCLE;
    public static final RenderType RED_STRING;
    public static final RenderType LINE_1_NO_DEPTH;
    public static final RenderType LINE_4_NO_DEPTH;
    public static final RenderType LINE_5_NO_DEPTH;
    public static final RenderType LINE_8_NO_DEPTH;
    public static final RenderType SPARK;
    public static final RenderType LIGHT_RELAY;
    public static final RenderType ICON_OVERLAY;
    public static final RenderType BABYLON_ICON;
    public static final RenderType MANA_POOL_WATER;
    public static final RenderType TERRA_PLATE;
    public static final RenderType ENCHANTER;
    public static final RenderType HALO;
    public static final RenderType MANA_PYLON_GLOW;
    public static final RenderType NATURA_PYLON_GLOW;
    public static final RenderType GAIA_PYLON_GLOW;
    public static final RenderType MANA_PYLON_GLOW_DIRECT;
    public static final RenderType NATURA_PYLON_GLOW_DIRECT;
    public static final RenderType GAIA_PYLON_GLOW_DIRECT;
    public static final RenderType ASTROLABE_PREVIEW;
    public static final RenderType STARFIELD;
    public static final RenderType LIGHTNING;
    public static final RenderType TRANSLUCENT;
    private static final int ITEM_AND_PADDING_WIDTH = 20;
    private static final Function<ResourceLocation, RenderType> DOPPLEGANGER;

    private static RenderType makeLayer(String name, VertexFormat format, VertexFormat.Mode mode, int bufSize, boolean hasCrumbling, boolean sortOnUpload, RenderType.CompositeState glState) {
        return RenderTypeAccessor.create(name, format, mode, bufSize, hasCrumbling, sortOnUpload, glState);
    }

    private static RenderType makeLayer(String name, VertexFormat format, VertexFormat.Mode mode, int bufSize, RenderType.CompositeState glState) {
        return RenderHelper.makeLayer(name, format, mode, bufSize, false, false, glState);
    }

    private RenderHelper(String string, VertexFormat vertexFormat, VertexFormat.Mode mode, int i, boolean bl, boolean bl2, Runnable runnable, Runnable runnable2) {
        super(string, vertexFormat, mode, i, bl, bl2, runnable, runnable2);
        throw new UnsupportedOperationException("Should not be instantiated");
    }

    private static RenderType getPylonGlowDirect(String name, ResourceLocation texture) {
        return RenderHelper.getPylonGlow(name, texture, true);
    }

    private static RenderType getPylonGlow(String name, ResourceLocation texture) {
        return RenderHelper.getPylonGlow(name, texture, false);
    }

    private static RenderType getPylonGlow(String name, ResourceLocation texture, boolean direct) {
        RenderType.CompositeState.CompositeStateBuilder glState = RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(CoreShaders::pylon)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(f_110139_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_);
        if (!direct) {
            glState = glState.m_110675_(RenderStateShard.f_110129_);
        }
        return RenderHelper.makeLayer("botania:" + name, DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 128, glState.m_110691_(false));
    }

    private static RenderType.CompositeState lineState(double width, boolean direct, boolean noDepth) {
        RenderType.CompositeState.CompositeStateBuilder builder = RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(width))).m_110669_(f_110119_).m_110685_(f_110139_).m_110687_(noDepth ? f_110115_ : f_110114_).m_110661_(f_110110_);
        if (!direct) {
            builder = builder.m_110675_(f_110129_);
        }
        if (noDepth) {
            builder = builder.m_110663_(f_110111_);
        }
        return builder.m_110691_(false);
    }

    public static RenderType getHaloLayer(ResourceLocation texture) {
        RenderType.CompositeState glState = RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173101_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, true, false)).m_110661_(new RenderStateShard.CullStateShard(false)).m_110685_(f_110139_).m_110691_(false);
        return RenderHelper.makeLayer("botania:crafting_halo", DefaultVertexFormat.f_85818_, VertexFormat.Mode.QUADS, 64, false, true, glState);
    }

    public static RenderType getDopplegangerLayer(ResourceLocation texture) {
        return DOPPLEGANGER.apply(texture);
    }

    public static void drawTexturedModalRect(PoseStack ms, int x, int y, int u, int v, int width, int height) {
        GuiComponent.m_93133_((PoseStack)ms, (int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (int)256, (int)256);
    }

    public static void renderStar(PoseStack ms, MultiBufferSource buffers, int color, float xScale, float yScale, float zScale, long seed) {
        VertexConsumer buffer = buffers.m_6299_(STAR);
        float semiPeriodTicks = 200.0f;
        float ticks = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
        float f1 = Mth.m_14154_((float)Mth.m_14031_((float)((float)Math.PI / semiPeriodTicks * ticks))) * 0.9f + 0.1f;
        float f2 = f1 > 0.0f ? (f1 - 0.7f) / 0.2f : 0.0f;
        Random random = new Random(seed);
        ms.m_85836_();
        ms.m_85841_(xScale, yScale, zScale);
        int i = 0;
        while ((float)i < (f1 + f1 * f1) / 2.0f * 90.0f + 30.0f) {
            ms.m_85845_(Vector3f.f_122223_.m_122240_(random.nextFloat() * 360.0f));
            ms.m_85845_(Vector3f.f_122225_.m_122240_(random.nextFloat() * 360.0f));
            ms.m_85845_(Vector3f.f_122227_.m_122240_(random.nextFloat() * 360.0f));
            ms.m_85845_(Vector3f.f_122223_.m_122240_(random.nextFloat() * 360.0f));
            ms.m_85845_(Vector3f.f_122225_.m_122240_(random.nextFloat() * 360.0f));
            ms.m_85845_(Vector3f.f_122227_.m_122240_(random.nextFloat() * 360.0f + f1 * 90.0f));
            float f3 = random.nextFloat() * 20.0f + 5.0f + f2 * 10.0f;
            float f4 = random.nextFloat() * 2.0f + 1.0f + f2 * 2.0f;
            float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
            float g = (float)((color & 0xFF00) >> 8) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            Matrix4f mat = ms.m_85850_().m_85861_();
            Runnable center = () -> buffer.m_85982_(mat, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, f1).m_5752_();
            Runnable[] vertices = new Runnable[]{() -> buffer.m_85982_(mat, -0.866f * f4, f3, -0.5f * f4).m_6122_(0, 0, 0, 0).m_5752_(), () -> buffer.m_85982_(mat, 0.866f * f4, f3, -0.5f * f4).m_6122_(0, 0, 0, 0).m_5752_(), () -> buffer.m_85982_(mat, 0.0f, f3, 1.0f * f4).m_6122_(0, 0, 0, 0).m_5752_(), () -> buffer.m_85982_(mat, -0.866f * f4, f3, -0.5f * f4).m_6122_(0, 0, 0, 0).m_5752_()};
            RenderHelper.triangleFan(center, vertices);
            ++i;
        }
        ms.m_85849_();
    }

    public static void triangleFan(Runnable center, Runnable ... vertices) {
        RenderHelper.triangleFan(center, Arrays.asList(vertices));
    }

    public static void triangleFan(Runnable center, List<Runnable> vertices) {
        for (int i = 0; i < vertices.size() - 1; ++i) {
            center.run();
            vertices.get(i).run();
            vertices.get(i + 1).run();
        }
    }

    public static void renderProgressPie(PoseStack ms, int x, int y, float progress, ItemStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91291_().m_115203_(stack, x, y);
        RenderSystem.m_69421_((int)256, (boolean)true);
        GL11.glEnable((int)2960);
        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69925_((int)512, (int)1, (int)255);
        RenderSystem.m_69931_((int)7681, (int)7680, (int)7680);
        RenderSystem.m_69929_((int)255);
        mc.m_91291_().m_115203_(stack, x, y);
        int r = 10;
        int centerX = x + 8;
        int centerY = y + 8;
        int degs = (int)(360.0f * progress);
        float a = 0.5f + 0.2f * ((float)Math.cos((double)((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) / 10.0) * 0.5f + 0.5f);
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69405_((int)770, (int)771);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69929_((int)0);
        RenderSystem.m_69925_((int)514, (int)1, (int)255);
        Matrix4f mat = ms.m_85850_().m_85861_();
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        buf.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        buf.m_85982_(mat, (float)centerX, (float)centerY, 0.0f).m_85950_(0.0f, 0.5f, 0.5f, a).m_5752_();
        for (int i = degs; i >= 0; --i) {
            float rad = (float)(i - 90) / 180.0f * (float)Math.PI;
            buf.m_85982_(mat, (float)centerX + Mth.m_14089_((float)rad) * (float)r, (float)centerY + Mth.m_14031_((float)rad) * (float)r, 0.0f).m_85950_(0.0f, 1.0f, 0.5f, a).m_5752_();
        }
        buf.m_85982_(mat, (float)centerX, (float)centerY, 0.0f).m_85950_(0.0f, 1.0f, 0.5f, a).m_5752_();
        Tesselator.m_85913_().m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
        GL11.glDisable((int)2960);
    }

    public static void renderItemCustomColor(LivingEntity entity, ItemStack stack, int color, PoseStack ms, MultiBufferSource buffers, int light, int overlay, @Nullable BakedModel model) {
        ms.m_85836_();
        if (model == null) {
            model = Minecraft.m_91087_().m_91291_().m_174264_(stack, entity.m_9236_(), entity, entity.m_19879_());
        }
        model.m_7442_().m_111808_(ItemTransforms.TransformType.NONE).m_111763_(false, ms);
        ms.m_85837_(-0.5, -0.5, -0.5);
        if (model.m_7521_() || stack.m_150930_(Items.f_42713_)) {
            throw new IllegalArgumentException("Custom renderer items not supported");
        }
        RenderType rendertype = ItemBlockRenderTypes.m_109279_((ItemStack)stack, (boolean)true);
        VertexConsumer ivertexbuilder = ItemRenderer.m_115222_((MultiBufferSource)buffers, (RenderType)rendertype, (boolean)true, (boolean)stack.m_41790_());
        RenderHelper.renderBakedItemModel(model, stack, color, light, overlay, ms, ivertexbuilder);
        ms.m_85849_();
    }

    public static void renderItemCustomColor(LivingEntity entity, ItemStack stack, int color, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        RenderHelper.renderItemCustomColor(entity, stack, color, ms, buffers, light, overlay, null);
    }

    private static void renderBakedItemModel(BakedModel model, ItemStack stack, int color, int light, int overlay, PoseStack ms, VertexConsumer buffer) {
        RandomSource random = RandomSource.m_216327_();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.m_188584_(42L);
            RenderHelper.renderBakedItemQuads(ms, buffer, color, model.m_213637_(null, direction, random), stack, light, overlay);
        }
        random.m_188584_(42L);
        RenderHelper.renderBakedItemQuads(ms, buffer, color, model.m_213637_(null, null, random), stack, light, overlay);
    }

    private static void renderBakedItemQuads(PoseStack ms, VertexConsumer buffer, int color, List<BakedQuad> quads, ItemStack stack, int light, int overlay) {
        final float a = (float)(color >> 24 & 0xFF) / 255.0f;
        final float r = (float)(color >> 16 & 0xFF) / 255.0f;
        final float g = (float)(color >> 8 & 0xFF) / 255.0f;
        final float b = (float)(color & 0xFF) / 255.0f;
        buffer = new DelegatedVertexConsumer(buffer){

            public VertexConsumer m_85950_(float red, float green, float blue, float alpha) {
                return super.m_85950_(r, g, b, a);
            }
        };
        ((ItemRendererAccessor)Minecraft.m_91087_().m_91291_()).callRenderQuadList(ms, buffer, quads, stack, light, overlay);
    }

    public static void renderIconFullBright(PoseStack ms, VertexConsumer buffer, float startX, float startY, float endX, float endY, int uvStartX, int uvStartY, int uvEndX, int uvEndY, TextureAtlasSprite icon, int color, float alpha, int light) {
        Matrix4f mat = ms.m_85850_().m_85861_();
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        buffer.m_85982_(mat, startX, endY, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(icon.m_118367_((double)uvStartX), icon.m_118393_((double)uvEndY)).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, endX, endY, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(icon.m_118367_((double)uvEndX), icon.m_118393_((double)uvEndY)).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, endX, startY, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(icon.m_118367_((double)uvEndX), icon.m_118393_((double)uvStartY)).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, startX, startY, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(icon.m_118367_((double)uvStartX), icon.m_118393_((double)uvStartY)).m_85969_(light).m_5752_();
    }

    public static void renderIconCropped(PoseStack ms, VertexConsumer buffer, int uvStartX, int uvStartY, int uvEndX, int uvEndY, TextureAtlasSprite icon, int color, float alpha, int light) {
        RenderHelper.renderIconFullBright(ms, buffer, (float)uvStartX / 16.0f, (float)uvStartY / 16.0f, (float)uvEndX / 16.0f, (float)uvEndY / 16.0f, uvStartX, uvStartY, uvEndX, uvEndY, icon, color, alpha, light);
    }

    public static void renderIconFullBright(PoseStack ms, VertexConsumer buffer, TextureAtlasSprite icon, int color, float alpha, int light) {
        RenderHelper.renderIconCropped(ms, buffer, 0, 0, 16, 16, icon, color, alpha, light);
    }

    public static void renderIconFullBright(PoseStack ms, VertexConsumer buffer, TextureAtlasSprite icon, int color, float alpha) {
        int fullbright = 0xF000F0;
        RenderHelper.renderIconFullBright(ms, buffer, icon, color, alpha, fullbright);
    }

    public static void renderIconFullBright(PoseStack ms, VertexConsumer buffer, TextureAtlasSprite icon, float alpha) {
        RenderHelper.renderIconFullBright(ms, buffer, icon, 0xFFFFFF, alpha);
    }

    public static void renderGuiItemAlpha(ItemStack stack, int x, int y, int alpha, ItemRenderer renderer) {
        RenderHelper.renderGuiItemAlpha(stack, x, y, alpha, renderer.m_174264_(stack, null, null, 0), renderer);
    }

    public static void renderGuiItemAlpha(ItemStack stack, int x, int y, int alpha, BakedModel model, ItemRenderer renderer) {
        boolean flatLight;
        Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_85837_((double)x, (double)y, (double)(100.0f + renderer.f_115093_));
        modelViewStack.m_85837_(8.0, 8.0, 0.0);
        modelViewStack.m_85841_(1.0f, -1.0f, 1.0f);
        modelViewStack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.m_157182_();
        boolean bl = flatLight = !model.m_7547_();
        if (flatLight) {
            Lighting.m_84930_();
        }
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        renderer.m_115143_(stack, ItemTransforms.TransformType.GUI, false, new PoseStack(), RenderHelper.wrapBuffer((MultiBufferSource)buffer, alpha, alpha < 255), 0xF000F0, OverlayTexture.f_118083_, model);
        buffer.m_109911_();
        RenderSystem.m_69482_();
        if (flatLight) {
            Lighting.m_84931_();
        }
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
    }

    private static MultiBufferSource wrapBuffer(MultiBufferSource buffer, int alpha, boolean forceTranslucent) {
        return renderType -> new GhostVertexConsumer(buffer.m_6299_(forceTranslucent ? TRANSLUCENT : renderType), alpha);
    }

    public static void renderHUDBox(PoseStack ps, int startX, int startY, int endX, int endY) {
        GuiComponent.m_93172_((PoseStack)ps, (int)startX, (int)startY, (int)endX, (int)endY, (int)0x44000000);
        GuiComponent.m_93172_((PoseStack)ps, (int)(startX - 2), (int)(startY - 2), (int)(endX + 2), (int)(endY + 2), (int)0x44000000);
    }

    public static void renderItemWithName(PoseStack ps, Minecraft mc, ItemStack itemStack, int startX, int startY, int color) {
        if (!itemStack.m_41619_()) {
            mc.f_91062_.m_92763_(ps, itemStack.m_41786_(), (float)(startX + 20), (float)(startY + 4), color);
            mc.m_91291_().m_115203_(itemStack, startX, startY);
        }
    }

    public static void renderItemWithNameCentered(PoseStack ps, Minecraft mc, ItemStack itemStack, int startY, int color) {
        int centerX = mc.m_91268_().m_85445_() / 2;
        int startX = centerX - (20 + mc.f_91062_.m_92852_((FormattedText)itemStack.m_41786_())) / 2;
        RenderHelper.renderItemWithName(ps, mc, itemStack, startX, startY, color);
    }

    public static int itemWithNameWidth(Minecraft mc, ItemStack itemStack) {
        return 20 + mc.f_91062_.m_92852_((FormattedText)itemStack.m_41786_());
    }

    static {
        MANA_PYLON_GLOW = RenderHelper.getPylonGlow("mana_pylon_glow", PylonBlockEntityRenderer.MANA_TEXTURE);
        NATURA_PYLON_GLOW = RenderHelper.getPylonGlow("natura_pylon_glow", PylonBlockEntityRenderer.NATURA_TEXTURE);
        GAIA_PYLON_GLOW = RenderHelper.getPylonGlow("gaia_pylon_glow", PylonBlockEntityRenderer.GAIA_TEXTURE);
        MANA_PYLON_GLOW_DIRECT = RenderHelper.getPylonGlowDirect("mana_pylon_glow_direct", PylonBlockEntityRenderer.MANA_TEXTURE);
        NATURA_PYLON_GLOW_DIRECT = RenderHelper.getPylonGlowDirect("natura_pylon_glow_direct", PylonBlockEntityRenderer.NATURA_TEXTURE);
        GAIA_PYLON_GLOW_DIRECT = RenderHelper.getPylonGlowDirect("gaia_pylon_glow_direct", PylonBlockEntityRenderer.GAIA_TEXTURE);
        ASTROLABE_PREVIEW = new AstrolabeLayer();
        RenderType.CompositeState glState = RenderType.CompositeState.m_110628_().m_173292_(f_173104_).m_110687_(f_110115_).m_110685_(RenderStateShard.f_110136_).m_110691_(false);
        STAR = RenderHelper.makeLayer("botania:star", DefaultVertexFormat.f_85815_, VertexFormat.Mode.TRIANGLES, 256, false, false, glState);
        glState = RenderType.CompositeState.m_110628_().m_173292_(f_173104_).m_110685_(f_110139_).m_110675_(f_110129_).m_110661_(f_110110_).m_110691_(false);
        RECTANGLE = RenderHelper.makeLayer("botania:rectangle_highlight", DefaultVertexFormat.f_85815_, VertexFormat.Mode.QUADS, 256, false, true, glState);
        CIRCLE = RenderHelper.makeLayer("botania:circle_highlight", DefaultVertexFormat.f_85815_, VertexFormat.Mode.TRIANGLES, 256, false, false, glState);
        RED_STRING = RenderHelper.makeLayer("botania:red_string", DefaultVertexFormat.f_166851_, VertexFormat.Mode.LINES, 128, RenderHelper.lineState(1.0, false, false));
        LINE_1_NO_DEPTH = RenderHelper.makeLayer("botania:line_1_no_depth", DefaultVertexFormat.f_166851_, VertexFormat.Mode.LINES, 128, RenderHelper.lineState(1.0, true, true));
        LINE_4_NO_DEPTH = RenderHelper.makeLayer("botania:line_4_no_depth", DefaultVertexFormat.f_166851_, VertexFormat.Mode.LINES, 128, RenderHelper.lineState(4.0, true, true));
        LINE_5_NO_DEPTH = RenderHelper.makeLayer("botania:line_5_no_depth", DefaultVertexFormat.f_166851_, VertexFormat.Mode.LINES, 64, RenderHelper.lineState(5.0, true, true));
        LINE_8_NO_DEPTH = RenderHelper.makeLayer("botania:line_8_no_depth", DefaultVertexFormat.f_166851_, VertexFormat.Mode.LINES, 64, RenderHelper.lineState(8.0, true, true));
        glState = RenderType.CompositeState.m_110628_().m_173292_(f_173103_).m_173290_((RenderStateShard.EmptyTextureStateShard)RenderStateShard.f_110145_).m_110685_(f_110139_).m_110675_(f_110129_).m_110671_(f_110152_).m_110691_(true);
        SPARK = RenderHelper.makeLayer("botania:spark", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, 256, glState);
        glState = RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(CoreShaders::halo)).m_173290_((RenderStateShard.EmptyTextureStateShard)RenderStateShard.f_110145_).m_110685_(f_110139_).m_110675_(f_110129_).m_110691_(true);
        LIGHT_RELAY = RenderHelper.makeLayer("botania:light_relay", DefaultVertexFormat.f_85818_, VertexFormat.Mode.QUADS, 64, glState);
        glState = RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)f_110145_).m_173292_(f_173103_).m_110685_(f_110139_).m_110675_(f_110129_).m_110671_(f_110152_).m_110691_(true);
        ICON_OVERLAY = RenderHelper.makeLayer("botania:icon_overlay", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, 128, glState);
        glState = RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)f_110145_).m_173292_(new RenderStateShard.ShaderStateShard(CoreShaders::manaPool)).m_110685_(f_110139_).m_110675_(f_110129_).m_110671_(f_110152_).m_110691_(false);
        MANA_POOL_WATER = RenderHelper.makeLayer("botania:mana_pool_water", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, 128, glState);
        glState = RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)f_110145_).m_173292_(new RenderStateShard.ShaderStateShard(CoreShaders::terraPlate)).m_110685_(f_110139_).m_110675_(f_110129_).m_110671_(f_110152_).m_110691_(false);
        TERRA_PLATE = RenderHelper.makeLayer("botania:terra_plate_rune", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, 128, glState);
        glState = RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)f_110145_).m_173292_(new RenderStateShard.ShaderStateShard(CoreShaders::enchanter)).m_110685_(f_110139_).m_110675_(f_110129_).m_110671_(f_110152_).m_110691_(false);
        ENCHANTER = RenderHelper.makeLayer("botania:enchanter_rune", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, 128, glState);
        RenderStateShard.TextureStateShard babylonTexture = new RenderStateShard.TextureStateShard(new ResourceLocation("botania:textures/misc/babylon.png"), false, true);
        glState = RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)babylonTexture).m_173292_(new RenderStateShard.ShaderStateShard(CoreShaders::halo)).m_110685_(f_110139_).m_110675_(f_110129_).m_110661_(f_110110_).m_110691_(true);
        BABYLON_ICON = RenderHelper.makeLayer("botania:babylon", DefaultVertexFormat.f_85818_, VertexFormat.Mode.QUADS, 64, glState);
        RenderStateShard.TextureStateShard haloTexture = new RenderStateShard.TextureStateShard(FlugelTiaraItem.textureHalo, false, true);
        glState = RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)haloTexture).m_173292_(new RenderStateShard.ShaderStateShard(CoreShaders::halo)).m_110685_(f_110139_).m_110661_(f_110110_).m_110691_(true);
        HALO = RenderHelper.makeLayer("botania:halo", DefaultVertexFormat.f_85818_, VertexFormat.Mode.QUADS, 64, glState);
        glState = RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(CoreShaders::starfield)).m_173290_((RenderStateShard.EmptyTextureStateShard)RenderStateShard.MultiTextureStateShard.m_173127_().m_173132_(TheEndPortalRenderer.f_112626_, false, false).m_173132_(TheEndPortalRenderer.f_112627_, false, false).m_173131_()).m_110691_(false);
        STARFIELD = RenderHelper.makeLayer("botania:starfield", DefaultVertexFormat.f_85814_, VertexFormat.Mode.QUADS, 256, false, false, glState);
        glState = RenderType.CompositeState.m_110628_().m_173292_(f_173104_).m_110685_(f_110136_).m_110691_(false);
        LIGHTNING = RenderHelper.makeLayer("botania:lightning", DefaultVertexFormat.f_85815_, VertexFormat.Mode.QUADS, 256, false, true, glState);
        TRANSLUCENT = RenderType.m_110470_((ResourceLocation)TextureAtlas.f_118259_);
        DOPPLEGANGER = Util.m_143827_(texture -> {
            RenderType.CompositeState glState = RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(CoreShaders::doppleganger)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(f_110139_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(true);
            return RenderHelper.makeLayer("botania:doppleganger", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, true, true, glState);
        });
    }

    public record GhostVertexConsumer(VertexConsumer wrapped, int alpha) implements VertexConsumer
    {
        public VertexConsumer m_5483_(double x, double y, double z) {
            return this.wrapped.m_5483_(x, y, z);
        }

        public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
            return this.wrapped.m_6122_(red, green, blue, alpha * this.alpha / 255);
        }

        public VertexConsumer m_7421_(float u, float v) {
            return this.wrapped.m_7421_(u, v);
        }

        public VertexConsumer m_7122_(int u, int v) {
            return this.wrapped.m_7122_(u, v);
        }

        public VertexConsumer m_7120_(int u, int v) {
            return this.wrapped.m_7120_(u, v);
        }

        public VertexConsumer m_5601_(float x, float y, float z) {
            return this.wrapped.m_5601_(x, y, z);
        }

        public void m_5752_() {
            this.wrapped.m_5752_();
        }

        public void m_7404_(int r, int g, int b, int a) {
            this.wrapped.m_7404_(r, g, b, a);
        }

        public void m_141991_() {
            this.wrapped.m_141991_();
        }
    }

    private static class AstrolabeLayer
    extends RenderType {
        public AstrolabeLayer() {
            super("botania:astrolabe", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, true, true, () -> {
                Sheets.m_110792_().m_110185_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            }, () -> Sheets.m_110792_().m_110188_());
        }
    }
}

