/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.core.FluidHandlerBlock;

public class FluidStorageBlockWrapper
implements IIngredientComponentStorage<FluidStack, Integer> {
    private final ServerLevel world;
    private final BlockPos pos;
    private final Direction side;
    private final boolean blockUpdate;
    private final IIngredientComponentStorage<FluidStack, Integer> targetStorage;

    public FluidStorageBlockWrapper(ServerLevel world, BlockPos pos, Direction side, boolean blockUpdate) {
        this.world = world;
        this.pos = pos;
        this.side = side;
        this.blockUpdate = blockUpdate;
        FluidHandlerBlock fluidHandler = new FluidHandlerBlock(world.m_8055_(pos), (Level)world, pos);
        this.targetStorage = this.getComponent().getStorageWrapperHandler(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).wrapComponentStorage((Object)fluidHandler);
    }

    protected void sendBlockUpdate() {
        this.world.m_46586_(this.pos, Blocks.f_50016_, this.pos);
    }

    protected void postInsert(FluidStack moved) {
        SoundEvent soundevent;
        if (moved != null && GeneralConfig.worldInteractionEvents && (soundevent = moved.getFluid().getFluidType().getSound(moved, SoundActions.BUCKET_EMPTY)) != null) {
            this.world.m_5594_(null, this.pos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (this.blockUpdate) {
            this.sendBlockUpdate();
        }
    }

    protected void postExtract(FluidStack moved) {
        SoundEvent soundevent;
        if (moved != null && GeneralConfig.worldInteractionEvents && (soundevent = moved.getFluid().getFluidType().getSound(moved, SoundActions.BUCKET_FILL)) != null) {
            this.world.m_5594_(null, this.pos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public IngredientComponent<FluidStack, Integer> getComponent() {
        return IngredientComponent.FLUIDSTACK;
    }

    public Iterator<FluidStack> iterator() {
        return this.targetStorage.iterator();
    }

    public Iterator<FluidStack> iterator(@Nonnull FluidStack prototype, Integer matchCondition) {
        return this.targetStorage.iterator((Object)prototype, (Object)matchCondition);
    }

    public long getMaxQuantity() {
        return 1000L;
    }

    public FluidStack insert(@Nonnull FluidStack stack, boolean simulate) {
        if (this.world.m_6042_().f_63857_() && stack.getFluid().getFluidType().isVaporizedOnPlacement((Level)this.world, this.pos, stack)) {
            return FluidStack.EMPTY;
        }
        FluidStack remaining = (FluidStack)this.targetStorage.insert((Object)stack, simulate);
        if (!simulate && stack.getAmount() != remaining.getAmount()) {
            this.postInsert(stack);
        }
        return remaining;
    }

    public FluidStack extract(@Nonnull FluidStack prototype, Integer matchCondition, boolean simulate) {
        FluidStack extracted = (FluidStack)this.targetStorage.extract((Object)prototype, (Object)matchCondition, simulate);
        if (!simulate) {
            this.postExtract(extracted);
        }
        return extracted;
    }

    public FluidStack extract(long maxQuantity, boolean simulate) {
        FluidStack extracted = (FluidStack)this.targetStorage.extract(maxQuantity, simulate);
        if (!simulate) {
            this.postExtract(extracted);
        }
        return extracted;
    }
}

