/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.module;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.base.handler.UndergroundBiomeHandler;
import vazkii.quark.base.handler.VariantHandler;
import vazkii.quark.base.handler.advancement.QuarkAdvancementHandler;
import vazkii.quark.base.handler.advancement.mod.AdventuringTimeModifier;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.hint.Hint;
import vazkii.quark.content.mobs.module.StonelingsModule;
import vazkii.quark.content.world.block.GlowLichenGrowthBlock;
import vazkii.quark.content.world.block.GlowShroomBlock;
import vazkii.quark.content.world.block.GlowShroomRingBlock;
import vazkii.quark.content.world.block.HugeGlowShroomBlock;
import vazkii.quark.content.world.feature.GlowExtrasFeature;
import vazkii.quark.content.world.feature.GlowShroomsFeature;

@LoadModule(category=ModuleCategory.WORLD)
public class GlimmeringWealdModule
extends QuarkModule {
    private static final Climate.Parameter FULL_RANGE = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
    public static final ResourceLocation BIOME_NAME = new ResourceLocation("quark", "glimmering_weald");
    public static final ResourceKey<Biome> BIOME_KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)BIOME_NAME);
    public static final Holder<PlacedFeature> ORE_LAPIS_EXTRA = PlacementUtils.m_206509_((String)"ore_lapis_glimmering_weald", (Holder)OreFeatures.f_195062_, (List)OrePlacements.m_195343_((int)12, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)0))));
    public static Holder<PlacedFeature> placed_glow_shrooms;
    public static Holder<PlacedFeature> placed_glow_extras;
    @Hint
    public static Block glow_shroom;
    @Hint
    public static Block glow_lichen_growth;
    public static Block glow_shroom_block;
    public static Block glow_shroom_stem;
    public static Block glow_shroom_ring;
    public static TagKey<Item> glowShroomFeedablesTag;
    @Config(name="Min Depth Range", description="Experimental, dont change if you dont know what you are doing. Depth min value from which biome will spawn. Decreasing will make biome appear more often")
    @Config.Min(value=-2.0)
    @Config.Max(value=2.0)
    public static double minDepthRange;
    @Config(name="Max Weirdness Range", description="Experimental, dont change if you dont know what you are doing. Depth max value until which biome will spawn. Increasing will make biome appear more often")
    @Config.Min(value=-2.0)
    @Config.Max(value=2.0)
    public static double maxDepthRange;

    @Override
    public void register() {
        glow_shroom = new GlowShroomBlock(this);
        glow_lichen_growth = new GlowLichenGrowthBlock(this);
        glow_shroom_block = new HugeGlowShroomBlock("glow_shroom_block", this, true);
        glow_shroom_stem = new HugeGlowShroomBlock("glow_shroom_stem", this, false);
        glow_shroom_ring = new GlowShroomRingBlock(this);
        VariantHandler.addFlowerPot(glow_lichen_growth, "glow_lichen_growth", prop -> prop.m_60953_(state -> 8));
        VariantHandler.addFlowerPot(glow_shroom, "glow_shroom", prop -> prop.m_60953_(state -> 10));
        GlimmeringWealdModule.makeFeatures();
    }

    @Override
    public void postRegister() {
        RegistryHelper.register((Object)GlimmeringWealdModule.makeBiome(), (ResourceKey)Registry.f_122885_);
        float wmin = (float)minDepthRange;
        float wmax = (float)maxDepthRange;
        if (wmin >= wmax) {
            Quark.LOG.warn("Incorrect value for Glimmering Weald biome parameters. Using default");
            wmax = 2.0f;
            wmin = 1.55f;
        }
        UndergroundBiomeHandler.addUndergroundBiome(this, Climate.m_186798_((Climate.Parameter)FULL_RANGE, (Climate.Parameter)FULL_RANGE, (Climate.Parameter)FULL_RANGE, (Climate.Parameter)FULL_RANGE, (Climate.Parameter)Climate.Parameter.m_186822_((float)wmin, (float)wmax), (Climate.Parameter)FULL_RANGE, (float)0.0f), BIOME_NAME);
        QuarkAdvancementHandler.addModifier(new AdventuringTimeModifier(this, (Set<ResourceKey<Biome>>)ImmutableSet.of(BIOME_KEY)));
    }

    @Override
    public void setup() {
        glowShroomFeedablesTag = ItemTags.create((ResourceLocation)new ResourceLocation("quark", "glow_shroom_feedables"));
        this.enqueue(() -> {
            ComposterBlock.f_51914_.put((Object)glow_shroom.m_5456_(), 0.65f);
            ComposterBlock.f_51914_.put((Object)glow_shroom_block.m_5456_(), 0.65f);
            ComposterBlock.f_51914_.put((Object)glow_shroom_stem.m_5456_(), 0.65f);
            ComposterBlock.f_51914_.put((Object)glow_shroom_ring.m_5456_(), 0.65f);
            ComposterBlock.f_51914_.put((Object)glow_lichen_growth.m_5456_(), 0.5f);
        });
    }

    private static void makeFeatures() {
        placed_glow_shrooms = GlimmeringWealdModule.place("glow_shrooms", new GlowShroomsFeature(), GlowShroomsFeature.placed());
        placed_glow_extras = GlimmeringWealdModule.place("glow_extras", new GlowExtrasFeature(), GlowExtrasFeature.placed());
    }

    private static Holder<PlacedFeature> place(String featureName, Feature<NoneFeatureConfiguration> feature, List<PlacementModifier> placer) {
        String name = "quark:" + featureName;
        RegistryHelper.register(feature, (String)name, (ResourceKey)Registry.f_122838_);
        Holder configured = FeatureUtils.m_206488_((String)name, feature, (FeatureConfiguration)NoneFeatureConfiguration.f_67737_);
        return PlacementUtils.m_206509_((String)name, (Holder)configured, placer);
    }

    private static Biome makeBiome() {
        MobSpawnSettings.Builder mobs = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)mobs);
        if (ModuleLoader.INSTANCE.isModuleEnabled(StonelingsModule.class)) {
            mobs.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(StonelingsModule.stonelingType, 200, 1, 4));
        }
        mobs.m_48376_(MobCategory.UNDERGROUND_WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_147034_, 20, 4, 6));
        BiomeGenerationSettings.Builder settings = new BiomeGenerationSettings.Builder();
        OverworldBiomes.m_194869_((BiomeGenerationSettings.Builder)settings);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)settings);
        BiomeDefaultFeatures.m_194722_((BiomeGenerationSettings.Builder)settings, (boolean)true);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)settings);
        BiomeDefaultFeatures.m_126714_((BiomeGenerationSettings.Builder)settings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)settings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)settings);
        settings.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, placed_glow_shrooms);
        settings.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, placed_glow_extras);
        settings.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, ORE_LAPIS_EXTRA);
        Music music = Musics.m_11653_((SoundEvent)QuarkSounds.MUSIC_GLIMMERING_WEALD);
        Biome biome = OverworldBiomes.m_236663_((Biome.Precipitation)Biome.Precipitation.RAIN, (float)0.8f, (float)0.4f, (MobSpawnSettings.Builder)mobs, (BiomeGenerationSettings.Builder)settings, (Music)music);
        RegistryHelper.setInternalName((Object)biome, (ResourceLocation)BIOME_NAME);
        return biome;
    }

    static {
        minDepthRange = 1.55f;
        maxDepthRange = 2.0;
    }
}

