/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.module;

import com.google.common.base.Functions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.Tags;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.handler.VariantHandler;
import vazkii.quark.base.handler.WoodSetHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.hint.HintManager;
import vazkii.quark.base.world.WorldGenHandler;
import vazkii.quark.content.world.block.BlossomLeavesBlock;
import vazkii.quark.content.world.block.BlossomSaplingBlock;
import vazkii.quark.content.world.config.BlossomTreeConfig;
import vazkii.quark.content.world.gen.BlossomTreeGenerator;

@LoadModule(category=ModuleCategory.WORLD)
public class BlossomTreesModule
extends QuarkModule {
    @Config
    public BlossomTreeConfig blue = new BlossomTreeConfig(200, (TagKey<Biome>)Tags.Biomes.IS_SNOWY);
    @Config
    public BlossomTreeConfig lavender = new BlossomTreeConfig(100, (TagKey<Biome>)Tags.Biomes.IS_SWAMP);
    @Config
    public BlossomTreeConfig orange = new BlossomTreeConfig(100, (TagKey<Biome>)BiomeTags.f_215816_);
    @Config
    public BlossomTreeConfig pink = new BlossomTreeConfig(100, (TagKey<Biome>)BiomeTags.f_207606_);
    @Config
    public BlossomTreeConfig yellow = new BlossomTreeConfig(200, (TagKey<Biome>)Tags.Biomes.IS_PLAINS);
    @Config
    public BlossomTreeConfig red = new BlossomTreeConfig(30, (TagKey<Biome>)BiomeTags.f_207607_);
    @Config
    public static boolean dropLeafParticles = true;
    public static Map<BlossomSaplingBlock.BlossomTree, BlossomTreeConfig> trees = new HashMap<BlossomSaplingBlock.BlossomTree, BlossomTreeConfig>();
    public static WoodSetHandler.WoodSet woodSet;

    @Override
    public void register() {
        woodSet = WoodSetHandler.addWoodSet(this, "blossom", MaterialColor.f_76364_, MaterialColor.f_76362_, true);
        this.add("blue", MaterialColor.f_76415_, this.blue);
        this.add("lavender", MaterialColor.f_76418_, this.lavender);
        this.add("orange", MaterialColor.f_76373_, this.orange);
        this.add("pink", MaterialColor.f_76418_, this.pink);
        this.add("yellow", MaterialColor.f_76416_, this.yellow);
        this.add("red", MaterialColor.f_76364_, this.red);
    }

    @Override
    public void setup() {
        for (BlossomSaplingBlock.BlossomTree tree : trees.keySet()) {
            WorldGenHandler.addGenerator(this, new BlossomTreeGenerator(trees.get((Object)tree), tree), GenerationStep.Decoration.TOP_LAYER_MODIFICATION, 1);
        }
        this.enqueue(() -> {
            for (BlossomSaplingBlock.BlossomTree tree : trees.keySet()) {
                if (tree.leaf.m_60734_().m_5456_() != null) {
                    ComposterBlock.f_51914_.put((Object)tree.leaf.m_60734_().m_5456_(), 0.3f);
                }
                if (tree.sapling.m_5456_() == null) continue;
                ComposterBlock.f_51914_.put((Object)tree.sapling.m_5456_(), 0.3f);
            }
        });
    }

    @Override
    public void addAdditionalHints(BiConsumer<Item, Component> consumer) {
        for (BlossomSaplingBlock.BlossomTree tree : trees.keySet()) {
            HintManager.hintItem(consumer, (ItemLike)tree.sapling.m_5456_(), new Object[0]);
        }
    }

    private void add(String colorName, MaterialColor color, BlossomTreeConfig config) {
        BlossomLeavesBlock leaves = new BlossomLeavesBlock(colorName, this, color);
        BlossomSaplingBlock.BlossomTree tree = new BlossomSaplingBlock.BlossomTree((Block)leaves);
        BlossomSaplingBlock sapling = new BlossomSaplingBlock(colorName, (QuarkModule)this, tree);
        VariantHandler.addFlowerPot((Block)sapling, RegistryHelper.getInternalName((Object)sapling).m_135815_(), (Function<BlockBehaviour.Properties, BlockBehaviour.Properties>)Functions.identity());
        trees.put(tree, config);
    }
}

