/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.module;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.handler.BrewingHandler;
import vazkii.quark.base.handler.EntityAttributeHandler;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.base.handler.advancement.QuarkAdvancementHandler;
import vazkii.quark.base.handler.advancement.mod.BalancedDietModifier;
import vazkii.quark.base.handler.advancement.mod.FuriousCocktailModifier;
import vazkii.quark.base.handler.advancement.mod.TwoByTwoModifier;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.item.QuarkMobBucketItem;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.CompoundBiomeConfig;
import vazkii.quark.base.module.config.type.EntitySpawnConfig;
import vazkii.quark.base.module.hint.Hint;
import vazkii.quark.base.util.QuarkEffect;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.content.mobs.client.render.entity.CrabRenderer;
import vazkii.quark.content.mobs.entity.Crab;

@LoadModule(category=ModuleCategory.MOBS, hasSubscriptions=true)
public class CrabsModule
extends QuarkModule {
    public static EntityType<Crab> crabType;
    @Config
    public static EntitySpawnConfig spawnConfig;
    public static TagKey<Block> crabSpawnableTag;
    public static MobEffect resilience;
    @Config(flag="crab_brewing")
    public static boolean enableBrewing;
    @Config(description="Whether Resilience should be required for 'How Did We Get Here?' and (if brewing is enabled) 'A Furious Cocktail'.\nKeep this on when brewing is disabled if your pack adds an alternative source for the effect.")
    public static boolean resilienceRequiredForAllEffects;
    @Hint(key="crab_info")
    Item crab_leg;
    @Hint(key="crab_info")
    Item crab_shell;
    @Hint(key="crab_info")
    public static Item crab_bucket;

    @Override
    public void register() {
        this.crab_leg = new QuarkItem("crab_leg", this, new Item.Properties().m_41491_(CreativeModeTab.f_40755_).m_41489_(new FoodProperties.Builder().m_38757_().m_38760_(1).m_38758_(0.3f).m_38767_()));
        QuarkItem cookedCrabLeg = new QuarkItem("cooked_crab_leg", this, new Item.Properties().m_41491_(CreativeModeTab.f_40755_).m_41489_(new FoodProperties.Builder().m_38757_().m_38760_(8).m_38758_(0.8f).m_38767_()));
        this.crab_shell = new QuarkItem("crab_shell", this, new Item.Properties().m_41491_(CreativeModeTab.f_40758_)).setCondition(() -> enableBrewing);
        crab_bucket = new QuarkMobBucketItem(() -> crabType, () -> Fluids.f_76193_, () -> QuarkSounds.BUCKET_EMPTY_CRAB, "crab_bucket", this);
        resilience = new QuarkEffect("resilience", MobEffectCategory.BENEFICIAL, 5970436);
        resilience.m_19472_(Attributes.f_22278_, "2ddf3f0a-f386-47b6-aeb0-6bd32851f215", 0.5, AttributeModifier.Operation.ADDITION);
        BrewingHandler.addPotionMix("crab_brewing", () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.crab_shell}), resilience);
        crabType = EntityType.Builder.m_20704_(Crab::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 0.5f).m_20702_(8).setCustomClientFactory((spawnEntity, world) -> new Crab((EntityType<? extends Crab>)crabType, (Level)world)).m_20712_("crab");
        RegistryHelper.register(crabType, (String)"crab", (ResourceKey)Registry.f_122903_);
        EntitySpawnHandler.registerSpawn(crabType, MobCategory.CREATURE, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Crab::spawnPredicate, spawnConfig);
        EntitySpawnHandler.addEgg(this, crabType, 8993826, 9528648, spawnConfig);
        EntityAttributeHandler.put(crabType, Crab::prepareAttributes);
        QuarkAdvancementHandler.addModifier(new FuriousCocktailModifier(this, () -> enableBrewing, (Set<MobEffect>)ImmutableSet.of((Object)resilience)).setCondition(() -> resilienceRequiredForAllEffects));
        QuarkAdvancementHandler.addModifier(new TwoByTwoModifier(this, (Set<EntityType<?>>)ImmutableSet.of(crabType)));
        QuarkAdvancementHandler.addModifier(new BalancedDietModifier(this, (Set<ItemLike>)ImmutableSet.of((Object)this.crab_leg, (Object)cookedCrabLeg)));
    }

    @Override
    public void setup() {
        crabSpawnableTag = BlockTags.create((ResourceLocation)new ResourceLocation("quark", "crab_spawnable"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        EntityRenderers.m_174036_(crabType, CrabRenderer::new);
    }

    static {
        spawnConfig = new EntitySpawnConfig(5, 1, 3, CompoundBiomeConfig.fromBiomeTags(false, BiomeTags.f_207604_));
        enableBrewing = true;
        resilienceRequiredForAllEffects = true;
    }
}

