/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import vazkii.quark.content.mobs.entity.Wraith;

public class WraithModel
extends EntityModel<Wraith> {
    public final ModelPart main;
    public final ModelPart body;
    public final ModelPart arms;
    private double offset;
    private float alphaMult;

    public WraithModel(ModelPart root) {
        super(RenderType::m_110473_);
        this.main = root.m_171324_("main");
        this.body = this.main.m_171324_("body");
        this.arms = this.main.m_171324_("arms");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition main = root.m_171599_("main", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        main.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(36, 6).m_171488_(-8.5f, 1.0f, -2.0f, 3.0f, 15.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 55).m_171488_(-5.5f, 12.0f, 0.0f, 11.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(47, 3).m_171488_(-8.5f, 11.0f, -2.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.25f)).m_171514_(36, 6).m_171480_().m_171488_(5.5f, 1.0f, -2.0f, 3.0f, 15.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(47, 3).m_171480_().m_171488_(5.5f, 11.0f, -2.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.25f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-17.0f, (float)-1.0f));
        main.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -10.0f, -4.0f, 11.0f, 26.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-18.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(Wraith entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        Random rng = new Random(entity.m_19879_());
        int offset1 = rng.nextInt(10000000);
        int offset2 = rng.nextInt(6000000);
        int offset3 = rng.nextInt(8000000);
        float time = ageInTicks + (float)offset1;
        float time2 = ageInTicks + (float)offset2;
        float time3 = ageInTicks + (float)offset3;
        this.main.f_104203_ = (float)Math.sin(time / 16.0f) * 0.1f - 0.3f;
        this.main.f_104204_ = (float)Math.sin(time2 / 20.0f) * 0.12f;
        this.main.f_104205_ = (float)Math.sin(time3 / 12.0f) * 0.07f;
        this.arms.f_104203_ = (float)Math.sin(time2 / 22.0f) * 0.15f;
        this.offset = Math.sin(time / 16.0f) * 0.1 - 0.25;
        this.alphaMult = 0.8f + (float)Math.sin(time2 / 20.0f) * 0.2f;
    }

    public void m_7695_(PoseStack matrix, @Nonnull VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        matrix.m_85836_();
        matrix.m_85837_(0.0, this.offset, -0.1);
        this.main.m_104306_(matrix, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha *= this.alphaMult);
        matrix.m_85849_();
    }
}

