/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.automation.module;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.hint.Hint;

@LoadModule(category=ModuleCategory.AUTOMATION, hasSubscriptions=true)
public class JukeboxAutomationModule
extends QuarkModule {
    @Hint
    Item jukebox = Items.f_41984_;
    private static final ResourceLocation JUKEBOX_ITEM_HANDLER = new ResourceLocation("quark", "jukebox_item_handler");

    @Override
    public void setup() {
        MusicDiscBehaviour behaviour = new MusicDiscBehaviour();
        this.enqueue(() -> ForgeRegistries.ITEMS.forEach(i -> {
            if (i instanceof RecordItem) {
                DispenserBlock.f_52661_.put(i, behaviour);
            }
        }));
    }

    @SubscribeEvent
    public void attachCaps(AttachCapabilitiesEvent<BlockEntity> event) {
        Object object = event.getObject();
        if (object instanceof JukeboxBlockEntity) {
            JukeboxBlockEntity jukebox = (JukeboxBlockEntity)object;
            event.addCapability(JUKEBOX_ITEM_HANDLER, (ICapabilityProvider)new JukeboxItemHandler(jukebox));
        }
    }

    public static class MusicDiscBehaviour
    extends OptionalDispenseItemBehavior {
        @Nonnull
        protected ItemStack m_7498_(BlockSource source, @Nonnull ItemStack stack) {
            JukeboxBlockEntity jukebox;
            Direction dir = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            BlockPos pos = source.m_7961_().m_121945_(dir);
            ServerLevel world = source.m_7727_();
            BlockState state = world.m_8055_(pos);
            if (state.m_60734_() == Blocks.f_50131_ && (jukebox = (JukeboxBlockEntity)world.m_7702_(pos)) != null) {
                ItemStack currentRecord = jukebox.m_59524_();
                ((JukeboxBlock)state.m_60734_()).m_238345_(null, (LevelAccessor)world, pos, state, stack);
                world.m_5898_(null, 1010, pos, Item.m_41393_((Item)stack.m_41720_()));
                return currentRecord;
            }
            return super.m_7498_(source, stack);
        }
    }

    public record JukeboxItemHandler(JukeboxBlockEntity tile) implements ICapabilityProvider,
    IItemHandler
    {
        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.tile.m_59524_();
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stackAt = this.getStackInSlot(slot);
            if (!stackAt.m_41619_()) {
                ItemStack copy = stackAt.m_41777_();
                if (!simulate) {
                    this.tile.m_58904_().m_46796_(1010, this.tile.m_58899_(), 0);
                    this.tile.m_59517_(ItemStack.f_41583_);
                    BlockState state = (BlockState)this.tile.m_58900_().m_61124_((Property)JukeboxBlock.f_54254_, (Comparable)Boolean.valueOf(false));
                    this.tile.m_58904_().m_7731_(this.tile.m_58899_(), state, 3);
                }
                return copy;
            }
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return false;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
            if (cap == ForgeCapabilities.ITEM_HANDLER) {
                return LazyOptional.of(() -> this).cast();
            }
            return LazyOptional.empty();
        }
    }
}

