/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import vazkii.quark.base.Quark;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.handler.CreativeTabHandler;
import vazkii.quark.base.item.IQuarkItem;
import vazkii.quark.base.module.ModuleFinder;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.ConfigResolver;

public final class ModuleLoader {
    public static final ModuleLoader INSTANCE = new ModuleLoader();
    private Map<Class<? extends QuarkModule>, QuarkModule> foundModules = new HashMap<Class<? extends QuarkModule>, QuarkModule>();
    private final List<Step> stepsHandled = new ArrayList<Step>();
    private ConfigResolver config;
    private Runnable onConfigReloadJEI;
    private boolean clientTicked = false;
    private ParallelDispatchEvent event;

    private ModuleLoader() {
    }

    public void start() {
        this.findModules();
        this.dispatch(Step.CONSTRUCT, QuarkModule::construct);
        this.resolveConfigSpec();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientStart() {
        this.dispatch(Step.CONSTRUCT_CLIENT, QuarkModule::constructClient);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void findModules() {
        ModuleFinder finder = new ModuleFinder();
        finder.findModules();
        this.foundModules = finder.getFoundModules();
    }

    private void resolveConfigSpec() {
        this.config = new ConfigResolver();
        this.config.makeSpec();
    }

    public ModConfig getConfig() {
        return this.config.getConfig();
    }

    public void register() {
        this.dispatch(Step.REGISTER, QuarkModule::register);
        this.dispatch(Step.POST_REGISTER, QuarkModule::postRegister);
        CreativeTabHandler.finalizeTabs();
        this.config.registerConfigBoundElements();
    }

    public void configChanged() {
        if (!this.stepsHandled.contains((Object)Step.POST_REGISTER)) {
            return;
        }
        if (this.onConfigReloadJEI != null) {
            this.onConfigReloadJEI.run();
        }
        this.config.configChanged();
        this.dispatch(Step.CONFIG_CHANGED, QuarkModule::configChanged);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void configChangedClient() {
        if (!this.stepsHandled.contains((Object)Step.POST_REGISTER)) {
            return;
        }
        this.dispatch(Step.CONFIG_CHANGED_CLIENT, QuarkModule::configChangedClient);
    }

    public void setup(ParallelDispatchEvent event) {
        this.event = event;
        Quark.proxy.handleQuarkConfigChange();
        this.dispatch(Step.SETUP, QuarkModule::setup);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(ParallelDispatchEvent event) {
        this.event = event;
        this.dispatch(Step.SETUP_CLIENT, QuarkModule::clientSetup);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerReloadListeners(RegisterClientReloadListenersEvent event) {
        this.dispatch(Step.SETUP_CLIENT, m -> m.registerReloadListeners(arg_0 -> ((RegisterClientReloadListenersEvent)event).registerReloadListener(arg_0)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void modelBake(ModelEvent.BakingCompleted event) {
        this.dispatch(Step.MODEL_BAKE, m -> m.modelBake(event));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void modelLayers(EntityRenderersEvent.AddLayers event) {
        this.dispatch(Step.MODEL_LAYERS, m -> m.modelLayers(event));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void textureStitch(TextureStitchEvent.Pre event) {
        this.dispatch(Step.TEXTURE_STITCH, m -> m.textureStitch(event));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void postTextureStitch(TextureStitchEvent.Post event) {
        this.dispatch(Step.POST_TEXTURE_STITCH, m -> m.postTextureStitch(event));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerKeybinds(RegisterKeyMappingsEvent event) {
        this.dispatch(Step.REGISTER_KEYBINDS, m -> m.registerKeybinds(event));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
        this.dispatch(Step.REGISTER_ADDITIONAL_MODELS, m -> m.registerAdditionalModels(event));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClientTooltipComponentFactories(RegisterClientTooltipComponentFactoriesEvent event) {
        this.dispatch(Step.REGISTER_TOOLTIP_COMPONENT_FACTORIES, m -> m.registerClientTooltipComponentFactories(event));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerItemColors(RegisterColorHandlersEvent.Item event) {
        this.dispatch(Step.REGISTER_ITEM_COLORS, m -> m.registerItemColors(event));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        this.dispatch(Step.REGISTER_BLOCK_COLORS, m -> m.registerBlockColors(event));
    }

    public void loadComplete(ParallelDispatchEvent event) {
        this.event = event;
        this.dispatch(Step.LOAD_COMPLETE, QuarkModule::loadComplete);
    }

    public void addStackInfo(BiConsumer<Item, Component> consumer) {
        this.dispatch(Step.GENERATE_HINTS, m -> {
            if (m.enabled) {
                m.addStackInfo(consumer);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void firstClientTick(TickEvent.ClientTickEvent event) {
        if (!this.clientTicked && event.phase == TickEvent.Phase.END) {
            this.dispatch(Step.FIRST_CLIENT_TICK, QuarkModule::firstClientTick);
            this.clientTicked = true;
        }
    }

    private void dispatch(Step step, Consumer<QuarkModule> run) {
        Quark.LOG.info("Dispatching Module Step " + step);
        this.foundModules.values().forEach(run);
        this.stepsHandled.add(step);
    }

    void enqueue(Runnable r) {
        Preconditions.checkNotNull((Object)this.event);
        this.event.enqueueWork(r);
    }

    public boolean isModuleEnabled(Class<? extends QuarkModule> moduleClazz) {
        QuarkModule module = this.getModuleInstance(moduleClazz);
        return module != null && module.enabled;
    }

    public boolean isModuleEnabledOrOverlapping(Class<? extends QuarkModule> moduleClazz) {
        QuarkModule module = this.getModuleInstance(moduleClazz);
        return module != null && (module.enabled || module.disabledByOverlap);
    }

    public QuarkModule getModuleInstance(Class<? extends QuarkModule> moduleClazz) {
        return this.foundModules.get(moduleClazz);
    }

    public boolean isItemEnabled(Item i) {
        BlockItem bi;
        Block b;
        if (i instanceof IQuarkItem) {
            IQuarkItem qi = (IQuarkItem)i;
            return qi.isEnabled();
        }
        if (i instanceof BlockItem && (b = (bi = (BlockItem)i).m_40614_()) instanceof IQuarkBlock) {
            IQuarkBlock qb = (IQuarkBlock)b;
            return qb.isEnabled();
        }
        return true;
    }

    public void initJEICompat(Runnable jeiRunnable) {
        this.onConfigReloadJEI = jeiRunnable;
        this.onConfigReloadJEI.run();
    }

    private static enum Step {
        CONSTRUCT,
        CONSTRUCT_CLIENT,
        REGISTER,
        POST_REGISTER,
        CONFIG_CHANGED,
        CONFIG_CHANGED_CLIENT,
        SETUP,
        SETUP_CLIENT,
        REGISTER_RELOADABLE,
        MODEL_BAKE,
        MODEL_LAYERS,
        TEXTURE_STITCH,
        POST_TEXTURE_STITCH,
        LOAD_COMPLETE,
        GENERATE_HINTS,
        FIRST_CLIENT_TICK,
        REGISTER_KEYBINDS,
        REGISTER_ADDITIONAL_MODELS,
        REGISTER_TOOLTIP_COMPONENT_FACTORIES,
        REGISTER_ITEM_COLORS,
        REGISTER_BLOCK_COLORS;

    }
}

