/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.config.external;

import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import vazkii.quark.api.config.IConfigCategory;
import vazkii.quark.api.config.IExternalCategory;
import vazkii.quark.base.client.config.ConfigCategory;

public class ExternalCategory
extends ConfigCategory
implements IExternalCategory {
    private final Map<String, IConfigCategory> topLevelCategories = new LinkedHashMap<String, IConfigCategory>();
    private final Consumer<IExternalCategory> onChangedCallback;

    public ExternalCategory(String name, Consumer<IExternalCategory> onChangedCallback, IConfigCategory parent) {
        super(name, "", parent, null);
        this.onChangedCallback = onChangedCallback;
    }

    @Override
    public IExternalCategory addTopLevelCategory(String name, Consumer<IExternalCategory> onChangedCallback) {
        ExternalCategory category = (ExternalCategory)this.addCategory(new ExternalCategory(name, onChangedCallback, (IConfigCategory)this));
        this.topLevelCategories.put(name, category);
        return category;
    }

    @Override
    public void commit() {
        this.onChangedCallback.accept(this);
    }

    @Override
    public IConfigCategory addCategory(String name, @Nonnull String comment, Object holderObject) {
        IConfigCategory category = super.addCategory(name, comment, holderObject);
        this.topLevelCategories.put(name, category);
        return category;
    }

    @Override
    public void print(String pad, PrintStream stream) {
        this.subElements.forEach(e -> e.print(pad, stream));
    }

    @Override
    public Map<String, IConfigCategory> getTopLevelCategories() {
        return this.topLevelCategories;
    }
}

