/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.block;

import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.interf.IBlockColorProvider;
import vazkii.arl.interf.IItemColorProvider;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.handler.CreativeTabHandler;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.handler.VariantHandler;
import vazkii.quark.base.module.QuarkModule;

public class QuarkSlabBlock
extends SlabBlock
implements IQuarkBlock,
IBlockColorProvider {
    public final IQuarkBlock parent;
    private BooleanSupplier enabledSupplier = () -> true;

    public QuarkSlabBlock(IQuarkBlock parent) {
        super(VariantHandler.realStateCopy(parent));
        this.parent = parent;
        RegistryHelper.registerBlock((Block)this, (String)IQuarkBlock.inheritQuark(parent, "%s_slab"));
        CreativeTabHandler.addTab(this, CreativeModeTab.f_40749_);
        RenderLayerHandler.setInherited((Block)this, parent.getBlock());
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return this.parent.isFlammable(state, world, pos, face);
    }

    @Override
    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return this.parent.getFlammability(state, world, pos, face);
    }

    public void m_49811_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.parent.isEnabled() || group == CreativeModeTab.f_40754_) {
            super.m_49811_(group, items);
        }
    }

    @Override
    @Nullable
    public QuarkModule getModule() {
        return this.parent.getModule();
    }

    @Override
    public QuarkSlabBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Nullable
    public float[] getBeaconColorMultiplier(BlockState state, LevelReader world, BlockPos pos, BlockPos beaconPos) {
        return this.parent.getBlock().getBeaconColorMultiplier(this.parent.getBlock().m_49966_(), world, pos, beaconPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockColor getBlockColor() {
        BlockColor blockColor;
        IQuarkBlock iQuarkBlock = this.parent;
        if (iQuarkBlock instanceof IBlockColorProvider) {
            IBlockColorProvider provider = (IBlockColorProvider)iQuarkBlock;
            blockColor = provider.getBlockColor();
        } else {
            blockColor = null;
        }
        return blockColor;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemColor getItemColor() {
        ItemColor itemColor;
        IQuarkBlock iQuarkBlock = this.parent;
        if (iQuarkBlock instanceof IItemColorProvider) {
            IItemColorProvider provider = (IItemColorProvider)iQuarkBlock;
            itemColor = provider.getItemColor();
        } else {
            itemColor = null;
        }
        return itemColor;
    }
}

