/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.events;

import de.maxhenkel.easyvillagers.ClientConfig;
import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.gui.CycleTradesButton;
import de.maxhenkel.easyvillagers.net.MessageCycleTrades;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GuiEvents {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onOpenScreen(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (!(screen instanceof MerchantScreen)) {
            return;
        }
        MerchantScreen merchantScreen = (MerchantScreen)screen;
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (!((Boolean)Main.SERVER_CONFIG.tradeCycling.get()).booleanValue()) {
            return;
        }
        ClientConfig.CycleTradesButtonLocation loc = (ClientConfig.CycleTradesButtonLocation)((Object)Main.CLIENT_CONFIG.cycleTradesButtonLocation.get());
        if (loc.equals((Object)ClientConfig.CycleTradesButtonLocation.NONE)) {
            return;
        }
        event.addListener((GuiEventListener)new CycleTradesButton(switch (loc) {
            default -> merchantScreen.getGuiLeft() + 107;
            case ClientConfig.CycleTradesButtonLocation.TOP_RIGHT -> merchantScreen.getGuiLeft() + 250;
        }, merchantScreen.getGuiTop() + 8, b -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageCycleTrades()), merchantScreen));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (event.getKey() != Main.CYCLE_TRADES_KEY.getKey().m_84873_() || event.getAction() != 0) {
            return;
        }
        if (!((Boolean)Main.SERVER_CONFIG.tradeCycling.get()).booleanValue()) {
            return;
        }
        Screen currentScreen = mc.f_91080_;
        if (!(currentScreen instanceof MerchantScreen)) {
            return;
        }
        MerchantScreen screen = (MerchantScreen)currentScreen;
        if (!CycleTradesButton.canCycle((MerchantMenu)screen.m_6262_())) {
            return;
        }
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageCycleTrades());
        mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }

    public static void onCycleTrades(ServerPlayer player) {
        if (!((Boolean)Main.SERVER_CONFIG.tradeCycling.get()).booleanValue()) {
            return;
        }
        if (!(player.f_36096_ instanceof MerchantMenu)) {
            return;
        }
        MerchantMenu container = (MerchantMenu)player.f_36096_;
        if (container.m_40065_() > 0 && container.f_40028_.m_40025_() != null) {
            return;
        }
        if (!(container.f_40027_ instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)container.f_40027_;
        villager.f_35261_ = null;
        EasyVillagerEntity.recalculateOffers(villager);
        player.m_7662_(container.f_38840_, villager.m_6616_(), villager.m_7141_().m_35576_(), villager.m_7809_(), villager.m_7826_(), villager.m_7862_());
    }
}

