/*
 * Decompiled with CFR 0.152.
 */
package com.prunoideae.custom.brew;

import com.prunoideae.custom.brew.BrewBuilder;
import com.prunoideae.custom.brew.MobEffectHolder;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.api.brew.Brew;

public class BasicBrewJS
extends Brew {
    private final ToIntFunction<ItemStack> getColor;

    public int getColor(ItemStack stack) {
        if (this.getColor != null) {
            return this.getColor.applyAsInt(ItemStackJS.of((Object)stack));
        }
        return super.getColor(stack);
    }

    public BasicBrewJS(Builder builder) {
        super(builder.cost, new MobEffectsHolder(builder.holders).cast());
        if (builder.noIncense) {
            this.setNotIncenseInfusable();
        }
        if (builder.noPendant) {
            this.setNotBloodPendantInfusable();
        }
        this.getColor = builder.getColor;
    }

    public static class Builder
    extends BrewBuilder {
        public Builder(ResourceLocation i) {
            super(i);
        }

        public Brew createObject() {
            return new BasicBrewJS(this);
        }
    }

    private static class MobEffectsHolder {
        private final List<MobEffectHolder> holders;
        private List<MobEffectInstance> instances = null;

        MobEffectsHolder(List<MobEffectHolder> holders) {
            this.holders = holders;
        }

        Supplier<List<MobEffectInstance>> cast() {
            return () -> {
                if (this.instances == null) {
                    this.instances = this.holders.stream().map(MobEffectHolder::get).collect(Collectors.toList());
                }
                return this.instances;
            };
        }
    }
}

