/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.biome;

import fuzs.puzzleslib.api.biome.v1.GenerationSettingsContext;
import fuzs.puzzleslib.proxy.Proxy;
import java.util.Collections;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;

public class GenerationSettingsContextForge
implements GenerationSettingsContext {
    private final Registry<ConfiguredWorldCarver<?>> carvers;
    private final Registry<PlacedFeature> features;
    private final BiomeGenerationSettingsBuilder context;

    private GenerationSettingsContextForge(RegistryAccess registryAccess, BiomeGenerationSettingsBuilder context) {
        this.carvers = registryAccess.m_175515_(Registry.f_122880_);
        this.features = registryAccess.m_175515_(Registry.f_194567_);
        this.context = context;
    }

    public static GenerationSettingsContextForge create(BiomeGenerationSettingsBuilder context) {
        MinecraftServer server = Proxy.INSTANCE.getGameServer();
        return new GenerationSettingsContextForge((RegistryAccess)server.m_206579_(), context);
    }

    @Override
    public boolean removeFeature(GenerationStep.Decoration step, ResourceKey<PlacedFeature> featureKey) {
        PlacedFeature feature = (PlacedFeature)this.features.m_123013_(featureKey);
        return this.context.getFeatures(step).removeIf(featureHolder -> featureHolder.m_203334_() == feature);
    }

    @Override
    public void addFeature(GenerationStep.Decoration step, ResourceKey<PlacedFeature> featureKey) {
        this.context.m_204201_(step, (Holder)this.features.m_203636_(featureKey).orElseThrow());
    }

    @Override
    public void addCarver(GenerationStep.Carving step, ResourceKey<ConfiguredWorldCarver<?>> carverKey) {
        this.context.m_204198_(step, (Holder)this.carvers.m_203636_(carverKey).orElseThrow());
    }

    @Override
    public boolean removeCarver(GenerationStep.Carving step, ResourceKey<ConfiguredWorldCarver<?>> carverKey) {
        ConfiguredWorldCarver carver = (ConfiguredWorldCarver)this.carvers.m_123013_(carverKey);
        return this.context.getCarvers(step).removeIf(carverHolder -> carverHolder.m_203334_() == carver);
    }

    @Override
    public Iterable<Holder<PlacedFeature>> getFeatures(GenerationStep.Decoration stage) {
        return Collections.unmodifiableList(this.context.getFeatures(stage));
    }

    @Override
    public Iterable<Holder<ConfiguredWorldCarver<?>>> getCarvers(GenerationStep.Carving stage) {
        return Collections.unmodifiableList(this.context.getCarvers(stage));
    }
}

