/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.networking.v3.serialization;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Vector3f;
import fuzs.puzzleslib.api.networking.v3.serialization.MessageSerializer;
import fuzs.puzzleslib.impl.networking.serialization.RecordSerializer;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Rotations;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

public final class MessageSerializers {
    private static final Map<Class<?>, MessageSerializer<?>> SERIALIZERS = Collections.synchronizedMap(Maps.newIdentityHashMap());
    private static final Map<Class<?>, Function<Type[], MessageSerializer<?>>> CONTAINER_PROVIDERS = Collections.synchronizedMap(Maps.newLinkedHashMap());

    private MessageSerializers() {
    }

    public static <T> void registerSerializer(Class<T> type, FriendlyByteBuf.Writer<T> writer, FriendlyByteBuf.Reader<T> reader) {
        MessageSerializers.registerSerializer(type, new MessageSerializerImpl<T>(writer, reader));
    }

    public static <T> void registerSerializer(Class<? super T> type, ResourceKey<Registry<T>> resourceKey) {
        Object registry = Registry.f_122897_.m_7804_(resourceKey.m_135782_()) ? (Registry)Registry.f_122897_.m_7745_(resourceKey.m_135782_()) : (BuiltinRegistries.f_123858_.m_7804_(resourceKey.m_135782_()) ? (Registry)BuiltinRegistries.f_123858_.m_7745_(resourceKey.m_135782_()) : null);
        Objects.requireNonNull(registry, "Registry for key %s not found".formatted(resourceKey.m_135782_()));
        MessageSerializers.registerSerializer(type, (arg_0, arg_1) -> MessageSerializers.lambda$registerSerializer$0((Registry)registry, arg_0, arg_1), arg_0 -> MessageSerializers.lambda$registerSerializer$1((Registry)registry, arg_0));
    }

    private static <T> void registerSerializer(Class<T> type, MessageSerializer<T> value) {
        if (SERIALIZERS.put(type, value) != null) {
            throw new IllegalStateException("Duplicate serializer registered for type %s".formatted(type));
        }
    }

    private static <T> void registerSerializer(Class<T> type, EntityDataSerializer<T> entityDataSerializer) {
        MessageSerializers.registerSerializer(type, (arg_0, arg_1) -> entityDataSerializer.m_6856_(arg_0, arg_1), arg_0 -> entityDataSerializer.m_6709_(arg_0));
    }

    public static <T> void registerContainerProvider(Class<T> type, Function<Type[], MessageSerializer<? extends T>> factory) {
        if (CONTAINER_PROVIDERS.put(type, factory) != null) {
            throw new IllegalStateException("Duplicate collection provider registered for type %s".formatted(type));
        }
    }

    public static <T> MessageSerializer<T> findByType(Class<T> type) {
        MessageSerializer<Object> serializer = SERIALIZERS.get(type);
        if (serializer == null) {
            serializer = MessageSerializers.computeIfAbsent(type);
            SERIALIZERS.put(type, serializer);
        }
        return serializer;
    }

    private static <T, E extends Enum<E>> MessageSerializer<T> computeIfAbsent(Class<T> clazz) {
        if (Record.class.isAssignableFrom(clazz)) {
            return RecordSerializer.createRecordSerializer(clazz);
        }
        if (clazz.isArray()) {
            return MessageSerializers.createArraySerializer(clazz.getComponentType());
        }
        if (clazz.isEnum()) {
            return MessageSerializers.createEnumSerializer(clazz);
        }
        throw new RuntimeException("Missing serializer for type %s".formatted(clazz));
    }

    @ApiStatus.Internal
    public static MessageSerializer<?> findByGenericType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return MessageSerializers.findByType(clazz);
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Class clazz = (Class)parameterizedType.getRawType();
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        for (Map.Entry<Class<?>, Function<Type[], MessageSerializer<?>>> entry : CONTAINER_PROVIDERS.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            return entry.getValue().apply(typeArguments);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return MessageSerializers.createCollectionSerializer(typeArguments, Sets::newLinkedHashSetWithExpectedSize);
        }
        return MessageSerializers.findByType(clazz);
    }

    private static <K, V> MessageSerializer<Map<K, V>> createMapSerializer(Type[] typeArguments) {
        MessageSerializer keySerializer = MessageSerializers.findByType((Class)typeArguments[0]);
        MessageSerializer valueSerializer = MessageSerializers.findByType((Class)typeArguments[1]);
        return new MessageSerializerImpl<Map<K, V>>((friendlyByteBuf, o) -> friendlyByteBuf.m_236831_(o, keySerializer::write, valueSerializer::write), friendlyByteBuf -> friendlyByteBuf.m_236847_(keySerializer::read, valueSerializer::read));
    }

    private static <T, C extends Collection<T>> MessageSerializer<C> createCollectionSerializer(Type[] typeArguments, IntFunction<C> factory) {
        MessageSerializer serializer = MessageSerializers.findByType((Class)typeArguments[0]);
        return new MessageSerializerImpl((friendlyByteBuf, o) -> friendlyByteBuf.m_236828_(o, serializer::write), friendlyByteBuf -> friendlyByteBuf.m_236838_(factory, serializer::read));
    }

    private static <T> MessageSerializer<Optional<T>> createOptionalSerializer(Type[] typeArguments) {
        MessageSerializer serializer = MessageSerializers.findByType((Class)typeArguments[0]);
        return new MessageSerializerImpl<Optional<T>>((friendlyByteBuf, o) -> friendlyByteBuf.m_236835_(o, serializer::write), friendlyByteBuf -> friendlyByteBuf.m_236860_(serializer::read));
    }

    private static <L, R> MessageSerializer<Either<L, R>> createEitherSerializer(Type[] typeArguments) {
        MessageSerializer leftSerializer = MessageSerializers.findByType((Class)typeArguments[0]);
        MessageSerializer rightSerializer = MessageSerializers.findByType((Class)typeArguments[1]);
        return new MessageSerializerImpl<Either<L, R>>((friendlyByteBuf, o) -> friendlyByteBuf.m_236810_(o, leftSerializer::write, rightSerializer::write), friendlyByteBuf -> friendlyByteBuf.m_236862_(leftSerializer::read, rightSerializer::read));
    }

    private static MessageSerializer<?> createArraySerializer(Class<?> clazz) {
        MessageSerializer<?> serializer = MessageSerializers.findByType(clazz);
        return new MessageSerializerImpl((buf, t) -> {
            int length = Array.getLength(t);
            buf.m_130130_(length);
            for (int i = 0; i < length; ++i) {
                serializer.write((FriendlyByteBuf)buf, Array.get(t, i));
            }
        }, buf -> {
            int length = buf.m_130242_();
            Object array = Array.newInstance(clazz, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, serializer.read((FriendlyByteBuf)buf));
            }
            return array;
        });
    }

    private static <E extends Enum<E>> MessageSerializer<E> createEnumSerializer(Class<E> clazz) {
        return new MessageSerializerImpl(FriendlyByteBuf::m_130068_, buf -> buf.m_130066_(clazz));
    }

    private static /* synthetic */ Object lambda$registerSerializer$1(Registry registry, FriendlyByteBuf friendlyByteBuf) {
        return registry.m_7942_(friendlyByteBuf.m_130242_());
    }

    private static /* synthetic */ void lambda$registerSerializer$0(Registry registry, FriendlyByteBuf friendlyByteBuf, Object t) {
        friendlyByteBuf.m_130130_(registry.m_7447_(t));
    }

    static {
        MessageSerializers.registerSerializer(Boolean.TYPE, FriendlyByteBuf::writeBoolean, FriendlyByteBuf::readBoolean);
        MessageSerializers.registerSerializer(Boolean.class, FriendlyByteBuf::writeBoolean, FriendlyByteBuf::readBoolean);
        MessageSerializers.registerSerializer(Integer.TYPE, FriendlyByteBuf::m_130130_, FriendlyByteBuf::m_130242_);
        MessageSerializers.registerSerializer(Integer.class, FriendlyByteBuf::m_130130_, FriendlyByteBuf::m_130242_);
        MessageSerializers.registerSerializer(Long.TYPE, FriendlyByteBuf::m_130103_, FriendlyByteBuf::m_130258_);
        MessageSerializers.registerSerializer(Long.class, FriendlyByteBuf::m_130103_, FriendlyByteBuf::m_130258_);
        MessageSerializers.registerSerializer(Float.TYPE, FriendlyByteBuf::writeFloat, FriendlyByteBuf::readFloat);
        MessageSerializers.registerSerializer(Float.class, FriendlyByteBuf::writeFloat, FriendlyByteBuf::readFloat);
        MessageSerializers.registerSerializer(Double.TYPE, FriendlyByteBuf::writeDouble, FriendlyByteBuf::readDouble);
        MessageSerializers.registerSerializer(Double.class, FriendlyByteBuf::writeDouble, FriendlyByteBuf::readDouble);
        MessageSerializers.registerSerializer(Byte.TYPE, FriendlyByteBuf::writeByte, FriendlyByteBuf::readByte);
        MessageSerializers.registerSerializer(Byte.class, FriendlyByteBuf::writeByte, FriendlyByteBuf::readByte);
        MessageSerializers.registerSerializer(Short.TYPE, FriendlyByteBuf::writeShort, FriendlyByteBuf::readShort);
        MessageSerializers.registerSerializer(Short.class, FriendlyByteBuf::writeShort, FriendlyByteBuf::readShort);
        MessageSerializers.registerSerializer(Character.TYPE, FriendlyByteBuf::writeChar, FriendlyByteBuf::readChar);
        MessageSerializers.registerSerializer(Character.class, FriendlyByteBuf::writeChar, FriendlyByteBuf::readChar);
        MessageSerializers.registerSerializer(String.class, EntityDataSerializers.f_135030_);
        MessageSerializers.registerSerializer(Date.class, FriendlyByteBuf::m_130075_, FriendlyByteBuf::m_130282_);
        MessageSerializers.registerSerializer(Instant.class, FriendlyByteBuf::m_236826_, FriendlyByteBuf::m_236873_);
        MessageSerializers.registerSerializer(UUID.class, FriendlyByteBuf::m_130077_, FriendlyByteBuf::m_130259_);
        MessageSerializers.registerSerializer(Component.class, EntityDataSerializers.f_135031_);
        MessageSerializers.registerSerializer(ItemStack.class, EntityDataSerializers.f_135033_);
        MessageSerializers.registerSerializer(Rotations.class, EntityDataSerializers.f_135037_);
        MessageSerializers.registerSerializer(BlockPos.class, EntityDataSerializers.f_135038_);
        MessageSerializers.registerSerializer(Direction.class, EntityDataSerializers.f_135040_);
        MessageSerializers.registerSerializer(CompoundTag.class, EntityDataSerializers.f_135042_);
        MessageSerializers.registerSerializer(ParticleOptions.class, EntityDataSerializers.f_135036_);
        MessageSerializers.registerSerializer(VillagerData.class, EntityDataSerializers.f_135043_);
        MessageSerializers.registerSerializer(Pose.class, EntityDataSerializers.f_135045_);
        MessageSerializers.registerSerializer(ChunkPos.class, FriendlyByteBuf::m_178341_, FriendlyByteBuf::m_178383_);
        MessageSerializers.registerSerializer(ResourceLocation.class, FriendlyByteBuf::m_130085_, FriendlyByteBuf::m_130281_);
        MessageSerializers.registerSerializer(BlockHitResult.class, FriendlyByteBuf::m_130062_, FriendlyByteBuf::m_130283_);
        MessageSerializers.registerSerializer(BitSet.class, FriendlyByteBuf::m_178350_, FriendlyByteBuf::m_178384_);
        MessageSerializers.registerSerializer(GameProfile.class, FriendlyByteBuf::m_236803_, FriendlyByteBuf::m_236875_);
        MessageSerializers.registerSerializer(Vec3.class, (friendlyByteBuf, vec3) -> {
            friendlyByteBuf.writeDouble(vec3.m_7096_());
            friendlyByteBuf.writeDouble(vec3.m_7098_());
            friendlyByteBuf.writeDouble(vec3.m_7094_());
        }, friendlyByteBuf -> new Vec3(friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble()));
        MessageSerializers.registerSerializer(Vector3f.class, (friendlyByteBuf, vec3) -> {
            friendlyByteBuf.writeFloat(vec3.m_122239_());
            friendlyByteBuf.writeFloat(vec3.m_122260_());
            friendlyByteBuf.writeFloat(vec3.m_122269_());
        }, friendlyByteBuf -> new Vector3f(friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat()));
        MessageSerializers.registerSerializer(FriendlyByteBuf.class, (buf, other) -> {
            buf.m_130130_(other.readableBytes());
            buf.writeBytes((ByteBuf)other);
            other.release();
        }, buf -> new FriendlyByteBuf(buf.readBytes(buf.m_130242_())));
        MessageSerializers.registerSerializer(SoundEvent.class, Registry.f_122898_);
        MessageSerializers.registerSerializer(Fluid.class, Registry.f_122899_);
        MessageSerializers.registerSerializer(MobEffect.class, Registry.f_122900_);
        MessageSerializers.registerSerializer(Block.class, Registry.f_122901_);
        MessageSerializers.registerSerializer(Enchantment.class, Registry.f_122902_);
        MessageSerializers.registerSerializer(EntityType.class, Registry.f_122903_);
        MessageSerializers.registerSerializer(Item.class, Registry.f_122904_);
        MessageSerializers.registerSerializer(Potion.class, Registry.f_122905_);
        MessageSerializers.registerSerializer(ParticleType.class, Registry.f_122906_);
        MessageSerializers.registerSerializer(BlockEntityType.class, Registry.f_122907_);
        MessageSerializers.registerSerializer(MenuType.class, Registry.f_122913_);
        MessageSerializers.registerSerializer(Attribute.class, Registry.f_122916_);
        MessageSerializers.registerSerializer(GameEvent.class, Registry.f_175423_);
        MessageSerializers.registerSerializer(VillagerType.class, Registry.f_122808_);
        MessageSerializers.registerSerializer(VillagerProfession.class, Registry.f_122809_);
        MessageSerializers.registerSerializer(PoiType.class, Registry.f_122810_);
        MessageSerializers.registerContainerProvider(Map.class, MessageSerializers::createMapSerializer);
        MessageSerializers.registerContainerProvider(List.class, typeArguments -> MessageSerializers.createCollectionSerializer(typeArguments, Lists::newArrayListWithExpectedSize));
        MessageSerializers.registerContainerProvider(Optional.class, MessageSerializers::createOptionalSerializer);
        MessageSerializers.registerContainerProvider(Either.class, MessageSerializers::createEitherSerializer);
    }

    private record MessageSerializerImpl<T>(FriendlyByteBuf.Writer<T> writer, FriendlyByteBuf.Reader<T> reader) implements MessageSerializer<T>
    {
        @Override
        public void write(FriendlyByteBuf buf, T instance) {
            this.writer.accept((Object)buf, instance);
        }

        @Override
        public T read(FriendlyByteBuf buf) {
            return (T)this.reader.apply((Object)buf);
        }
    }
}

