/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.mods.blazemek;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="blazemek")
public class BlazeMek {
    public static final Logger LOGGER = LogManager.getLogger();
    Lazy<Block> underBlock = Lazy.of(() -> {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("mob_grinding_utils:dreadful_dirt"));
        if (block == null) {
            return Blocks.f_50016_;
        }
        return block;
    });

    public BlazeMek() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onEntitySpawned(LivingSpawnEvent.CheckSpawn event) {
        LevelAccessor level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Mob entity = event.getEntity();
        if (!serverLevel.m_46472_().equals((Object)Level.f_46429_)) {
            return;
        }
        if (entity instanceof Blaze || entity instanceof WitherSkeleton) {
            return;
        }
        if (serverLevel.m_213780_().m_188503_(100) > 25) {
            return;
        }
        BlockPos belowLocation = entity.m_20183_().m_7495_();
        BlockState blockUnderEntity = serverLevel.m_8055_(belowLocation);
        if (!blockUnderEntity.m_60795_() && blockUnderEntity.m_60734_() == this.underBlock.get()) {
            Monster entityToSpawn;
            event.setResult(Event.Result.DENY);
            boolean shouldSpawnBlaze = serverLevel.m_213780_().m_188503_(100) > 30;
            Monster monster = entityToSpawn = shouldSpawnBlaze ? (Monster)EntityType.f_20551_.m_20615_((Level)serverLevel) : (Monster)EntityType.f_20497_.m_20615_((Level)serverLevel);
            if (entityToSpawn == null) {
                LOGGER.warn("Failed to create Blaze or Wither Skeleton...");
                return;
            }
            entityToSpawn.m_146884_(new Vec3((double)belowLocation.m_123341_() + 0.25, (double)belowLocation.m_123342_() + 1.25, (double)belowLocation.m_123343_() + 0.25));
            serverLevel.m_7967_((Entity)entityToSpawn);
        }
    }
}

