/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.MowLibUtils;

import com.mowmaster.mowlib.Capabilities.Experience.CapabilityExperience;
import com.mowmaster.mowlib.Capabilities.Experience.IExperienceStorage;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;

public class MowLibXpUtils {
    public static LazyOptional<IExperienceStorage> findExperienceHandlerAtPos(Level world, BlockPos pos, Direction side, boolean allowCart) {
        LazyOptional cap;
        List list;
        LazyOptional cap2;
        BlockEntity neighbourTile = world.m_7702_(pos);
        if (neighbourTile != null && (cap2 = neighbourTile.getCapability(CapabilityExperience.EXPERIENCE, side)).isPresent()) {
            return cap2;
        }
        if (allowCart && !(list = world.m_6443_(Entity.class, new AABB(pos), entity -> entity instanceof ContainerEntity)).isEmpty() && (cap = ((Entity)list.get(world.f_46441_.m_188503_(list.size()))).getCapability(CapabilityExperience.EXPERIENCE)).isPresent()) {
            return cap;
        }
        return LazyOptional.empty();
    }

    public static int removeXp(Player player, int amount) {
        int startAmount = amount;
        while (amount > 0) {
            int barCap = player.m_36323_();
            int barXp = (int)((float)barCap * player.f_36080_);
            int removeXp = Math.min(barXp, amount);
            int newBarXp = barXp - removeXp;
            amount -= removeXp;
            player.f_36079_ -= removeXp;
            if (player.f_36079_ < 0) {
                player.f_36079_ = 0;
            }
            if (newBarXp == 0 && amount > 0) {
                --player.f_36078_;
                if (player.f_36078_ < 0) {
                    player.f_36078_ = 0;
                    player.f_36079_ = 0;
                    player.f_36080_ = 0.0f;
                    break;
                }
                player.f_36080_ = 1.0f;
                continue;
            }
            player.f_36080_ = (float)newBarXp / (float)barCap;
        }
        return startAmount - amount;
    }

    public static int getExpCountByLevel(int level) {
        int expUsed = 0;
        if (level <= 16) {
            expUsed = level * level + 6 * level;
        } else if (level > 16 && level <= 31) {
            expUsed = (int)(2.5 * (double)(level * level) - 40.5 * (double)level + 360.0);
        } else if (level > 31) {
            expUsed = (int)(4.5 * (double)(level * level) - 162.5 * (double)level + 2220.0);
        }
        return expUsed;
    }

    public static int getExpLevelFromCount(int value) {
        boolean level = false;
        long maths = 0L;
        int i = 0;
        boolean j = false;
        if (value > 0 && value <= 352) {
            maths = (long)Math.sqrt(Math.addExact(36L, Math.addExact(4L, (long)value)));
            i = Math.round(Math.addExact(-6L, maths) / 2L);
        }
        if (value > 352 && value <= 1507) {
            maths = (long)Math.sqrt(Math.subtractExact(164025L, Math.multiplyExact(100L, Math.subtractExact(3600L, Math.multiplyExact(10L, (long)value)))));
            i = (int)(Math.addExact(405L, maths) / 50L);
        }
        if (value > 1507) {
            maths = (long)Math.sqrt(Math.subtractExact(2640625L, Math.multiplyExact(180L, Math.subtractExact(22200L, Math.multiplyExact(10L, (long)value)))));
            i = (int)(Math.addExact(1625L, maths) / 90L);
        }
        return Math.abs(i);
    }

    public static void dropXPInWorld(Level level, BlockPos pos, IExperienceStorage xpStorage) {
        if (xpStorage.getExperienceStored() > 0) {
            ExperienceOrb xpEntity = new ExperienceOrb(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), xpStorage.getExperienceStored());
            xpEntity.m_6001_(0.0, 0.0, 0.0);
            level.m_7967_((Entity)xpEntity);
        }
    }
}

