/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Compat.JEI.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mowmaster.mowlib.Compat.JEI.JEIRecipeTypes;
import com.mowmaster.mowlib.Recipes.BaseBlockEntityFilter;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class MobFilterCategory
implements IRecipeCategory<BaseBlockEntityFilter> {
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable icon;
    private final ItemStack renderStack = new ItemStack((ItemLike)Items.f_42678_).m_41714_((Component)Component.m_237115_((String)"mowlib.jei.mob_filter_icon"));

    public MobFilterCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("mowlib", "textures/gui/jei/mob_filter.png"), 0, 0, 176, 32);
        this.localizedName = Component.m_237115_((String)"mowlib.jei.mob_filter");
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)this.renderStack);
    }

    public RecipeType<BaseBlockEntityFilter> getRecipeType() {
        return JEIRecipeTypes.MOB_FILTER;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BaseBlockEntityFilter recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 5, 8).addIngredients((Ingredient)recipe.m_7527_().get(0));
    }

    public void draw(BaseBlockEntityFilter recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        MutableComponent mobName;
        RenderSystem.m_69478_();
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int mobType = recipe.getResultMobType();
        MutableComponent mobTypeText = Component.m_237115_((String)"mowlib.mob_filter_type");
        if (mobType == 1) {
            mobTypeText = Component.m_237115_((String)"mowlib.mob_filter_entity");
        }
        mobTypeText.m_130940_(ChatFormatting.BLACK);
        fontRenderer.m_92889_(stack, (Component)mobTypeText, 45.0f, 7.0f, -1);
        MutableComponent mutableComponent = mobName = mobType == 0 ? Component.m_237115_((String)("mowlib.mob_filter." + MobCategory.byName((String)recipe.getEntityString()).m_21607_())) : ((EntityType)EntityType.m_20632_((String)recipe.getEntityString()).get()).m_20676_().m_6881_();
        if (recipe.getResultBaby()) {
            mobName.m_7220_((Component)Component.m_237115_((String)"mowlib.mob_filter_baby"));
        }
        mobName.m_130940_(ChatFormatting.BLACK);
        fontRenderer.m_92889_(stack, (Component)mobName, 45.0f, 19.0f, -1);
    }
}

