/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion;

import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import dev.ftb.packcompanion.CommandRegistry;
import dev.ftb.packcompanion.PackCompanionClient;
import dev.ftb.packcompanion.PackCompanionExpectPlatform;
import dev.ftb.packcompanion.config.PCCommonConfig;
import dev.ftb.packcompanion.config.PCServerConfig;
import dev.ftb.packcompanion.features.CommonFeature;
import dev.ftb.packcompanion.features.Features;
import dev.ftb.packcompanion.integrations.IntegrationsCommon;
import dev.ftb.packcompanion.integrations.IntegrationsEntrypoint;
import dev.ftb.packcompanion.registry.LootTableRegistries;
import dev.ftb.packcompanion.registry.ReloadResourceManager;
import dev.ftb.packcompanion.registry.StructureProcessorRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;

public class PackCompanion {
    public static IntegrationsEntrypoint commonIntegrationsEntry = new IntegrationsCommon();

    public static void init() {
        LootTableRegistries.REGISTRY.register();
        StructureProcessorRegistry.REGISTRY.register();
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)ReloadResourceManager.INSTANCE);
        CommandRegistrationEvent.EVENT.register(CommandRegistry::setup);
        LifecycleEvent.SERVER_BEFORE_START.register(PackCompanion::serverBeforeStart);
        LifecycleEvent.SERVER_STARTED.register(PackCompanion::serverStarted);
        LifecycleEvent.SETUP.register(PackCompanion::onSetup);
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> PackCompanionClient::init);
    }

    private static void onSetup() {
        PCCommonConfig.load();
        Features.INSTANCE.getCommonFeatures().forEach(CommonFeature::setup);
        commonIntegrationsEntry.onCommonInit();
        PackCompanionExpectPlatform.getIntegrationEntry().onCommonInit();
    }

    private static void serverBeforeStart(MinecraftServer server) {
        commonIntegrationsEntry.onServerInit();
        PackCompanionExpectPlatform.getIntegrationEntry().onServerInit();
        PCServerConfig.load(server);
    }

    private static void serverStarted(MinecraftServer server) {
        Features.INSTANCE.getServerFeatures().forEach(e -> e.setup(server));
    }
}

