/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.magic;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.block.circle.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.item.MediaHolderItem;
import at.petrak.hexcasting.api.misc.DiscoveryHandlers;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.ItemLoreFragment;
import at.petrak.hexcasting.common.items.magic.DebugUnlockerHolder;
import at.petrak.hexcasting.common.items.magic.ItemMediaHolder;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexSounds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class ItemCreativeUnlocker
extends Item
implements MediaHolderItem {
    public static final String DISPLAY_MEDIA = "media";
    public static final String DISPLAY_PATTERNS = "patterns";
    public static final String TAG_EXTRACTIONS = "extractions";
    public static final String TAG_INSERTIONS = "insertions";

    public static boolean isDebug(ItemStack stack) {
        return ItemCreativeUnlocker.isDebug(stack, null);
    }

    public static boolean isDebug(ItemStack stack, String flag) {
        if (!stack.m_150930_((Item)HexItems.CREATIVE_UNLOCKER) || !stack.m_41788_()) {
            return false;
        }
        List<String> keywords = Arrays.asList(stack.m_41786_().getString().toLowerCase(Locale.ROOT).split(" "));
        if (!keywords.contains("debug")) {
            return false;
        }
        return flag == null || keywords.contains(flag);
    }

    public static Component infiniteMedia(Level level) {
        String prefix = "item.hexcasting.creative_unlocker.";
        String emphasis = Language.m_128107_().m_6834_(prefix + "for_emphasis");
        MutableComponent emphasized = Component.m_237119_();
        for (int i = 0; i < emphasis.length(); ++i) {
            emphasized.m_7220_((Component)ItemCreativeUnlocker.rainbow(Component.m_237113_((String)("" + emphasis.charAt(i))), i, level));
        }
        return emphasized;
    }

    public ItemCreativeUnlocker(Item.Properties properties) {
        super(properties);
    }

    @Override
    public int getMedia(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxMedia(ItemStack stack) {
        return 0x7FFFFFFE;
    }

    @Override
    public void setMedia(ItemStack stack, int media) {
    }

    @Override
    public boolean canProvideMedia(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canRecharge(ItemStack stack) {
        return true;
    }

    public static void addToIntArray(ItemStack stack, String tag, int n) {
        int[] arr = NBTHelper.getIntArray(stack, tag);
        if (arr == null) {
            arr = new int[]{};
        }
        int[] newArr = Arrays.copyOf(arr, arr.length + 1);
        newArr[newArr.length - 1] = n;
        NBTHelper.putIntArray(stack, tag, newArr);
    }

    @Override
    public int withdrawMedia(ItemStack stack, int cost, boolean simulate) {
        if (!simulate && ItemCreativeUnlocker.isDebug(stack, DISPLAY_MEDIA)) {
            ItemCreativeUnlocker.addToIntArray(stack, TAG_EXTRACTIONS, cost);
        }
        return cost < 0 ? this.getMedia(stack) : cost;
    }

    @Override
    public int insertMedia(ItemStack stack, int amount, boolean simulate) {
        if (!simulate && ItemCreativeUnlocker.isDebug(stack, DISPLAY_MEDIA)) {
            ItemCreativeUnlocker.addToIntArray(stack, TAG_INSERTIONS, amount);
        }
        return amount < 0 ? this.getMaxMedia(stack) : amount;
    }

    public boolean m_5812_(ItemStack stack) {
        return super.m_5812_(stack) || ItemCreativeUnlocker.isDebug(stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (ItemCreativeUnlocker.isDebug(stack, DISPLAY_MEDIA) && !level.f_46443_) {
            this.debugDisplay(stack, TAG_EXTRACTIONS, "withdrawn", "all_media", entity);
            this.debugDisplay(stack, TAG_INSERTIONS, "inserted", "infinite_media", entity);
        }
    }

    private void debugDisplay(ItemStack stack, String tag, String langKey, String allKey, Entity entity) {
        int[] arr = NBTHelper.getIntArray(stack, tag);
        if (arr != null) {
            NBTHelper.remove(stack, tag);
            for (int i : arr) {
                if (i < 0) {
                    entity.m_213846_((Component)Component.m_237110_((String)("hexcasting.debug.media_" + langKey), (Object[])new Object[]{stack.m_41611_(), Component.m_237115_((String)("hexcasting.debug." + allKey)).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.LIGHT_PURPLE));
                    continue;
                }
                entity.m_213846_((Component)Component.m_237110_((String)("hexcasting.debug.media_" + langKey + ".with_dust"), (Object[])new Object[]{stack.m_41611_(), Component.m_237113_((String)("" + i)).m_130940_(ChatFormatting.WHITE), Component.m_237113_((String)String.format("%.2f", (double)i * 1.0 / 10000.0)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.LIGHT_PURPLE));
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockEntity be = context.m_43725_().m_7702_(context.m_8083_());
        if (be instanceof BlockEntityAbstractImpetus) {
            BlockEntityAbstractImpetus impetus = (BlockEntityAbstractImpetus)be;
            impetus.setInfiniteMedia();
            context.m_43725_().m_5594_(null, context.m_8083_(), HexSounds.SPELL_CIRCLE_FIND_BLOCK, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_());
        }
        return InteractionResult.PASS;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity consumer) {
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            if (consumer instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)consumer;
                ArrayList<ResourceLocation> names = new ArrayList<ResourceLocation>(ItemLoreFragment.NAMES);
                names.add(0, HexAPI.modLoc("root"));
                for (ResourceLocation name : names) {
                    Advancement rootAdv = slevel.m_7654_().m_129889_().m_136041_(name);
                    if (rootAdv == null) continue;
                    ArrayList<Advancement> children = new ArrayList<Advancement>();
                    children.add(rootAdv);
                    ItemCreativeUnlocker.addChildren(rootAdv, children);
                    PlayerAdvancements adman = player.m_8960_();
                    for (Advancement kid : children) {
                        AdvancementProgress progress = adman.m_135996_(kid);
                        if (progress.m_8193_()) continue;
                        for (String crit : progress.m_8219_()) {
                            adman.m_135988_(kid, crit);
                        }
                    }
                }
            }
        }
        ItemStack copy = stack.m_41777_();
        super.m_5922_(stack, level, consumer);
        return copy;
    }

    private static MutableComponent rainbow(MutableComponent component, int shift, Level level) {
        if (level == null) {
            return component.m_130940_(ChatFormatting.WHITE);
        }
        return component.m_130938_(s -> s.m_131148_(TextColor.m_131266_((int)Mth.m_14169_((float)((float)((level.m_46467_() + (long)shift) * 2L % 360L) / 360.0f), (float)1.0f, (float)1.0f))));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        Component emphasized = ItemCreativeUnlocker.infiniteMedia(level);
        MutableComponent modName = Component.m_237115_((String)"item.hexcasting.creative_unlocker.mod_name").m_130938_(s -> s.m_131148_(ItemMediaHolder.HEX_COLOR));
        tooltipComponents.add((Component)Component.m_237110_((String)"hexcasting.spelldata.onitem", (Object[])new Object[]{emphasized}).m_130940_(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.m_237110_((String)"item.hexcasting.creative_unlocker.tooltip", (Object[])new Object[]{modName}).m_130940_(ChatFormatting.GRAY));
    }

    private static void addChildren(Advancement root, List<Advancement> out) {
        for (Advancement kiddo : root.m_138322_()) {
            out.add(kiddo);
            ItemCreativeUnlocker.addChildren(kiddo, out);
        }
    }

    static {
        DiscoveryHandlers.addDebugItemDiscoverer((player, type) -> {
            for (ItemStack item : player.m_150109_().f_35974_) {
                if (!ItemCreativeUnlocker.isDebug(item, type)) continue;
                return item;
            }
            for (ItemStack item : player.m_150109_().f_35975_) {
                if (!ItemCreativeUnlocker.isDebug(item, type)) continue;
                return item;
            }
            for (ItemStack item : player.m_150109_().f_35976_) {
                if (!ItemCreativeUnlocker.isDebug(item, type)) continue;
                return item;
            }
            return ItemStack.f_41583_;
        });
        DiscoveryHandlers.addMediaHolderDiscoverer(harness -> {
            ServerPlayer player = harness.getCtx().getCaster();
            if (!player.m_7500_()) {
                return List.of();
            }
            ItemStack stack = DiscoveryHandlers.findDebugItem((Player)player, DISPLAY_MEDIA);
            if (!stack.m_41619_()) {
                return List.of(new DebugUnlockerHolder(stack));
            }
            return List.of();
        });
    }
}

