/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.spell.casting;

import at.petrak.hexcasting.api.PatternRegistry;
import at.petrak.hexcasting.api.addldata.ADHexHolder;
import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import at.petrak.hexcasting.api.advancements.HexAdvancementTriggers;
import at.petrak.hexcasting.api.block.circle.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.misc.DamageSourceOvercast;
import at.petrak.hexcasting.api.misc.DiscoveryHandlers;
import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.api.misc.HexDamageSources;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.mod.HexStatistics;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.spell.Action;
import at.petrak.hexcasting.api.spell.OperationResult;
import at.petrak.hexcasting.api.spell.ParticleSpray;
import at.petrak.hexcasting.api.spell.SpellList;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.ControllerInfo;
import at.petrak.hexcasting.api.spell.casting.ResolvedPatternType;
import at.petrak.hexcasting.api.spell.casting.SpecialPatterns;
import at.petrak.hexcasting.api.spell.casting.eval.ContinuationFrame;
import at.petrak.hexcasting.api.spell.casting.eval.FrameEvaluate;
import at.petrak.hexcasting.api.spell.casting.eval.FunctionalData;
import at.petrak.hexcasting.api.spell.casting.eval.SpellContinuation;
import at.petrak.hexcasting.api.spell.casting.sideeffects.EvalSound;
import at.petrak.hexcasting.api.spell.casting.sideeffects.OperatorSideEffect;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.iota.ListIota;
import at.petrak.hexcasting.api.spell.iota.PatternIota;
import at.petrak.hexcasting.api.spell.math.HexDir;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.spell.mishaps.Mishap;
import at.petrak.hexcasting.api.spell.mishaps.MishapDisallowedSpell;
import at.petrak.hexcasting.api.spell.mishaps.MishapError;
import at.petrak.hexcasting.api.spell.mishaps.MishapTooManyCloseParens;
import at.petrak.hexcasting.api.spell.mishaps.MishapUnescapedValue;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.api.utils.MediaHelper;
import at.petrak.hexcasting.api.utils.NBTBuilder;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.api.utils.NbtCompoundBuilder;
import at.petrak.hexcasting.api.utils.PatternNameHelper;
import at.petrak.hexcasting.common.lib.hex.HexEvalSounds;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 V2\u00020\u0001:\u0003UVWB\u001b\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006BO\b\u0002\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J \u0010,\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010-\u001a\u00020.H\u0002J\u0016\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\t2\u0006\u00102\u001a\u000203J\u001c\u00104\u001a\u0002002\f\u00105\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u00102\u001a\u000203J6\u00106\u001a2\u0012\u0012\u0012\u0010\u0012\f\u0012\n 9*\u0004\u0018\u000108080\u000e\u0012\u0012\u0012\u0010\u0012\f\u0012\n 9*\u0004\u0018\u000108080\u000e\u0012\u0006\u0012\u0004\u0018\u00010807J\u0006\u0010:\u001a\u00020\u0005J\u0006\u0010;\u001a\u00020+J\u001a\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020?2\u0006\u00102\u001a\u000203H\u0002J\u001a\u0010@\u001a\u0004\u0018\u00010=2\u0006\u00101\u001a\u00020\t2\u0006\u00102\u001a\u000203H\u0002J\u0012\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010>\u001a\u00020?H\u0002J\u001e\u0010C\u001a\u00020D2\u0006\u00101\u001a\u00020\t2\u0006\u00102\u001a\u0002032\u0006\u0010E\u001a\u00020FJ\u001e\u0010G\u001a\u0010\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020I\u0018\u00010H2\u0006\u00101\u001a\u00020\tH\u0002J\u001c\u0010J\u001a\u00020)2\u0006\u0010K\u001a\u00020L2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020N0\u000eJ\u0006\u0010O\u001a\u000208J\u001e\u0010P\u001a\u00020D2\u0006\u0010Q\u001a\u00020B2\u0006\u00102\u001a\u0002032\u0006\u0010E\u001a\u00020FJ\u0016\u0010R\u001a\u00020\f2\u0006\u0010S\u001a\u00020\f2\u0006\u0010T\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001c\u0010\n\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001d\"\u0004\b'\u0010\u001f\u00a8\u0006X"}, d2={"Lat/petrak/hexcasting/api/spell/casting/CastingHarness;", "", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "prepackagedColorizer", "Lat/petrak/hexcasting/api/misc/FrozenColorizer;", "(Lat/petrak/hexcasting/api/spell/casting/CastingContext;Lat/petrak/hexcasting/api/misc/FrozenColorizer;)V", "stack", "", "Lat/petrak/hexcasting/api/spell/iota/Iota;", "ravenmind", "parenCount", "", "parenthesized", "", "escapeNext", "", "(Ljava/util/List;Lat/petrak/hexcasting/api/spell/iota/Iota;ILjava/util/List;ZLat/petrak/hexcasting/api/spell/casting/CastingContext;Lat/petrak/hexcasting/api/misc/FrozenColorizer;)V", "getCtx", "()Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "getEscapeNext", "()Z", "setEscapeNext", "(Z)V", "getParenCount", "()I", "setParenCount", "(I)V", "getParenthesized", "()Ljava/util/List;", "setParenthesized", "(Ljava/util/List;)V", "getPrepackagedColorizer", "()Lat/petrak/hexcasting/api/misc/FrozenColorizer;", "getRavenmind", "()Lat/petrak/hexcasting/api/spell/iota/Iota;", "setRavenmind", "(Lat/petrak/hexcasting/api/spell/iota/Iota;)V", "getStack", "setStack", "applyFunctionalData", "", "data", "Lat/petrak/hexcasting/api/spell/casting/eval/FunctionalData;", "displayPattern", "iotaRepresentation", "Lnet/minecraft/network/chat/Component;", "executeIota", "Lat/petrak/hexcasting/api/spell/casting/ControllerInfo;", "iota", "world", "Lnet/minecraft/server/level/ServerLevel;", "executeIotas", "iotas", "generateDescs", "Lkotlin/Triple;", "Lnet/minecraft/nbt/CompoundTag;", "kotlin.jvm.PlatformType", "getColorizer", "getFunctionalData", "getOperatorForFrame", "Lat/petrak/hexcasting/api/spell/Action;", "frame", "Lat/petrak/hexcasting/api/spell/casting/eval/ContinuationFrame;", "getOperatorForPattern", "getPatternForFrame", "Lat/petrak/hexcasting/api/spell/math/HexPattern;", "getUpdate", "Lat/petrak/hexcasting/api/spell/casting/CastingHarness$CastResult;", "continuation", "Lat/petrak/hexcasting/api/spell/casting/eval/SpellContinuation;", "handleParentheses", "Lkotlin/Pair;", "Lat/petrak/hexcasting/api/spell/casting/ResolvedPatternType;", "performSideEffects", "info", "Lat/petrak/hexcasting/api/spell/casting/CastingHarness$TempControllerInfo;", "sideEffects", "Lat/petrak/hexcasting/api/spell/casting/sideeffects/OperatorSideEffect;", "serializeToNBT", "updateWithPattern", "newPat", "withdrawMedia", "mediaCost", "allowOvercast", "CastResult", "Companion", "TempControllerInfo", "hexcasting-forge-1.19.2"})
public final class CastingHarness {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<Iota> stack;
    @Nullable
    private Iota ravenmind;
    private int parenCount;
    @NotNull
    private List<? extends Iota> parenthesized;
    private boolean escapeNext;
    @NotNull
    private final CastingContext ctx;
    @Nullable
    private final FrozenColorizer prepackagedColorizer;
    @NotNull
    public static final String TAG_STACK = "stack";
    @NotNull
    public static final String TAG_LOCAL = "local";
    @NotNull
    public static final String TAG_PAREN_COUNT = "open_parens";
    @NotNull
    public static final String TAG_PARENTHESIZED = "parenthesized";
    @NotNull
    public static final String TAG_ESCAPE_NEXT = "escape_next";
    @NotNull
    public static final String TAG_PREPACKAGED_COLORIZER = "prepackaged_colorizer";

    private CastingHarness(List<Iota> stack, Iota ravenmind, int parenCount, List<? extends Iota> parenthesized, boolean escapeNext, CastingContext ctx, FrozenColorizer prepackagedColorizer) {
        this.stack = stack;
        this.ravenmind = ravenmind;
        this.parenCount = parenCount;
        this.parenthesized = parenthesized;
        this.escapeNext = escapeNext;
        this.ctx = ctx;
        this.prepackagedColorizer = prepackagedColorizer;
    }

    @NotNull
    public final List<Iota> getStack() {
        return this.stack;
    }

    public final void setStack(@NotNull List<Iota> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.stack = list;
    }

    @Nullable
    public final Iota getRavenmind() {
        return this.ravenmind;
    }

    public final void setRavenmind(@Nullable Iota iota) {
        this.ravenmind = iota;
    }

    public final int getParenCount() {
        return this.parenCount;
    }

    public final void setParenCount(int n) {
        this.parenCount = n;
    }

    @NotNull
    public final List<Iota> getParenthesized() {
        return this.parenthesized;
    }

    public final void setParenthesized(@NotNull List<? extends Iota> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.parenthesized = list;
    }

    public final boolean getEscapeNext() {
        return this.escapeNext;
    }

    public final void setEscapeNext(boolean bl) {
        this.escapeNext = bl;
    }

    @NotNull
    public final CastingContext getCtx() {
        return this.ctx;
    }

    @Nullable
    public final FrozenColorizer getPrepackagedColorizer() {
        return this.prepackagedColorizer;
    }

    @JvmOverloads
    public CastingHarness(@NotNull CastingContext ctx, @Nullable FrozenColorizer prepackagedColorizer) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this(new ArrayList(), null, 0, new ArrayList(), false, ctx, prepackagedColorizer);
    }

    public /* synthetic */ CastingHarness(CastingContext castingContext, FrozenColorizer frozenColorizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            frozenColorizer = null;
        }
        this(castingContext, frozenColorizer);
    }

    @NotNull
    public final ControllerInfo executeIota(@NotNull Iota iota, @NotNull ServerLevel world) {
        Intrinsics.checkNotNullParameter((Object)iota, (String)"iota");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return this.executeIotas(CollectionsKt.listOf((Object)iota), world);
    }

    private final void displayPattern(boolean escapeNext, int parenCount, Component iotaRepresentation) {
        if (this.ctx.getDebugPatterns()) {
            MutableComponent display = HexUtils.getAsTextComponent(StringsKt.repeat((CharSequence)"  ", (int)parenCount));
            if (escapeNext) {
                display.m_7220_((Component)HexUtils.getGold(HexUtils.getAsTextComponent("\\ ")));
            }
            display.m_7220_(iotaRepresentation);
            this.ctx.getCaster().m_213846_((Component)display);
        }
    }

    private final Action getOperatorForPattern(Iota iota, ServerLevel world) {
        if (iota instanceof PatternIota) {
            return PatternRegistry.matchPattern(((PatternIota)iota).getPattern(), world);
        }
        return null;
    }

    private final HexPattern getPatternForFrame(ContinuationFrame frame) {
        if (!(frame instanceof FrameEvaluate)) {
            return null;
        }
        Iota iota = ((FrameEvaluate)frame).getList().getCar();
        PatternIota patternIota = iota instanceof PatternIota ? (PatternIota)iota : null;
        return patternIota != null ? patternIota.getPattern() : null;
    }

    private final Action getOperatorForFrame(ContinuationFrame frame, ServerLevel world) {
        if (!(frame instanceof FrameEvaluate)) {
            return null;
        }
        return this.getOperatorForPattern(((FrameEvaluate)frame).getList().getCar(), world);
    }

    @NotNull
    public final ControllerInfo executeIotas(@NotNull List<? extends Iota> iotas, @NotNull ServerLevel world) {
        Intrinsics.checkNotNullParameter(iotas, (String)"iotas");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        SpellContinuation continuation = SpellContinuation.Done.INSTANCE.pushFrame(new FrameEvaluate(new SpellList.LList(0, iotas), false));
        TempControllerInfo info = new TempControllerInfo(false);
        ResolvedPatternType lastResolutionType = ResolvedPatternType.UNRESOLVED;
        EvalSound sound = HexEvalSounds.NOTHING;
        while (continuation instanceof SpellContinuation.NotDone && !info.getEarlyExit()) {
            CastResult castResult;
            ContinuationFrame next = ((SpellContinuation.NotDone)continuation).getFrame();
            try {
                castResult = next.evaluate(((SpellContinuation.NotDone)continuation).getNext(), world, this);
            }
            catch (Mishap mishap) {
                Action action;
                HexPattern pattern = this.getPatternForFrame(next);
                try {
                    action = this.getOperatorForFrame(next, world);
                }
                catch (Throwable e) {
                    action = null;
                }
                Action operator = action;
                ResolvedPatternType resolvedPatternType = mishap.resolutionType(this.ctx);
                HexPattern hexPattern = pattern;
                if (hexPattern == null) {
                    hexPattern = new HexPattern(HexDir.WEST, null, 2, null);
                }
                List list = CollectionsKt.listOf((Object)new OperatorSideEffect.DoMishap(mishap, new Mishap.Context(hexPattern, operator)));
                EvalSound evalSound = HexEvalSounds.MISHAP;
                Intrinsics.checkNotNullExpressionValue((Object)evalSound, (String)"MISHAP");
                castResult = new CastResult(continuation, null, resolvedPatternType, list, evalSound);
            }
            CastResult result = castResult;
            if (result.getNewData() != null) {
                this.applyFunctionalData(result.getNewData());
            }
            continuation = result.getContinuation();
            lastResolutionType = result.getResolutionType();
            this.performSideEffects(info, result.getSideEffects());
            info.setEarlyExit(info.getEarlyExit() || !lastResolutionType.getSuccess());
            sound = Intrinsics.areEqual((Object)result.getSound(), (Object)HexEvalSounds.MISHAP) ? HexEvalSounds.MISHAP : sound.greaterOf(result.getSound());
        }
        SoundEvent soundEvent = sound.sound();
        if (soundEvent != null) {
            SoundEvent it = soundEvent;
            boolean bl = false;
            this.ctx.getWorld().m_6263_(null, this.ctx.getPosition().f_82479_, this.ctx.getPosition().f_82480_, this.ctx.getPosition().f_82481_, it, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.ctx.getWorld().m_220400_((Entity)this.ctx.getCaster(), GameEvent.f_223697_, this.ctx.getPosition());
        }
        if (continuation instanceof SpellContinuation.NotDone) {
            lastResolutionType = lastResolutionType.getSuccess() ? ResolvedPatternType.EVALUATED : ResolvedPatternType.ERRORED;
        }
        Triple<List<CompoundTag>, List<CompoundTag>, CompoundTag> triple = this.generateDescs();
        List stackDescs = (List)triple.component1();
        List parenDescs = (List)triple.component2();
        CompoundTag ravenmind = (CompoundTag)triple.component3();
        return new ControllerInfo(this.stack.isEmpty() && this.parenCount == 0 && !this.escapeNext, lastResolutionType, stackDescs, parenDescs, ravenmind, this.parenCount);
    }

    @NotNull
    public final CastResult getUpdate(@NotNull Iota iota, @NotNull ServerLevel world, @NotNull SpellContinuation continuation) {
        Intrinsics.checkNotNullParameter((Object)iota, (String)"iota");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
        try {
            kotlin.Pair<FunctionalData, ResolvedPatternType> pair = this.handleParentheses(iota);
            if (pair != null) {
                kotlin.Pair<FunctionalData, ResolvedPatternType> pair2 = pair;
                boolean bl = false;
                FunctionalData data = (FunctionalData)pair2.component1();
                ResolvedPatternType resolutionType = (ResolvedPatternType)((Object)pair2.component2());
                List list = CollectionsKt.emptyList();
                EvalSound evalSound = HexEvalSounds.OPERATOR;
                Intrinsics.checkNotNullExpressionValue((Object)evalSound, (String)"OPERATOR");
                return new CastResult(continuation, data, resolutionType, list, evalSound);
            }
            if (iota instanceof PatternIota) {
                HexPattern hexPattern = ((PatternIota)iota).getPattern();
                Intrinsics.checkNotNullExpressionValue((Object)hexPattern, (String)"iota.pattern");
                return this.updateWithPattern(hexPattern, world, continuation);
            }
            List list = CollectionsKt.listOf((Object)new OperatorSideEffect.DoMishap(new MishapUnescapedValue(iota), new Mishap.Context(new HexPattern(HexDir.WEST, null, 2, null), null)));
            EvalSound evalSound = HexEvalSounds.MISHAP;
            Intrinsics.checkNotNullExpressionValue((Object)evalSound, (String)"MISHAP");
            return new CastResult(continuation, null, ResolvedPatternType.INVALID, list, evalSound);
        }
        catch (Mishap mishap) {
            Action action;
            try {
                action = this.getOperatorForPattern(iota, world);
            }
            catch (Throwable e) {
                action = null;
            }
            Action operator = action;
            ResolvedPatternType resolvedPatternType = mishap.resolutionType(this.ctx);
            PatternIota patternIota = iota instanceof PatternIota ? (PatternIota)iota : null;
            HexPattern hexPattern = patternIota != null ? patternIota.getPattern() : null;
            if (hexPattern == null) {
                hexPattern = new HexPattern(HexDir.WEST, null, 2, null);
            }
            List list = CollectionsKt.listOf((Object)new OperatorSideEffect.DoMishap(mishap, new Mishap.Context(hexPattern, operator)));
            EvalSound evalSound = HexEvalSounds.MISHAP;
            Intrinsics.checkNotNullExpressionValue((Object)evalSound, (String)"MISHAP");
            return new CastResult(continuation, null, resolvedPatternType, list, evalSound);
        }
        catch (Exception exception) {
            Action action;
            exception.printStackTrace();
            try {
                action = this.getOperatorForPattern(iota, world);
            }
            catch (Throwable e) {
                action = null;
            }
            Action operator = action;
            Mishap mishap = new MishapError(exception);
            PatternIota patternIota = iota instanceof PatternIota ? (PatternIota)iota : null;
            HexPattern hexPattern = patternIota != null ? patternIota.getPattern() : null;
            if (hexPattern == null) {
                hexPattern = new HexPattern(HexDir.WEST, null, 2, null);
            }
            List list = CollectionsKt.listOf((Object)new OperatorSideEffect.DoMishap(mishap, new Mishap.Context(hexPattern, operator)));
            EvalSound evalSound = HexEvalSounds.MISHAP;
            Intrinsics.checkNotNullExpressionValue((Object)evalSound, (String)"MISHAP");
            return new CastResult(continuation, null, ResolvedPatternType.ERRORED, list, evalSound);
        }
    }

    @NotNull
    public final CastResult updateWithPattern(@NotNull HexPattern newPat, @NotNull ServerLevel world, @NotNull SpellContinuation continuation) {
        Intrinsics.checkNotNullParameter((Object)newPat, (String)"newPat");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
        kotlin.Pair actionIdPair = null;
        try {
            Pair<Action, ResourceLocation> mojangPair = PatternRegistry.matchPatternAndID(newPat, world);
            actionIdPair = TuplesKt.to((Object)mojangPair.getFirst(), (Object)mojangPair.getSecond());
            if (this.ctx.getSpellCircle() == null && !HexConfig.server().isActionAllowed((ResourceLocation)actionIdPair.getSecond())) {
                throw new MishapDisallowedSpell(null, 1, null);
            }
            if (this.ctx.getSpellCircle() != null && !HexConfig.server().isActionAllowedInCircles((ResourceLocation)actionIdPair.getSecond())) {
                throw new MishapDisallowedSpell("disallowed_circle");
            }
            Action pattern = (Action)actionIdPair.getFirst();
            boolean unenlightened = pattern.isGreat() && !this.ctx.isCasterEnlightened();
            List sideEffects = new ArrayList();
            List<Iota> stack2 = null;
            SpellContinuation cont2 = continuation;
            Iota ravenmind2 = null;
            if (!unenlightened || pattern.getAlwaysProcessGreatSpell()) {
                this.displayPattern(false, 0, pattern.getDisplayName());
                OperationResult result = pattern.operate(continuation, CollectionsKt.toMutableList((Collection)this.stack), this.ravenmind, this.ctx);
                cont2 = result.getNewContinuation();
                stack2 = result.getNewStack();
                ravenmind2 = result.getNewRavenmind();
                sideEffects.addAll((Collection)result.getSideEffects());
            }
            if (unenlightened) {
                sideEffects.add(new OperatorSideEffect.RequiredEnlightenment(pattern.getCausesBlindDiversion()));
            }
            if (this.ctx.getSpellCircle() == null) {
                sideEffects.add(new OperatorSideEffect.Particles(new ParticleSpray(this.ctx.getPosition(), new Vec3(0.0, 1.0, 0.0), 0.5, 1.0, 0, 16, null)));
            }
            FunctionalData hereFd = this.getFunctionalData();
            FunctionalData fd = stack2 != null ? FunctionalData.copy$default(hereFd, stack2, 0, null, false, ravenmind2, 14, null) : hereFd;
            EvalSound soundType = this.ctx.getSource() == CastingContext.CastSource.STAFF ? HexEvalSounds.OPERATOR : HexEvalSounds.NOTHING;
            for (OperatorSideEffect se : sideEffects) {
                if (se instanceof OperatorSideEffect.AttemptSpell) {
                    soundType = ((OperatorSideEffect.AttemptSpell)se).getHasCastingSound() ? soundType.greaterOf(HexEvalSounds.SPELL) : HexEvalSounds.NOTHING;
                    continue;
                }
                if (!(se instanceof OperatorSideEffect.DoMishap)) continue;
                soundType = HexEvalSounds.MISHAP;
            }
            EvalSound evalSound = soundType;
            Intrinsics.checkNotNullExpressionValue((Object)evalSound, (String)"soundType");
            return new CastResult(cont2, fd, ResolvedPatternType.EVALUATED, sideEffects, evalSound);
        }
        catch (Mishap mishap) {
            ResolvedPatternType resolvedPatternType = mishap.resolutionType(this.ctx);
            kotlin.Pair pair = actionIdPair;
            List list = CollectionsKt.listOf((Object)new OperatorSideEffect.DoMishap(mishap, new Mishap.Context(newPat, pair != null ? (Action)pair.getFirst() : null)));
            EvalSound evalSound = HexEvalSounds.MISHAP;
            Intrinsics.checkNotNullExpressionValue((Object)evalSound, (String)"MISHAP");
            return new CastResult(continuation, null, resolvedPatternType, list, evalSound);
        }
    }

    public final void performSideEffects(@NotNull TempControllerInfo info, @NotNull List<? extends OperatorSideEffect> sideEffects) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter(sideEffects, (String)"sideEffects");
        for (OperatorSideEffect operatorSideEffect : sideEffects) {
            boolean mustStop = operatorSideEffect.performEffect(this);
            if (!mustStop) continue;
            info.setEarlyExit(true);
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Triple<List<CompoundTag>, List<CompoundTag>, CompoundTag> generateDescs() {
        CompoundTag compoundTag;
        Collection collection;
        Iota p0;
        Collection collection2;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.stack;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            Iota iota = (Iota)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(HexIotaTypes.serialize(p0));
        }
        $this$map$iv = this.parenthesized;
        collection2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            p0 = (Iota)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(HexIotaTypes.serialize(p0));
        }
        Collection collection3 = (List)destination$iv$iv;
        Collection collection4 = collection2;
        Iota iota = this.ravenmind;
        if (iota != null) {
            void p02;
            $this$mapTo$iv$iv = iota;
            collection = collection3;
            collection2 = collection4;
            boolean bl = false;
            CompoundTag compoundTag2 = HexIotaTypes.serialize((Iota)p02);
            collection4 = collection2;
            collection3 = collection;
            compoundTag = compoundTag2;
        } else {
            compoundTag = null;
        }
        CompoundTag compoundTag3 = compoundTag;
        List list = collection3;
        Collection collection5 = collection4;
        return new Triple((Object)collection5, (Object)list, (Object)compoundTag3);
    }

    @NotNull
    public final FunctionalData getFunctionalData() {
        return new FunctionalData(CollectionsKt.toList((Iterable)this.stack), this.parenCount, CollectionsKt.toList((Iterable)this.parenthesized), this.escapeNext, this.ravenmind);
    }

    public final void applyFunctionalData(@NotNull FunctionalData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.stack.clear();
        this.stack.addAll((Collection<Iota>)data.getStack());
        this.parenCount = data.getParenCount();
        this.parenthesized = data.getParenthesized();
        this.escapeNext = data.getEscapeNext();
        this.ravenmind = data.getRavenmind();
    }

    private final kotlin.Pair<FunctionalData, ResolvedPatternType> handleParentheses(Iota iota) {
        kotlin.Pair out;
        Object object = iota instanceof PatternIota ? (PatternIota)iota : null;
        String sig = object != null && (object = ((PatternIota)object).getPattern()) != null ? ((HexPattern)object).anglesSignature() : null;
        int displayDepth = this.parenCount;
        if (this.parenCount > 0) {
            if (this.escapeNext) {
                newParens = CollectionsKt.toMutableList((Collection)this.parenthesized);
                newParens.add(iota);
                v1 = TuplesKt.to((Object)FunctionalData.copy$default(this.getFunctionalData(), null, 0, (List)newParens, false, null, 19, null), (Object)((Object)ResolvedPatternType.ESCAPED));
            } else {
                newParens = sig;
                if (Intrinsics.areEqual((Object)newParens, (Object)SpecialPatterns.CONSIDERATION.anglesSignature())) {
                    v1 = TuplesKt.to((Object)FunctionalData.copy$default(this.getFunctionalData(), null, 0, null, true, null, 23, null), (Object)((Object)ResolvedPatternType.EVALUATED));
                } else if (Intrinsics.areEqual((Object)newParens, (Object)SpecialPatterns.INTROSPECTION.anglesSignature())) {
                    newParens = CollectionsKt.toMutableList((Collection)this.parenthesized);
                    newParens.add(iota);
                    FunctionalData functionalData = this.getFunctionalData();
                    int n = this.parenCount + 1;
                    v1 = TuplesKt.to((Object)FunctionalData.copy$default(functionalData, null, n, newParens, false, null, 25, null), (Object)((Object)(this.parenCount == 0 ? ResolvedPatternType.EVALUATED : ResolvedPatternType.ESCAPED)));
                } else if (Intrinsics.areEqual((Object)newParens, (Object)SpecialPatterns.RETROSPECTION.anglesSignature())) {
                    int newParenCount = this.parenCount - 1;
                    --displayDepth;
                    if (newParenCount == 0) {
                        List newStack = CollectionsKt.toMutableList((Collection)this.stack);
                        newStack.add(new ListIota(CollectionsKt.toList((Iterable)this.parenthesized)));
                        v1 = TuplesKt.to((Object)FunctionalData.copy$default(this.getFunctionalData(), newStack, newParenCount, CollectionsKt.emptyList(), false, null, 24, null), (Object)((Object)ResolvedPatternType.EVALUATED));
                    } else {
                        if (newParenCount < 0) {
                            throw new MishapTooManyCloseParens();
                        }
                        List newParens = CollectionsKt.toMutableList((Collection)this.parenthesized);
                        newParens.add(iota);
                        v1 = TuplesKt.to((Object)FunctionalData.copy$default(this.getFunctionalData(), null, newParenCount, newParens, false, null, 25, null), (Object)((Object)ResolvedPatternType.ESCAPED));
                    }
                } else {
                    newParens = CollectionsKt.toMutableList((Collection)this.parenthesized);
                    newParens.add(iota);
                    v1 = TuplesKt.to((Object)FunctionalData.copy$default(this.getFunctionalData(), null, 0, newParens, false, null, 27, null), (Object)((Object)ResolvedPatternType.ESCAPED));
                }
            }
        } else if (this.escapeNext) {
            newStack = CollectionsKt.toMutableList((Collection)this.stack);
            newStack.add(iota);
            v1 = TuplesKt.to((Object)FunctionalData.copy$default(this.getFunctionalData(), (List)newStack, 0, null, false, null, 22, null), (Object)((Object)ResolvedPatternType.ESCAPED));
        } else {
            newStack = sig;
            if (Intrinsics.areEqual((Object)newStack, (Object)SpecialPatterns.CONSIDERATION.anglesSignature())) {
                v1 = TuplesKt.to((Object)FunctionalData.copy$default(this.getFunctionalData(), null, 0, null, true, null, 23, null), (Object)((Object)ResolvedPatternType.EVALUATED));
            } else if (Intrinsics.areEqual((Object)newStack, (Object)SpecialPatterns.INTROSPECTION.anglesSignature())) {
                v1 = TuplesKt.to((Object)FunctionalData.copy$default(this.getFunctionalData(), null, this.parenCount + 1, null, false, null, 29, null), (Object)((Object)ResolvedPatternType.EVALUATED));
            } else {
                if (Intrinsics.areEqual((Object)newStack, (Object)SpecialPatterns.RETROSPECTION.anglesSignature())) {
                    throw new MishapTooManyCloseParens();
                }
                v1 = out = (kotlin.Pair)null;
            }
        }
        if (out != null) {
            Component display = iota instanceof PatternIota ? (Component)PatternNameHelper.representationForPattern(((PatternIota)iota).getPattern()).m_6881_().m_130940_(out.getSecond() == ResolvedPatternType.ESCAPED ? ChatFormatting.YELLOW : ChatFormatting.AQUA) : iota.display();
            Intrinsics.checkNotNullExpressionValue((Object)display, (String)"display");
            this.displayPattern(this.escapeNext, displayDepth, display);
        }
        return out;
    }

    public final int withdrawMedia(int mediaCost, boolean allowOvercast) {
        if (mediaCost <= 0) {
            return 0;
        }
        int costLeft = mediaCost;
        boolean fake = this.ctx.getCaster().m_7500_();
        if (this.ctx.getSpellCircle() != null) {
            if (fake) {
                return 0;
            }
            BlockEntity tile = this.ctx.getWorld().m_7702_(this.ctx.getSpellCircle().getImpetusPos());
            if (tile instanceof BlockEntityAbstractImpetus) {
                int mediaAvailable = ((BlockEntityAbstractImpetus)tile).getMedia();
                if (mediaAvailable < 0) {
                    return 0;
                }
                int mediaToTake = Math.min(costLeft, mediaAvailable);
                costLeft -= mediaToTake;
                ((BlockEntityAbstractImpetus)tile).setMedia(mediaAvailable - mediaToTake);
            }
        } else {
            boolean hexHolderDrawsFromInventory;
            ItemStack casterStack = this.ctx.getCaster().m_21120_(this.ctx.getCastingHand());
            ADMediaHolder casterMediaHolder = IXplatAbstractions.INSTANCE.findMediaHolder(casterStack);
            ADHexHolder casterHexHolder = IXplatAbstractions.INSTANCE.findHexHolder(casterStack);
            if (casterHexHolder != null) {
                if (casterMediaHolder != null) {
                    int mediaAvailable = casterMediaHolder.withdrawMedia(-1, true);
                    int mediaToTake = Math.min(costLeft, mediaAvailable);
                    if (!fake) {
                        casterMediaHolder.withdrawMedia(mediaToTake, false);
                    }
                    costLeft -= mediaToTake;
                }
                v0 = casterHexHolder.canDrawMediaFromInventory();
            } else {
                v0 = hexHolderDrawsFromInventory = false;
            }
            if (casterStack.m_204117_(HexTags.Items.STAVES) || hexHolderDrawsFromInventory) {
                List<ADMediaHolder> list = DiscoveryHandlers.collectMediaHolders(this);
                Intrinsics.checkNotNullExpressionValue(list, (String)"collectMediaHolders(this)");
                Iterable iterable = list;
                Comparator comparator = ((Comparator)MediaHelper::compareMediaItem).reversed();
                Intrinsics.checkNotNullExpressionValue(comparator, (String)"::compareMediaItem).reversed()");
                List mediaSources = CollectionsKt.sortedWith((Iterable)iterable, comparator);
                for (ADMediaHolder source : mediaSources) {
                    Intrinsics.checkNotNullExpressionValue((Object)source, (String)"source");
                    if ((costLeft -= MediaHelper.extractMedia$default(source, costLeft, false, fake, 4, null)) > 0) continue;
                }
                if (allowOvercast && costLeft > 0) {
                    int n;
                    double mediaToHealth = HexConfig.common().mediaToHealthRate();
                    double healthToRemove = Math.max((double)costLeft / mediaToHealth, 0.5);
                    double mediaAbleToCastFromHP = (double)this.ctx.getCaster().m_21223_() * mediaToHealth;
                    int mediaToActuallyPayFor = Math.min((int)mediaAbleToCastFromHP, costLeft);
                    if (!fake) {
                        LivingEntity livingEntity = (LivingEntity)this.ctx.getCaster();
                        DamageSourceOvercast damageSourceOvercast = HexDamageSources.OVERCAST;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)damageSourceOvercast), (String)"OVERCAST");
                        Mishap.Companion.trulyHurt(livingEntity, damageSourceOvercast, (float)healthToRemove);
                        int actuallyTaken = Mth.m_14165_((double)(mediaAbleToCastFromHP - (double)this.ctx.getCaster().m_21223_() * mediaToHealth));
                        HexAdvancementTriggers.OVERCAST_TRIGGER.trigger(this.ctx.getCaster(), actuallyTaken);
                        this.ctx.getCaster().m_36222_(HexStatistics.MEDIA_OVERCAST, mediaCost - costLeft);
                        n = actuallyTaken;
                    } else {
                        n = mediaToActuallyPayFor;
                    }
                    costLeft -= n;
                }
            }
        }
        if (!fake) {
            this.ctx.getCaster().m_36222_(HexStatistics.MEDIA_USED, mediaCost - costLeft);
            HexAdvancementTriggers.SPEND_MEDIA_TRIGGER.trigger(this.ctx.getCaster(), mediaCost - costLeft, costLeft < 0 ? -costLeft : 0);
        }
        return fake ? 0 : costLeft;
    }

    @NotNull
    public final FrozenColorizer getColorizer() {
        if (this.prepackagedColorizer != null) {
            return this.prepackagedColorizer;
        }
        FrozenColorizer frozenColorizer = IXplatAbstractions.INSTANCE.getColorizer((Player)this.ctx.getCaster());
        Intrinsics.checkNotNullExpressionValue((Object)frozenColorizer, (String)"INSTANCE.getColorizer(this.ctx.caster)");
        return frozenColorizer;
    }

    @NotNull
    public final CompoundTag serializeToNBT() {
        String $this$remAssign$iv;
        CompoundTag compoundTag;
        NBTBuilder this_$iv = NBTBuilder.INSTANCE;
        boolean $i$f$invoke = false;
        NBTBuilder this_$iv$iv = this_$iv;
        boolean $i$f$compound = false;
        CompoundTag $this$serializeToNBT_u24lambda_u244 = compoundTag = NbtCompoundBuilder.constructor-impl(new CompoundTag());
        boolean bl = false;
        String string = TAG_STACK;
        Tag nbt$iv = HexUtils.serializeToNBT((Iterable<? extends Iota>)this.stack);
        boolean bl2 = false;
        $this$serializeToNBT_u24lambda_u244.m_128365_($this$remAssign$iv, nbt$iv);
        if (this.ravenmind != null) {
            $this$remAssign$iv = TAG_LOCAL;
            Iota iota = this.ravenmind;
            Intrinsics.checkNotNull((Object)iota);
            CompoundTag compoundTag2 = HexIotaTypes.serialize(iota);
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag2, (String)"serialize(ravenmind!!)");
            nbt$iv = (Tag)compoundTag2;
            bl2 = false;
            $this$serializeToNBT_u24lambda_u244.m_128365_($this$remAssign$iv, nbt$iv);
        }
        $this$remAssign$iv = TAG_PAREN_COUNT;
        int num$iv = this.parenCount;
        bl2 = false;
        int value$iv$iv = num$iv;
        boolean bl3 = false;
        IntTag intTag = IntTag.m_128679_((int)value$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)intTag, (String)"valueOf(value.toInt())");
        $this$serializeToNBT_u24lambda_u244.m_128365_($this$remAssign$iv, (Tag)intTag);
        $this$remAssign$iv = TAG_ESCAPE_NEXT;
        boolean bool$iv = this.escapeNext;
        bl2 = false;
        value$iv$iv = bool$iv ? 1 : 0;
        boolean bl4 = false;
        ByteTag byteTag = ByteTag.m_128266_((byte)((byte)value$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)byteTag, (String)"valueOf(value.toByte())");
        $this$serializeToNBT_u24lambda_u244.m_128365_($this$remAssign$iv, (Tag)byteTag);
        $this$remAssign$iv = TAG_PARENTHESIZED;
        nbt$iv = HexUtils.serializeToNBT((Iterable<? extends Iota>)this.parenthesized);
        bl2 = false;
        $this$serializeToNBT_u24lambda_u244.m_128365_($this$remAssign$iv, nbt$iv);
        if (this.prepackagedColorizer != null) {
            $this$remAssign$iv = TAG_PREPACKAGED_COLORIZER;
            CompoundTag compoundTag3 = this.prepackagedColorizer.serializeToNBT();
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag3, (String)"prepackagedColorizer.serializeToNBT()");
            nbt$iv = (Tag)compoundTag3;
            bl2 = false;
            $this$serializeToNBT_u24lambda_u244.m_128365_($this$remAssign$iv, nbt$iv);
        }
        return compoundTag;
    }

    @JvmOverloads
    public CastingHarness(@NotNull CastingContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this(ctx, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List _init_$lambda$7(CastingHarness it) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        NonNullList nonNullList = it.ctx.getCaster().m_150109_().f_35974_;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"it.ctx.caster.inventory.items");
        Iterable $this$filter$iv = (Iterable)nonNullList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemStack p0 = (ItemStack)element$iv$iv;
            boolean bl = false;
            if (!MediaHelper.isMediaItem(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        IXplatAbstractions iXplatAbstractions = IXplatAbstractions.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)iXplatAbstractions, (String)"INSTANCE");
        IXplatAbstractions iXplatAbstractions2 = iXplatAbstractions;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ADMediaHolder it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ItemStack p0 = (ItemStack)element$iv$iv;
            boolean bl2 = false;
            if (iXplatAbstractions2.findMediaHolder(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List _init_$lambda$10(CastingHarness it) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        NonNullList nonNullList = it.ctx.getCaster().m_150109_().f_35975_;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"it.ctx.caster.inventory.armor");
        Iterable $this$filter$iv = (Iterable)nonNullList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemStack p0 = (ItemStack)element$iv$iv;
            boolean bl = false;
            if (!MediaHelper.isMediaItem(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        IXplatAbstractions iXplatAbstractions = IXplatAbstractions.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)iXplatAbstractions, (String)"INSTANCE");
        IXplatAbstractions iXplatAbstractions2 = iXplatAbstractions;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ADMediaHolder it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ItemStack p0 = (ItemStack)element$iv$iv;
            boolean bl2 = false;
            if (iXplatAbstractions2.findMediaHolder(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List _init_$lambda$13(CastingHarness it) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        NonNullList nonNullList = it.ctx.getCaster().m_150109_().f_35976_;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"it.ctx.caster.inventory.offhand");
        Iterable $this$filter$iv = (Iterable)nonNullList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemStack p0 = (ItemStack)element$iv$iv;
            boolean bl = false;
            if (!MediaHelper.isMediaItem(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        IXplatAbstractions iXplatAbstractions = IXplatAbstractions.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)iXplatAbstractions, (String)"INSTANCE");
        IXplatAbstractions iXplatAbstractions2 = iXplatAbstractions;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ADMediaHolder it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ItemStack p0 = (ItemStack)element$iv$iv;
            boolean bl2 = false;
            if (iXplatAbstractions2.findMediaHolder(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    @JvmStatic
    @NotNull
    public static final CastingHarness fromNBT(@NotNull CompoundTag nbt, @NotNull CastingContext ctx) {
        return Companion.fromNBT(nbt, ctx);
    }

    public /* synthetic */ CastingHarness(List stack, Iota ravenmind, int parenCount, List parenthesized, boolean escapeNext, CastingContext ctx, FrozenColorizer prepackagedColorizer, DefaultConstructorMarker $constructor_marker) {
        this(stack, ravenmind, parenCount, parenthesized, escapeNext, ctx, prepackagedColorizer);
    }

    static {
        DiscoveryHandlers.addMediaHolderDiscoverer(CastingHarness::_init_$lambda$7);
        DiscoveryHandlers.addMediaHolderDiscoverer(CastingHarness::_init_$lambda$10);
        DiscoveryHandlers.addMediaHolderDiscoverer(CastingHarness::_init_$lambda$13);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lat/petrak/hexcasting/api/spell/casting/CastingHarness$Companion;", "", "()V", "TAG_ESCAPE_NEXT", "", "TAG_LOCAL", "TAG_PARENTHESIZED", "TAG_PAREN_COUNT", "TAG_PREPACKAGED_COLORIZER", "TAG_STACK", "fromNBT", "Lat/petrak/hexcasting/api/spell/casting/CastingHarness;", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "hexcasting-forge-1.19.2"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CastingHarness fromNBT(@NotNull CompoundTag nbt, @NotNull CastingContext ctx) {
            CastingHarness castingHarness;
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            try {
                List stack = new ArrayList();
                ListTag stackTag = NBTHelper.getListByByte(nbt, CastingHarness.TAG_STACK, (byte)10);
                for (Tag subtag : stackTag) {
                    Intrinsics.checkNotNullExpressionValue((Object)subtag, (String)"subtag");
                    Iota datum = HexIotaTypes.deserialize(NBTHelper.getAsCompound(subtag), ctx.getWorld());
                    Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"datum");
                    stack.add(datum);
                }
                Iota ravenmind = nbt.m_128441_(CastingHarness.TAG_LOCAL) ? HexIotaTypes.deserialize(nbt.m_128469_(CastingHarness.TAG_LOCAL), ctx.getWorld()) : null;
                List parenthesized = new ArrayList();
                ListTag parenTag = NBTHelper.getListByByte(nbt, CastingHarness.TAG_PARENTHESIZED, (byte)10);
                for (Tag subtag : parenTag) {
                    Intrinsics.checkNotNullExpressionValue((Object)subtag, (String)"subtag");
                    TagType tagType = CompoundTag.f_128326_;
                    Intrinsics.checkNotNullExpressionValue((Object)tagType, (String)"TYPE");
                    Iota iota = HexIotaTypes.deserialize((CompoundTag)HexUtils.downcast(subtag, tagType), ctx.getWorld());
                    Intrinsics.checkNotNullExpressionValue((Object)iota, (String)"deserialize(subtag.downc\u2026oundTag.TYPE), ctx.world)");
                    parenthesized.add(iota);
                }
                int parenCount = nbt.m_128451_(CastingHarness.TAG_PAREN_COUNT);
                boolean escapeNext = nbt.m_128471_(CastingHarness.TAG_ESCAPE_NEXT);
                FrozenColorizer colorizer = nbt.m_128441_(CastingHarness.TAG_PREPACKAGED_COLORIZER) ? FrozenColorizer.fromNBT(nbt.m_128469_(CastingHarness.TAG_PREPACKAGED_COLORIZER)) : (FrozenColorizer)null;
                castingHarness = new CastingHarness(stack, ravenmind, parenCount, parenthesized, escapeNext, ctx, colorizer, null);
            }
            catch (Exception exn) {
                castingHarness = new CastingHarness(ctx, null, 2, null);
            }
            return castingHarness;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0010"}, d2={"Lat/petrak/hexcasting/api/spell/casting/CastingHarness$TempControllerInfo;", "", "earlyExit", "", "(Z)V", "getEarlyExit", "()Z", "setEarlyExit", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "hexcasting-forge-1.19.2"})
    public static final class TempControllerInfo {
        private boolean earlyExit;

        public TempControllerInfo(boolean earlyExit) {
            this.earlyExit = earlyExit;
        }

        public final boolean getEarlyExit() {
            return this.earlyExit;
        }

        public final void setEarlyExit(boolean bl) {
            this.earlyExit = bl;
        }

        public final boolean component1() {
            return this.earlyExit;
        }

        @NotNull
        public final TempControllerInfo copy(boolean earlyExit) {
            return new TempControllerInfo(earlyExit);
        }

        public static /* synthetic */ TempControllerInfo copy$default(TempControllerInfo tempControllerInfo, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = tempControllerInfo.earlyExit;
            }
            return tempControllerInfo.copy(bl);
        }

        @NotNull
        public String toString() {
            return "TempControllerInfo(earlyExit=" + this.earlyExit + ")";
        }

        public int hashCode() {
            int n = this.earlyExit ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TempControllerInfo)) {
                return false;
            }
            TempControllerInfo tempControllerInfo = (TempControllerInfo)other;
            return this.earlyExit == tempControllerInfo.earlyExit;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\fH\u00c6\u0003JC\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lat/petrak/hexcasting/api/spell/casting/CastingHarness$CastResult;", "", "continuation", "Lat/petrak/hexcasting/api/spell/casting/eval/SpellContinuation;", "newData", "Lat/petrak/hexcasting/api/spell/casting/eval/FunctionalData;", "resolutionType", "Lat/petrak/hexcasting/api/spell/casting/ResolvedPatternType;", "sideEffects", "", "Lat/petrak/hexcasting/api/spell/casting/sideeffects/OperatorSideEffect;", "sound", "Lat/petrak/hexcasting/api/spell/casting/sideeffects/EvalSound;", "(Lat/petrak/hexcasting/api/spell/casting/eval/SpellContinuation;Lat/petrak/hexcasting/api/spell/casting/eval/FunctionalData;Lat/petrak/hexcasting/api/spell/casting/ResolvedPatternType;Ljava/util/List;Lat/petrak/hexcasting/api/spell/casting/sideeffects/EvalSound;)V", "getContinuation", "()Lat/petrak/hexcasting/api/spell/casting/eval/SpellContinuation;", "getNewData", "()Lat/petrak/hexcasting/api/spell/casting/eval/FunctionalData;", "getResolutionType", "()Lat/petrak/hexcasting/api/spell/casting/ResolvedPatternType;", "getSideEffects", "()Ljava/util/List;", "getSound", "()Lat/petrak/hexcasting/api/spell/casting/sideeffects/EvalSound;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "hexcasting-forge-1.19.2"})
    public static final class CastResult {
        @NotNull
        private final SpellContinuation continuation;
        @Nullable
        private final FunctionalData newData;
        @NotNull
        private final ResolvedPatternType resolutionType;
        @NotNull
        private final List<OperatorSideEffect> sideEffects;
        @NotNull
        private final EvalSound sound;

        public CastResult(@NotNull SpellContinuation continuation, @Nullable FunctionalData newData, @NotNull ResolvedPatternType resolutionType, @NotNull List<? extends OperatorSideEffect> sideEffects, @NotNull EvalSound sound) {
            Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
            Intrinsics.checkNotNullParameter((Object)((Object)resolutionType), (String)"resolutionType");
            Intrinsics.checkNotNullParameter(sideEffects, (String)"sideEffects");
            Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
            this.continuation = continuation;
            this.newData = newData;
            this.resolutionType = resolutionType;
            this.sideEffects = sideEffects;
            this.sound = sound;
        }

        @NotNull
        public final SpellContinuation getContinuation() {
            return this.continuation;
        }

        @Nullable
        public final FunctionalData getNewData() {
            return this.newData;
        }

        @NotNull
        public final ResolvedPatternType getResolutionType() {
            return this.resolutionType;
        }

        @NotNull
        public final List<OperatorSideEffect> getSideEffects() {
            return this.sideEffects;
        }

        @NotNull
        public final EvalSound getSound() {
            return this.sound;
        }

        @NotNull
        public final SpellContinuation component1() {
            return this.continuation;
        }

        @Nullable
        public final FunctionalData component2() {
            return this.newData;
        }

        @NotNull
        public final ResolvedPatternType component3() {
            return this.resolutionType;
        }

        @NotNull
        public final List<OperatorSideEffect> component4() {
            return this.sideEffects;
        }

        @NotNull
        public final EvalSound component5() {
            return this.sound;
        }

        @NotNull
        public final CastResult copy(@NotNull SpellContinuation continuation, @Nullable FunctionalData newData, @NotNull ResolvedPatternType resolutionType, @NotNull List<? extends OperatorSideEffect> sideEffects, @NotNull EvalSound sound) {
            Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
            Intrinsics.checkNotNullParameter((Object)((Object)resolutionType), (String)"resolutionType");
            Intrinsics.checkNotNullParameter(sideEffects, (String)"sideEffects");
            Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
            return new CastResult(continuation, newData, resolutionType, sideEffects, sound);
        }

        public static /* synthetic */ CastResult copy$default(CastResult castResult, SpellContinuation spellContinuation, FunctionalData functionalData, ResolvedPatternType resolvedPatternType, List list, EvalSound evalSound, int n, Object object) {
            if ((n & 1) != 0) {
                spellContinuation = castResult.continuation;
            }
            if ((n & 2) != 0) {
                functionalData = castResult.newData;
            }
            if ((n & 4) != 0) {
                resolvedPatternType = castResult.resolutionType;
            }
            if ((n & 8) != 0) {
                list = castResult.sideEffects;
            }
            if ((n & 0x10) != 0) {
                evalSound = castResult.sound;
            }
            return castResult.copy(spellContinuation, functionalData, resolvedPatternType, list, evalSound);
        }

        @NotNull
        public String toString() {
            return "CastResult(continuation=" + this.continuation + ", newData=" + this.newData + ", resolutionType=" + this.resolutionType + ", sideEffects=" + this.sideEffects + ", sound=" + this.sound + ")";
        }

        public int hashCode() {
            int result = this.continuation.hashCode();
            result = result * 31 + (this.newData == null ? 0 : this.newData.hashCode());
            result = result * 31 + this.resolutionType.hashCode();
            result = result * 31 + ((Object)this.sideEffects).hashCode();
            result = result * 31 + this.sound.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CastResult)) {
                return false;
            }
            CastResult castResult = (CastResult)other;
            if (!Intrinsics.areEqual((Object)this.continuation, (Object)castResult.continuation)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.newData, (Object)castResult.newData)) {
                return false;
            }
            if (this.resolutionType != castResult.resolutionType) {
                return false;
            }
            if (!Intrinsics.areEqual(this.sideEffects, castResult.sideEffects)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.sound, (Object)castResult.sound);
        }
    }
}

